/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DefaultSkipListWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FormatPostingsFieldsConsumer;
import org.apache.lucene.index.FormatPostingsTermsConsumer;
import org.apache.lucene.index.FormatPostingsTermsWriter;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermInfosWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.IOUtils;

final class FormatPostingsFieldsWriter
extends FormatPostingsFieldsConsumer {
    final Directory dir;
    final String segment;
    TermInfosWriter termsOut;
    final FieldInfos fieldInfos;
    FormatPostingsTermsWriter termsWriter;
    final DefaultSkipListWriter skipListWriter;
    final int totalNumDocs;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FormatPostingsFieldsWriter(SegmentWriteState state2, FieldInfos fieldInfos) throws IOException {
        this.dir = state2.directory;
        this.segment = state2.segmentName;
        this.totalNumDocs = state2.numDocs;
        this.fieldInfos = fieldInfos;
        boolean success2 = false;
        try {
            this.termsOut = new TermInfosWriter(this.dir, this.segment, fieldInfos, state2.termIndexInterval);
            this.skipListWriter = new DefaultSkipListWriter(this.termsOut.skipInterval, this.termsOut.maxSkipLevels, this.totalNumDocs, null, null);
            this.termsWriter = new FormatPostingsTermsWriter(state2, this);
            return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (success2) throw throwable;
            IOUtils.closeWhileHandlingException(this.termsOut, this.termsWriter);
            throw throwable;
        }
    }

    FormatPostingsTermsConsumer addField(FieldInfo field2) {
        this.termsWriter.setField(field2);
        return this.termsWriter;
    }

    void finish() throws IOException {
        IOUtils.close(this.termsOut, this.termsWriter);
    }
}

