/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;

class CompoundFileReader
extends Directory {
    private int readBufferSize;
    private Directory directory;
    private String fileName;
    private IndexInput stream;
    private HashMap<String, FileEntry> entries = new HashMap();

    public CompoundFileReader(Directory dir, String name2) throws IOException {
        this(dir, name2, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CompoundFileReader(Directory dir, String name2, int readBufferSize) throws IOException {
        assert (!(dir instanceof CompoundFileReader)) : "compound file inside of compound file: " + name2;
        this.directory = dir;
        this.fileName = name2;
        this.readBufferSize = readBufferSize;
        boolean success2 = false;
        try {
            boolean stripSegmentName;
            int count2;
            this.stream = dir.openInput(name2, readBufferSize);
            int firstInt = this.stream.readVInt();
            if (firstInt < 0) {
                if (firstInt < -1) {
                    throw new CorruptIndexException("Incompatible format version: " + firstInt + " expected " + -1 + " (resource: " + this.stream + ")");
                }
                count2 = this.stream.readVInt();
                stripSegmentName = false;
            } else {
                count2 = firstInt;
                stripSegmentName = true;
            }
            FileEntry entry = null;
            for (int i2 = 0; i2 < count2; ++i2) {
                long offset2 = this.stream.readLong();
                String id2 = this.stream.readString();
                if (stripSegmentName) {
                    id2 = IndexFileNames.stripSegmentName(id2);
                }
                if (entry != null) {
                    entry.length = offset2 - entry.offset;
                }
                entry = new FileEntry();
                entry.offset = offset2;
                this.entries.put(id2, entry);
            }
            if (entry != null) {
                entry.length = this.stream.length() - entry.offset;
            }
            success2 = true;
            Object var14_12 = null;
            if (success2) return;
            if (this.stream == null) return;
        }
        catch (Throwable throwable) {
            Object var14_13 = null;
            if (success2 || this.stream == null) throw throwable;
            try {
                this.stream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.stream.close();
            return;
        }
        catch (IOException e) {}
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public String getName() {
        return this.fileName;
    }

    public synchronized void close() throws IOException {
        if (this.stream == null) {
            return;
        }
        this.entries.clear();
        this.stream.close();
        this.stream = null;
    }

    public synchronized IndexInput openInput(String id2) throws IOException {
        return this.openInput(id2, this.readBufferSize);
    }

    public synchronized IndexInput openInput(String id2, int readBufferSize) throws IOException {
        if (this.stream == null) {
            throw new IOException("Stream closed");
        }
        FileEntry entry = this.entries.get(id2 = IndexFileNames.stripSegmentName(id2));
        if (entry == null) {
            throw new FileNotFoundException("No sub-file with id " + id2 + " found (fileName=" + this.fileName + " files: " + this.entries.keySet() + ")");
        }
        return new CSIndexInput(this.stream, entry.offset, entry.length, readBufferSize);
    }

    public String[] listAll() {
        String[] res = this.entries.keySet().toArray(new String[this.entries.size()]);
        String seg = this.fileName.substring(0, this.fileName.indexOf(46));
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = seg + res[i2];
        }
        return res;
    }

    public boolean fileExists(String name2) {
        return this.entries.containsKey(IndexFileNames.stripSegmentName(name2));
    }

    public long fileModified(String name2) throws IOException {
        return this.directory.fileModified(this.fileName);
    }

    @Deprecated
    public void touchFile(String name2) throws IOException {
        this.directory.touchFile(this.fileName);
    }

    public void deleteFile(String name2) {
        throw new UnsupportedOperationException();
    }

    public void renameFile(String from, String to) {
        throw new UnsupportedOperationException();
    }

    public long fileLength(String name2) throws IOException {
        FileEntry e = this.entries.get(IndexFileNames.stripSegmentName(name2));
        if (e == null) {
            throw new FileNotFoundException(name2);
        }
        return e.length;
    }

    public IndexOutput createOutput(String name2) {
        throw new UnsupportedOperationException();
    }

    public Lock makeLock(String name2) {
        throw new UnsupportedOperationException();
    }

    static final class CSIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        CSIndexInput(IndexInput base, long fileOffset, long length2) {
            this(base, fileOffset, length2, 1024);
        }

        CSIndexInput(IndexInput base, long fileOffset, long length2, int readBufferSize) {
            super(readBufferSize);
            this.base = (IndexInput)base.clone();
            this.fileOffset = fileOffset;
            this.length = length2;
        }

        public Object clone() {
            CSIndexInput clone = (CSIndexInput)super.clone();
            clone.base = (IndexInput)this.base.clone();
            clone.fileOffset = this.fileOffset;
            clone.length = this.length;
            return clone;
        }

        protected void readInternal(byte[] b, int offset2, int len) throws IOException {
            long start2 = this.getFilePointer();
            if (start2 + (long)len > this.length) {
                throw new EOFException("read past EOF: " + this.base);
            }
            this.base.seek(this.fileOffset + start2);
            this.base.readBytes(b, offset2, len, false);
        }

        protected void seekInternal(long pos2) {
        }

        public void close() throws IOException {
            this.base.close();
        }

        public long length() {
            return this.length;
        }

        public void copyBytes(IndexOutput out, long numBytes) throws IOException {
            if ((numBytes -= (long)this.flushBuffer(out, numBytes)) > 0L) {
                long start2 = this.getFilePointer();
                if (start2 + numBytes > this.length) {
                    throw new EOFException("read past EOF: " + this.base);
                }
                this.base.seek(this.fileOffset + start2);
                this.base.copyBytes(out, numBytes);
            }
        }
    }

    private static final class FileEntry {
        long offset;
        long length;

        private FileEntry() {
        }
    }
}

