/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.util.Set;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetBasedFieldSelector
implements FieldSelector {
    private Set<String> fieldsToLoad;
    private Set<String> lazyFieldsToLoad;

    public SetBasedFieldSelector(Set<String> fieldsToLoad, Set<String> lazyFieldsToLoad) {
        this.fieldsToLoad = fieldsToLoad;
        this.lazyFieldsToLoad = lazyFieldsToLoad;
    }

    @Override
    public FieldSelectorResult accept(String fieldName) {
        FieldSelectorResult result2 = FieldSelectorResult.NO_LOAD;
        if (this.fieldsToLoad.contains(fieldName)) {
            result2 = FieldSelectorResult.LOAD;
        }
        if (this.lazyFieldsToLoad.contains(fieldName)) {
            result2 = FieldSelectorResult.LAZY_LOAD;
        }
        return result2;
    }
}

