/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.ByteArrayOutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.lucene.util.UnicodeUtil;

public class CompressionTools {
    private CompressionTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] value2, int offset2, int length2, int compressionLevel) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length2);
        Deflater compressor = new Deflater();
        try {
            compressor.setLevel(compressionLevel);
            compressor.setInput(value2, offset2, length2);
            compressor.finish();
            byte[] buf = new byte[1024];
            while (!compressor.finished()) {
                int count2 = compressor.deflate(buf);
                bos.write(buf, 0, count2);
            }
        }
        finally {
            compressor.end();
        }
        return bos.toByteArray();
    }

    public static byte[] compress(byte[] value2, int offset2, int length2) {
        return CompressionTools.compress(value2, offset2, length2, 9);
    }

    public static byte[] compress(byte[] value2) {
        return CompressionTools.compress(value2, 0, value2.length, 9);
    }

    public static byte[] compressString(String value2) {
        return CompressionTools.compressString(value2, 9);
    }

    public static byte[] compressString(String value2, int compressionLevel) {
        UnicodeUtil.UTF8Result result2 = new UnicodeUtil.UTF8Result();
        UnicodeUtil.UTF16toUTF8(value2, 0, value2.length(), result2);
        return CompressionTools.compress(result2.result, 0, result2.length, compressionLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] value2) throws DataFormatException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(value2.length);
        Inflater decompressor = new Inflater();
        try {
            decompressor.setInput(value2);
            byte[] buf = new byte[1024];
            while (!decompressor.finished()) {
                int count2 = decompressor.inflate(buf);
                bos.write(buf, 0, count2);
            }
        }
        finally {
            decompressor.end();
        }
        return bos.toByteArray();
    }

    public static String decompressString(byte[] value2) throws DataFormatException {
        UnicodeUtil.UTF16Result result2 = new UnicodeUtil.UTF16Result();
        byte[] bytes2 = CompressionTools.decompress(value2);
        UnicodeUtil.UTF8toUTF16(bytes2, 0, bytes2.length, result2);
        return new String(result2.result, 0, result2.length);
    }
}

