/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.synonym;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.synonym.SynonymMap;
import org.apache.lucene.util.CharsRef;

public class SolrSynonymParser
extends SynonymMap.Builder {
    private final boolean expand;
    private final Analyzer analyzer;

    public SolrSynonymParser(boolean dedup, boolean expand, Analyzer analyzer) {
        super(dedup);
        this.expand = expand;
        this.analyzer = analyzer;
    }

    public void add(Reader in) throws IOException, ParseException {
        LineNumberReader br = new LineNumberReader(in);
        try {
            this.addInternal(br);
        }
        catch (IllegalArgumentException e) {
            ParseException ex = new ParseException("Invalid synonym rule at line " + br.getLineNumber(), 0);
            ex.initCause(e);
            throw ex;
        }
        finally {
            br.close();
        }
    }

    private void addInternal(BufferedReader in) throws IOException {
        String line = null;
        while ((line = in.readLine()) != null) {
            CharsRef[] outputs;
            CharsRef[] inputs;
            String[] inputStrings;
            if (line.length() == 0 || line.charAt(0) == '#') continue;
            String[] sides = SolrSynonymParser.split(line, "=>");
            if (sides.length > 1) {
                if (sides.length != 2) {
                    throw new IllegalArgumentException("more than one explicit mapping specified on the same line");
                }
                inputStrings = SolrSynonymParser.split(sides[0], ",");
                inputs = new CharsRef[inputStrings.length];
                for (int i2 = 0; i2 < inputs.length; ++i2) {
                    inputs[i2] = SolrSynonymParser.analyze(this.analyzer, this.unescape(inputStrings[i2]).trim(), new CharsRef());
                }
                String[] outputStrings = SolrSynonymParser.split(sides[1], ",");
                outputs = new CharsRef[outputStrings.length];
                for (int i3 = 0; i3 < outputs.length; ++i3) {
                    outputs[i3] = SolrSynonymParser.analyze(this.analyzer, this.unescape(outputStrings[i3]).trim(), new CharsRef());
                }
            } else {
                inputStrings = SolrSynonymParser.split(line, ",");
                inputs = new CharsRef[inputStrings.length];
                for (int i4 = 0; i4 < inputs.length; ++i4) {
                    inputs[i4] = SolrSynonymParser.analyze(this.analyzer, this.unescape(inputStrings[i4]).trim(), new CharsRef());
                }
                outputs = this.expand ? inputs : new CharsRef[]{inputs[0]};
            }
            for (int i5 = 0; i5 < inputs.length; ++i5) {
                for (int j = 0; j < outputs.length; ++j) {
                    this.add(inputs[i5], outputs[j], false);
                }
            }
        }
    }

    private static String[] split(String s2, String separator) {
        ArrayList<String> list2 = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos2 = 0;
        int end2 = s2.length();
        while (pos2 < end2) {
            char ch;
            if (s2.startsWith(separator, pos2)) {
                if (sb.length() > 0) {
                    list2.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos2 += separator.length();
                continue;
            }
            if ((ch = s2.charAt(pos2++)) == '\\') {
                sb.append(ch);
                if (pos2 >= end2) break;
                ch = s2.charAt(pos2++);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            list2.add(sb.toString());
        }
        return list2.toArray(new String[list2.size()]);
    }

    private String unescape(String s2) {
        if (s2.indexOf("\\") >= 0) {
            StringBuilder sb = new StringBuilder();
            for (int i2 = 0; i2 < s2.length(); ++i2) {
                char ch = s2.charAt(i2);
                if (ch == '\\' && i2 < s2.length() - 1) {
                    sb.append(s2.charAt(++i2));
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }
        return s2;
    }
}

