/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.sinks;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.lucene.analysis.TeeSinkTokenFilter;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.AttributeSource;

public class DateRecognizerSinkFilter
extends TeeSinkTokenFilter.SinkFilter {
    public static final String DATE_TYPE = "date";
    protected DateFormat dateFormat;
    protected CharTermAttribute termAtt;

    public DateRecognizerSinkFilter() {
        this(DateFormat.getDateInstance());
    }

    public DateRecognizerSinkFilter(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public boolean accept(AttributeSource source2) {
        if (this.termAtt == null) {
            this.termAtt = source2.addAttribute(CharTermAttribute.class);
        }
        try {
            Date date = this.dateFormat.parse(this.termAtt.toString());
            if (date != null) {
                return true;
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return false;
    }
}

