/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.shingle;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.EmptyTokenStream;
import org.apache.lucene.analysis.payloads.PayloadHelper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.index.Payload;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public final class ShingleMatrixFilter
extends TokenStream {
    public static Character defaultSpacerCharacter = Character.valueOf('_');
    public static TokenSettingsCodec defaultSettingsCodec = new OneDimensionalNonWeightedTokenSettingsCodec();
    public static boolean ignoringSinglePrefixOrSuffixShingleByDefault = false;
    private TokenSettingsCodec settingsCodec;
    private int minimumShingleSize;
    private int maximumShingleSize;
    private boolean ignoringSinglePrefixOrSuffixShingle = false;
    private Character spacerCharacter = defaultSpacerCharacter;
    private TokenStream input;
    private CharTermAttribute termAtt;
    private PositionIncrementAttribute posIncrAtt;
    private PayloadAttribute payloadAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;
    private FlagsAttribute flagsAtt;
    private CharTermAttribute in_termAtt;
    private PositionIncrementAttribute in_posIncrAtt;
    private PayloadAttribute in_payloadAtt;
    private OffsetAttribute in_offsetAtt;
    private TypeAttribute in_typeAtt;
    private FlagsAttribute in_flagsAtt;
    private Iterator<Matrix.Column.Row[]> permutations;
    private List<Token> currentPermuationTokens;
    private List<Matrix.Column.Row> currentPermutationRows;
    private int currentPermutationTokensStartOffset;
    private int currentShingleLength;
    private Set<List<Token>> shinglesSeen = new HashSet<List<Token>>();
    private Matrix matrix;
    private Token reusableToken = new Token();
    private static final Token request_next_token = new Token();
    private Token readColumnBuf;

    public ShingleMatrixFilter(Matrix matrix, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.matrix = matrix;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
        this.termAtt = this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
        this.payloadAtt = this.addAttribute(PayloadAttribute.class);
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.typeAtt = this.addAttribute(TypeAttribute.class);
        this.flagsAtt = this.addAttribute(FlagsAttribute.class);
        this.input = new EmptyTokenStream();
        this.in_termAtt = this.input.addAttribute(CharTermAttribute.class);
        this.in_posIncrAtt = this.input.addAttribute(PositionIncrementAttribute.class);
        this.in_payloadAtt = this.input.addAttribute(PayloadAttribute.class);
        this.in_offsetAtt = this.input.addAttribute(OffsetAttribute.class);
        this.in_typeAtt = this.input.addAttribute(TypeAttribute.class);
        this.in_flagsAtt = this.input.addAttribute(FlagsAttribute.class);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize) {
        this(input, minimumShingleSize, maximumShingleSize, defaultSpacerCharacter);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingleByDefault);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle) {
        this(input, minimumShingleSize, maximumShingleSize, spacerCharacter, ignoringSinglePrefixOrSuffixShingle, defaultSettingsCodec);
    }

    public ShingleMatrixFilter(TokenStream input, int minimumShingleSize, int maximumShingleSize, Character spacerCharacter, boolean ignoringSinglePrefixOrSuffixShingle, TokenSettingsCodec settingsCodec) {
        this.input = input;
        this.minimumShingleSize = minimumShingleSize;
        this.maximumShingleSize = maximumShingleSize;
        this.spacerCharacter = spacerCharacter;
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
        this.settingsCodec = settingsCodec;
        this.termAtt = this.addAttribute(CharTermAttribute.class);
        this.posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
        this.payloadAtt = this.addAttribute(PayloadAttribute.class);
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.typeAtt = this.addAttribute(TypeAttribute.class);
        this.flagsAtt = this.addAttribute(FlagsAttribute.class);
        this.in_termAtt = input.addAttribute(CharTermAttribute.class);
        this.in_posIncrAtt = input.addAttribute(PositionIncrementAttribute.class);
        this.in_payloadAtt = input.addAttribute(PayloadAttribute.class);
        this.in_offsetAtt = input.addAttribute(OffsetAttribute.class);
        this.in_typeAtt = input.addAttribute(TypeAttribute.class);
        this.in_flagsAtt = input.addAttribute(FlagsAttribute.class);
    }

    @Override
    public void reset() throws IOException {
        this.permutations = null;
        this.shinglesSeen.clear();
        this.input.reset();
    }

    @Override
    public final boolean incrementToken() throws IOException {
        Token token;
        if (this.matrix == null) {
            this.matrix = new Matrix();
            while (this.matrix.columns.size() < this.maximumShingleSize && this.readColumn()) {
            }
        }
        while ((token = this.produceNextToken(this.reusableToken)) == request_next_token) {
        }
        if (token == null) {
            return false;
        }
        this.clearAttributes();
        this.termAtt.copyBuffer(token.buffer(), 0, token.length());
        this.posIncrAtt.setPositionIncrement(token.getPositionIncrement());
        this.flagsAtt.setFlags(token.getFlags());
        this.offsetAtt.setOffset(token.startOffset(), token.endOffset());
        this.typeAtt.setType(token.type());
        this.payloadAtt.setPayload(token.getPayload());
        return true;
    }

    private Token getNextInputToken(Token token) throws IOException {
        if (!this.input.incrementToken()) {
            return null;
        }
        token.copyBuffer(this.in_termAtt.buffer(), 0, this.in_termAtt.length());
        token.setPositionIncrement(this.in_posIncrAtt.getPositionIncrement());
        token.setFlags(this.in_flagsAtt.getFlags());
        token.setOffset(this.in_offsetAtt.startOffset(), this.in_offsetAtt.endOffset());
        token.setType(this.in_typeAtt.type());
        token.setPayload(this.in_payloadAtt.getPayload());
        return token;
    }

    private Token getNextToken(Token token) throws IOException {
        if (!this.incrementToken()) {
            return null;
        }
        token.copyBuffer(this.termAtt.buffer(), 0, this.termAtt.length());
        token.setPositionIncrement(this.posIncrAtt.getPositionIncrement());
        token.setFlags(this.flagsAtt.getFlags());
        token.setOffset(this.offsetAtt.startOffset(), this.offsetAtt.endOffset());
        token.setType(this.typeAtt.type());
        token.setPayload(this.payloadAtt.getPayload());
        return token;
    }

    private Token produceNextToken(Token reusableToken) throws IOException {
        if (this.currentPermuationTokens != null) {
            ++this.currentShingleLength;
            if (this.currentShingleLength + this.currentPermutationTokensStartOffset <= this.currentPermuationTokens.size() && this.currentShingleLength <= this.maximumShingleSize) {
                if (this.ignoringSinglePrefixOrSuffixShingle && this.currentShingleLength == 1 && (this.currentPermutationRows.get(this.currentPermutationTokensStartOffset).getColumn().isFirst() || this.currentPermutationRows.get(this.currentPermutationTokensStartOffset).getColumn().isLast())) {
                    return this.getNextToken(reusableToken);
                }
                int termLength = 0;
                ArrayList<Token> shingle = new ArrayList<Token>(this.currentShingleLength);
                for (int i2 = 0; i2 < this.currentShingleLength; ++i2) {
                    Token shingleToken = this.currentPermuationTokens.get(i2 + this.currentPermutationTokensStartOffset);
                    termLength += shingleToken.length();
                    shingle.add(shingleToken);
                }
                if (this.spacerCharacter != null) {
                    termLength += this.currentShingleLength - 1;
                }
                if (!this.shinglesSeen.add(shingle)) {
                    return request_next_token;
                }
                StringBuilder sb = new StringBuilder(termLength + 10);
                for (Token shingleToken : shingle) {
                    if (this.spacerCharacter != null && sb.length() > 0) {
                        sb.append(this.spacerCharacter);
                    }
                    sb.append(shingleToken.buffer(), 0, shingleToken.length());
                }
                reusableToken.setEmpty().append(sb);
                this.updateToken(reusableToken, shingle, this.currentPermutationTokensStartOffset, this.currentPermutationRows, this.currentPermuationTokens);
                return reusableToken;
            }
            if (this.currentPermutationTokensStartOffset < this.currentPermuationTokens.size() - 1) {
                ++this.currentPermutationTokensStartOffset;
                this.currentShingleLength = this.minimumShingleSize - 1;
                return request_next_token;
            }
            if (this.permutations == null) {
                return null;
            }
            if (!this.permutations.hasNext()) {
                if (this.input == null || this.readColumn()) {
                    // empty if block
                }
                Matrix.Column deletedColumn = (Matrix.Column)this.matrix.columns.remove(0);
                ArrayList<Token> deletedColumnTokens = new ArrayList<Token>();
                for (Matrix.Column.Row row : deletedColumn.getRows()) {
                    for (Token token : row.getTokens()) {
                        deletedColumnTokens.add(token);
                    }
                }
                Iterator<List<Token>> shinglesSeenIterator = this.shinglesSeen.iterator();
                block4: while (shinglesSeenIterator.hasNext()) {
                    List<Token> shingle = shinglesSeenIterator.next();
                    for (Token deletedColumnToken : deletedColumnTokens) {
                        if (!shingle.contains(deletedColumnToken)) continue;
                        shinglesSeenIterator.remove();
                        continue block4;
                    }
                }
                if (this.matrix.columns.size() < this.minimumShingleSize) {
                    return null;
                }
                this.permutations = this.matrix.permutationIterator();
            }
            this.nextTokensPermutation();
            return request_next_token;
        }
        if (this.permutations == null) {
            this.permutations = this.matrix.permutationIterator();
        }
        if (!this.permutations.hasNext()) {
            return null;
        }
        this.nextTokensPermutation();
        return request_next_token;
    }

    private void nextTokensPermutation() {
        Matrix.Column.Row[] rowsPermutation = this.permutations.next();
        ArrayList<Matrix.Column.Row> currentPermutationRows = new ArrayList<Matrix.Column.Row>();
        ArrayList<Token> currentPermuationTokens = new ArrayList<Token>();
        for (Matrix.Column.Row row : rowsPermutation) {
            for (Token token : row.getTokens()) {
                currentPermuationTokens.add(token);
                currentPermutationRows.add(row);
            }
        }
        this.currentPermuationTokens = currentPermuationTokens;
        this.currentPermutationRows = currentPermutationRows;
        this.currentPermutationTokensStartOffset = 0;
        this.currentShingleLength = this.minimumShingleSize - 1;
    }

    public void updateToken(Token token, List<Token> shingle, int currentPermutationStartOffset, List<Matrix.Column.Row> currentPermutationRows, List<Token> currentPermuationTokens) {
        token.setType(ShingleMatrixFilter.class.getName());
        token.setFlags(0);
        token.setPositionIncrement(1);
        token.setStartOffset(shingle.get(0).startOffset());
        token.setEndOffset(shingle.get(shingle.size() - 1).endOffset());
        this.settingsCodec.setWeight(token, this.calculateShingleWeight(token, shingle, currentPermutationStartOffset, currentPermutationRows, currentPermuationTokens));
    }

    public float calculateShingleWeight(Token shingleToken, List<Token> shingle, int currentPermutationStartOffset, List<Matrix.Column.Row> currentPermutationRows, List<Token> currentPermuationTokens) {
        double[] weights = new double[shingle.size()];
        double total2 = 0.0;
        double top = 0.0;
        for (int i2 = 0; i2 < weights.length; ++i2) {
            weights[i2] = this.settingsCodec.getWeight(shingle.get(i2));
            double tmp = weights[i2];
            if (tmp > top) {
                top = tmp;
            }
            total2 += tmp;
        }
        double factor = 1.0 / Math.sqrt(total2);
        double weight = 0.0;
        for (double partWeight : weights) {
            weight += partWeight * factor;
        }
        return (float)weight;
    }

    private boolean readColumn() throws IOException {
        TokenPositioner tokenPositioner;
        Token token;
        if (this.readColumnBuf != null) {
            token = this.readColumnBuf;
            this.readColumnBuf = null;
        } else {
            token = this.getNextInputToken(new Token());
        }
        if (token == null) {
            return false;
        }
        Matrix.Column currentReaderColumn = this.matrix.new Matrix.Column();
        Matrix.Column.Row currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
        currentReaderRow.getTokens().add(token);
        while ((this.readColumnBuf = this.getNextInputToken(new Token())) != null && (tokenPositioner = this.settingsCodec.getTokenPositioner(this.readColumnBuf)) != TokenPositioner.newColumn) {
            if (tokenPositioner == TokenPositioner.sameRow) {
                currentReaderRow.getTokens().add(this.readColumnBuf);
            } else {
                currentReaderRow = currentReaderColumn.new Matrix.Column.Row();
                currentReaderRow.getTokens().add(this.readColumnBuf);
            }
            this.readColumnBuf = null;
        }
        if (this.readColumnBuf == null) {
            this.readColumnBuf = this.getNextInputToken(new Token());
            if (this.readColumnBuf == null) {
                currentReaderColumn.setLast(true);
            }
        }
        return true;
    }

    public int getMinimumShingleSize() {
        return this.minimumShingleSize;
    }

    public void setMinimumShingleSize(int minimumShingleSize) {
        this.minimumShingleSize = minimumShingleSize;
    }

    public int getMaximumShingleSize() {
        return this.maximumShingleSize;
    }

    public void setMaximumShingleSize(int maximumShingleSize) {
        this.maximumShingleSize = maximumShingleSize;
    }

    public Matrix getMatrix() {
        return this.matrix;
    }

    public void setMatrix(Matrix matrix) {
        this.matrix = matrix;
    }

    public Character getSpacerCharacter() {
        return this.spacerCharacter;
    }

    public void setSpacerCharacter(Character spacerCharacter) {
        this.spacerCharacter = spacerCharacter;
    }

    public boolean isIgnoringSinglePrefixOrSuffixShingle() {
        return this.ignoringSinglePrefixOrSuffixShingle;
    }

    public void setIgnoringSinglePrefixOrSuffixShingle(boolean ignoringSinglePrefixOrSuffixShingle) {
        this.ignoringSinglePrefixOrSuffixShingle = ignoringSinglePrefixOrSuffixShingle;
    }

    public static class SimpleThreeDimensionalTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            switch (token.getFlags()) {
                case 0: {
                    return TokenPositioner.newColumn;
                }
                case 1: {
                    return TokenPositioner.newRow;
                }
                case 2: {
                    return TokenPositioner.sameRow;
                }
            }
            throw new IOException("Unknown matrix positioning of token " + token);
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            token.setFlags(tokenPositioner.getIndex());
        }

        public float getWeight(Token token) {
            if (token.getPayload() == null || token.getPayload().getData() == null) {
                return 1.0f;
            }
            return PayloadHelper.decodeFloat(token.getPayload().getData());
        }

        public void setWeight(Token token, float weight) {
            if (weight == 1.0f) {
                token.setPayload(null);
            } else {
                token.setPayload(new Payload(PayloadHelper.encodeFloat(weight)));
            }
        }
    }

    public static class TwoDimensionalNonWeightedSynonymTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            if (token.getPositionIncrement() == 0) {
                return TokenPositioner.newRow;
            }
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
            throw new UnsupportedOperationException();
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    public static class OneDimensionalNonWeightedTokenSettingsCodec
    extends TokenSettingsCodec {
        public TokenPositioner getTokenPositioner(Token token) throws IOException {
            return TokenPositioner.newColumn;
        }

        public void setTokenPositioner(Token token, TokenPositioner tokenPositioner) {
        }

        public float getWeight(Token token) {
            return 1.0f;
        }

        public void setWeight(Token token, float weight) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Matrix {
        private boolean columnsHasBeenCreated = false;
        private List<Column> columns = new ArrayList<Column>();

        public List<Column> getColumns() {
            return this.columns;
        }

        public Iterator<Column.Row[]> permutationIterator() {
            return new Iterator<Column.Row[]>(){
                private int[] columnRowCounters;
                {
                    this.columnRowCounters = new int[Matrix.this.columns.size()];
                }

                @Override
                public void remove() {
                    throw new IllegalStateException("not implemented");
                }

                @Override
                public boolean hasNext() {
                    int s2 = this.columnRowCounters.length;
                    int n = Matrix.this.columns.size();
                    return s2 != 0 && n >= s2 && this.columnRowCounters[s2 - 1] < ((Column)Matrix.this.columns.get(s2 - 1)).getRows().size();
                }

                @Override
                public Column.Row[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("no more elements");
                    }
                    Column.Row[] rows = new Column.Row[this.columnRowCounters.length];
                    for (int i2 = 0; i2 < this.columnRowCounters.length; ++i2) {
                        rows[i2] = (Column.Row)((Column)Matrix.this.columns.get(i2)).rows.get(this.columnRowCounters[i2]);
                    }
                    this.incrementColumnRowCounters();
                    return rows;
                }

                private void incrementColumnRowCounters() {
                    for (int i2 = 0; i2 < this.columnRowCounters.length; ++i2) {
                        int n = i2;
                        this.columnRowCounters[n] = this.columnRowCounters[n] + 1;
                        if (this.columnRowCounters[i2] != ((Column)Matrix.this.columns.get(i2)).rows.size() || i2 >= this.columnRowCounters.length - 1) break;
                        this.columnRowCounters[i2] = 0;
                    }
                }
            };
        }

        public String toString() {
            return "Matrix{columns=" + this.columns + '}';
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Column {
            private boolean last;
            private boolean first;
            private List<Row> rows = new ArrayList<Row>();

            public Matrix getMatrix() {
                return Matrix.this;
            }

            public Column(Token token) {
                this();
                Row row = new Row();
                row.getTokens().add(token);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Column() {
                Matrix matrix2 = Matrix.this;
                synchronized (matrix2) {
                    if (!Matrix.this.columnsHasBeenCreated) {
                        this.setFirst(true);
                        Matrix.this.columnsHasBeenCreated = true;
                    }
                }
                Matrix.this.columns.add(this);
            }

            public List<Row> getRows() {
                return this.rows;
            }

            public int getIndex() {
                return Matrix.this.columns.indexOf(this);
            }

            public String toString() {
                return "Column{first=" + this.first + ", last=" + this.last + ", rows=" + this.rows + '}';
            }

            public boolean isFirst() {
                return this.first;
            }

            public void setFirst(boolean first2) {
                this.first = first2;
            }

            public void setLast(boolean last2) {
                this.last = last2;
            }

            public boolean isLast() {
                return this.last;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Row {
                private List<Token> tokens = new LinkedList<Token>();

                public Column getColumn() {
                    return Column.this;
                }

                public Row() {
                    Column.this.rows.add(this);
                }

                public int getIndex() {
                    return Column.this.rows.indexOf(this);
                }

                public List<Token> getTokens() {
                    return this.tokens;
                }

                public void setTokens(List<Token> tokens) {
                    this.tokens = tokens;
                }

                public String toString() {
                    return "Row{index=" + this.getIndex() + ", tokens=" + (this.tokens == null ? null : this.tokens) + '}';
                }
            }
        }
    }

    public static class TokenPositioner {
        public static final TokenPositioner newColumn = new TokenPositioner(0);
        public static final TokenPositioner newRow = new TokenPositioner(1);
        public static final TokenPositioner sameRow = new TokenPositioner(2);
        private final int index;

        private TokenPositioner(int index2) {
            this.index = index2;
        }

        public int getIndex() {
            return this.index;
        }
    }

    public static abstract class TokenSettingsCodec {
        public abstract TokenPositioner getTokenPositioner(Token var1) throws IOException;

        public abstract void setTokenPositioner(Token var1, TokenPositioner var2);

        public abstract float getWeight(Token var1);

        public abstract void setWeight(Token var1, float var2);
    }
}

