/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternAnalyzer
extends ReusableAnalyzerBase {
    public static final Pattern NON_WORD_PATTERN = Pattern.compile("\\W+");
    public static final Pattern WHITESPACE_PATTERN = Pattern.compile("\\s+");
    private static final CharArraySet EXTENDED_ENGLISH_STOP_WORDS = CharArraySet.unmodifiableSet(new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList("a", "about", "above", "across", "adj", "after", "afterwards", "again", "against", "albeit", "all", "almost", "alone", "along", "already", "also", "although", "always", "among", "amongst", "an", "and", "another", "any", "anyhow", "anyone", "anything", "anywhere", "are", "around", "as", "at", "be", "became", "because", "become", "becomes", "becoming", "been", "before", "beforehand", "behind", "being", "below", "beside", "besides", "between", "beyond", "both", "but", "by", "can", "cannot", "co", "could", "down", "during", "each", "eg", "either", "else", "elsewhere", "enough", "etc", "even", "ever", "every", "everyone", "everything", "everywhere", "except", "few", "first", "for", "former", "formerly", "from", "further", "had", "has", "have", "he", "hence", "her", "here", "hereafter", "hereby", "herein", "hereupon", "hers", "herself", "him", "himself", "his", "how", "however", "i", "ie", "if", "in", "inc", "indeed", "into", "is", "it", "its", "itself", "last", "latter", "latterly", "least", "less", "ltd", "many", "may", "me", "meanwhile", "might", "more", "moreover", "most", "mostly", "much", "must", "my", "myself", "namely", "neither", "never", "nevertheless", "next", "no", "nobody", "none", "noone", "nor", "not", "nothing", "now", "nowhere", "of", "off", "often", "on", "once one", "only", "onto", "or", "other", "others", "otherwise", "our", "ours", "ourselves", "out", "over", "own", "per", "perhaps", "rather", "s", "same", "seem", "seemed", "seeming", "seems", "several", "she", "should", "since", "so", "some", "somehow", "someone", "something", "sometime", "sometimes", "somewhere", "still", "such", "t", "than", "that", "the", "their", "them", "themselves", "then", "thence", "there", "thereafter", "thereby", "therefor", "therein", "thereupon", "these", "they", "this", "those", "though", "through", "throughout", "thru", "thus", "to", "together", "too", "toward", "towards", "under", "until", "up", "upon", "us", "very", "via", "was", "we", "well", "were", "what", "whatever", "whatsoever", "when", "whence", "whenever", "whensoever", "where", "whereafter", "whereas", "whereat", "whereby", "wherefrom", "wherein", "whereinto", "whereof", "whereon", "whereto", "whereunto", "whereupon", "wherever", "wherewith", "whether", "which", "whichever", "whichsoever", "while", "whilst", "whither", "who", "whoever", "whole", "whom", "whomever", "whomsoever", "whose", "whosoever", "why", "will", "with", "within", "without", "would", "xsubj", "xcal", "xauthor", "xother ", "xnote", "yet", "you", "your", "yours", "yourself", "yourselves"), true));
    public static final PatternAnalyzer DEFAULT_ANALYZER = new PatternAnalyzer(Version.LUCENE_CURRENT, NON_WORD_PATTERN, true, StopAnalyzer.ENGLISH_STOP_WORDS_SET);
    public static final PatternAnalyzer EXTENDED_ANALYZER = new PatternAnalyzer(Version.LUCENE_CURRENT, NON_WORD_PATTERN, true, EXTENDED_ENGLISH_STOP_WORDS);
    private final Pattern pattern;
    private final boolean toLowerCase;
    private final Set<?> stopWords;
    private final Version matchVersion;

    public PatternAnalyzer(Version matchVersion, Pattern pattern, boolean toLowerCase, Set<?> stopWords) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern must not be null");
        }
        if (PatternAnalyzer.eqPattern(NON_WORD_PATTERN, pattern)) {
            pattern = NON_WORD_PATTERN;
        } else if (PatternAnalyzer.eqPattern(WHITESPACE_PATTERN, pattern)) {
            pattern = WHITESPACE_PATTERN;
        }
        if (stopWords != null && stopWords.size() == 0) {
            stopWords = null;
        }
        this.pattern = pattern;
        this.toLowerCase = toLowerCase;
        this.stopWords = stopWords;
        this.matchVersion = matchVersion;
    }

    public ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader, String text) {
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (this.pattern == NON_WORD_PATTERN) {
            return new ReusableAnalyzerBase.TokenStreamComponents(new FastStringTokenizer(reader, text, true, this.toLowerCase, this.stopWords));
        }
        if (this.pattern == WHITESPACE_PATTERN) {
            return new ReusableAnalyzerBase.TokenStreamComponents(new FastStringTokenizer(reader, text, false, this.toLowerCase, this.stopWords));
        }
        PatternTokenizer tokenizer = new PatternTokenizer(reader, text, this.pattern, this.toLowerCase);
        TokenStream result2 = this.stopWords != null ? new StopFilter(this.matchVersion, (TokenStream)tokenizer, this.stopWords) : tokenizer;
        return new ReusableAnalyzerBase.TokenStreamComponents(tokenizer, result2);
    }

    @Override
    public ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        try {
            String text = PatternAnalyzer.toString(reader);
            return this.createComponents(fieldName, reader, text);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this == DEFAULT_ANALYZER && other == EXTENDED_ANALYZER) {
            return false;
        }
        if (other == DEFAULT_ANALYZER && this == EXTENDED_ANALYZER) {
            return false;
        }
        if (other instanceof PatternAnalyzer) {
            PatternAnalyzer p2 = (PatternAnalyzer)other;
            return this.toLowerCase == p2.toLowerCase && PatternAnalyzer.eqPattern(this.pattern, p2.pattern) && PatternAnalyzer.eq(this.stopWords, p2.stopWords);
        }
        return false;
    }

    public int hashCode() {
        if (this == DEFAULT_ANALYZER) {
            return -1218418418;
        }
        if (this == EXTENDED_ANALYZER) {
            return 1303507063;
        }
        int h = 1;
        h = 31 * h + this.pattern.pattern().hashCode();
        h = 31 * h + this.pattern.flags();
        h = 31 * h + (this.toLowerCase ? 1231 : 1237);
        h = 31 * h + (this.stopWords != null ? ((Object)this.stopWords).hashCode() : 0);
        return h;
    }

    private static boolean eq(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    private static boolean eqPattern(Pattern p1, Pattern p2) {
        return p1 == p2 || p1.flags() == p2.flags() && p1.pattern().equals(p2.pattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(Reader input) throws IOException {
        if (input instanceof FastStringReader) {
            return ((FastStringReader)input).getString();
        }
        try {
            int n;
            int len = 256;
            char[] buffer = new char[len];
            char[] output = new char[len];
            len = 0;
            while ((n = input.read(buffer)) >= 0) {
                if (len + n > output.length) {
                    char[] tmp = new char[Math.max(output.length << 1, len + n)];
                    System.arraycopy(output, 0, tmp, 0, len);
                    System.arraycopy(buffer, 0, tmp, len, n);
                    buffer = output;
                    output = tmp;
                } else {
                    System.arraycopy(buffer, 0, output, len, n);
                }
                len += n;
            }
            String string2 = new String(output, 0, len);
            return string2;
        }
        finally {
            input.close();
        }
    }

    static final class FastStringReader
    extends StringReader {
        private final String s;

        FastStringReader(String s2) {
            super(s2);
            this.s = s2;
        }

        String getString() {
            return this.s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FastStringTokenizer
    extends Tokenizer {
        private String str;
        private int pos;
        private final boolean isLetter;
        private final boolean toLowerCase;
        private final Set<?> stopWords;
        private static final Locale locale = Locale.getDefault();
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

        public FastStringTokenizer(Reader input, String str, boolean isLetter, boolean toLowerCase, Set<?> stopWords) {
            super(input);
            this.str = str;
            this.isLetter = isLetter;
            this.toLowerCase = toLowerCase;
            this.stopWords = stopWords;
        }

        @Override
        public boolean incrementToken() {
            String text;
            this.clearAttributes();
            String s2 = this.str;
            int len = s2.length();
            int i2 = this.pos;
            boolean letter = this.isLetter;
            int start2 = 0;
            do {
                text = null;
                while (i2 < len && !this.isTokenChar(s2.charAt(i2), letter)) {
                    ++i2;
                }
                if (i2 >= len) continue;
                start2 = i2;
                while (i2 < len && this.isTokenChar(s2.charAt(i2), letter)) {
                    ++i2;
                }
                text = s2.substring(start2, i2);
                if (!this.toLowerCase) continue;
                text = text.toLowerCase(locale);
            } while (text != null && this.isStopWord(text));
            this.pos = i2;
            if (text == null) {
                return false;
            }
            this.termAtt.setEmpty().append(text);
            this.offsetAtt.setOffset(this.correctOffset(start2), this.correctOffset(i2));
            return true;
        }

        @Override
        public final void end() {
            int finalOffset = this.str.length();
            this.offsetAtt.setOffset(this.correctOffset(finalOffset), this.correctOffset(finalOffset));
        }

        private boolean isTokenChar(char c, boolean isLetter) {
            return isLetter ? Character.isLetter(c) : !Character.isWhitespace(c);
        }

        private boolean isStopWord(String text) {
            return this.stopWords != null && this.stopWords.contains(text);
        }

        @Override
        public void reset(Reader input) throws IOException {
            super.reset(input);
            this.str = PatternAnalyzer.toString(input);
        }

        @Override
        public void reset() throws IOException {
            super.reset();
            this.pos = 0;
        }
    }

    private static final class PatternTokenizer
    extends Tokenizer {
        private final Pattern pattern;
        private String str;
        private final boolean toLowerCase;
        private Matcher matcher;
        private int pos = 0;
        private static final Locale locale = Locale.getDefault();
        private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

        public PatternTokenizer(Reader input, String str, Pattern pattern, boolean toLowerCase) {
            super(input);
            this.pattern = pattern;
            this.str = str;
            this.matcher = pattern.matcher(str);
            this.toLowerCase = toLowerCase;
        }

        public final boolean incrementToken() {
            boolean isMatch;
            if (this.matcher == null) {
                return false;
            }
            this.clearAttributes();
            do {
                int end2;
                int start2 = this.pos;
                isMatch = this.matcher.find();
                if (isMatch) {
                    end2 = this.matcher.start();
                    this.pos = this.matcher.end();
                } else {
                    end2 = this.str.length();
                    this.matcher = null;
                }
                if (start2 == end2) continue;
                String text = this.str.substring(start2, end2);
                if (this.toLowerCase) {
                    text = text.toLowerCase(locale);
                }
                this.termAtt.setEmpty().append(text);
                this.offsetAtt.setOffset(this.correctOffset(start2), this.correctOffset(end2));
                return true;
            } while (isMatch);
            return false;
        }

        public final void end() {
            int finalOffset = this.correctOffset(this.str.length());
            this.offsetAtt.setOffset(finalOffset, finalOffset);
        }

        public void reset(Reader input) throws IOException {
            super.reset(input);
            this.str = PatternAnalyzer.toString(input);
            this.matcher = this.pattern.matcher(this.str);
        }

        public void reset() throws IOException {
            super.reset();
            this.pos = 0;
        }
    }
}

