/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.id;

import org.apache.lucene.analysis.util.StemmerUtil;

public class IndonesianStemmer {
    private int numSyllables;
    private int flags;
    private static final int REMOVED_KE = 1;
    private static final int REMOVED_PENG = 2;
    private static final int REMOVED_DI = 4;
    private static final int REMOVED_MENG = 8;
    private static final int REMOVED_TER = 16;
    private static final int REMOVED_BER = 32;
    private static final int REMOVED_PE = 64;

    public int stem(char[] text, int length2, boolean stemDerivational) {
        this.flags = 0;
        this.numSyllables = 0;
        for (int i2 = 0; i2 < length2; ++i2) {
            if (!this.isVowel(text[i2])) continue;
            ++this.numSyllables;
        }
        if (this.numSyllables > 2) {
            length2 = this.removeParticle(text, length2);
        }
        if (this.numSyllables > 2) {
            length2 = this.removePossessivePronoun(text, length2);
        }
        if (stemDerivational) {
            length2 = this.stemDerivational(text, length2);
        }
        return length2;
    }

    private int stemDerivational(char[] text, int length2) {
        int oldLength = length2;
        if (this.numSyllables > 2) {
            length2 = this.removeFirstOrderPrefix(text, length2);
        }
        if (oldLength != length2) {
            oldLength = length2;
            if (this.numSyllables > 2) {
                length2 = this.removeSuffix(text, length2);
            }
            if (oldLength != length2 && this.numSyllables > 2) {
                length2 = this.removeSecondOrderPrefix(text, length2);
            }
        } else {
            if (this.numSyllables > 2) {
                length2 = this.removeSecondOrderPrefix(text, length2);
            }
            if (this.numSyllables > 2) {
                length2 = this.removeSuffix(text, length2);
            }
        }
        return length2;
    }

    private boolean isVowel(char ch) {
        switch (ch) {
            case 'a': 
            case 'e': 
            case 'i': 
            case 'o': 
            case 'u': {
                return true;
            }
        }
        return false;
    }

    private int removeParticle(char[] text, int length2) {
        if (StemmerUtil.endsWith(text, length2, "kah") || StemmerUtil.endsWith(text, length2, "lah") || StemmerUtil.endsWith(text, length2, "pun")) {
            --this.numSyllables;
            return length2 - 3;
        }
        return length2;
    }

    private int removePossessivePronoun(char[] text, int length2) {
        if (StemmerUtil.endsWith(text, length2, "ku") || StemmerUtil.endsWith(text, length2, "mu")) {
            --this.numSyllables;
            return length2 - 2;
        }
        if (StemmerUtil.endsWith(text, length2, "nya")) {
            --this.numSyllables;
            return length2 - 3;
        }
        return length2;
    }

    private int removeFirstOrderPrefix(char[] text, int length2) {
        if (StemmerUtil.startsWith(text, length2, "meng")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text, length2, "meny") && length2 > 4 && this.isVowel(text[4])) {
            this.flags |= 8;
            text[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "men")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "mem")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "me")) {
            this.flags |= 8;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text, length2, "peng")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text, length2, "peny") && length2 > 4 && this.isVowel(text[4])) {
            this.flags |= 2;
            text[3] = 115;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "peny")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 4);
        }
        if (StemmerUtil.startsWith(text, length2, "pen") && length2 > 3 && this.isVowel(text[3])) {
            this.flags |= 2;
            text[2] = 116;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text, length2, "pen")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "pem")) {
            this.flags |= 2;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "di")) {
            this.flags |= 4;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text, length2, "ter")) {
            this.flags |= 0x10;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "ke")) {
            this.flags |= 1;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        return length2;
    }

    private int removeSecondOrderPrefix(char[] text, int length2) {
        if (StemmerUtil.startsWith(text, length2, "ber")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (length2 == 7 && StemmerUtil.startsWith(text, length2, "belajar")) {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "be") && length2 > 4 && !this.isVowel(text[2]) && text[3] == 'e' && text[4] == 'r') {
            this.flags |= 0x20;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        if (StemmerUtil.startsWith(text, length2, "per")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (length2 == 7 && StemmerUtil.startsWith(text, length2, "pelajar")) {
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 3);
        }
        if (StemmerUtil.startsWith(text, length2, "pe")) {
            this.flags |= 0x40;
            --this.numSyllables;
            return StemmerUtil.deleteN(text, 0, length2, 2);
        }
        return length2;
    }

    private int removeSuffix(char[] text, int length2) {
        if (StemmerUtil.endsWith(text, length2, "kan") && (this.flags & 1) == 0 && (this.flags & 2) == 0 && (this.flags & 0x40) == 0) {
            --this.numSyllables;
            return length2 - 3;
        }
        if (StemmerUtil.endsWith(text, length2, "an") && (this.flags & 4) == 0 && (this.flags & 8) == 0 && (this.flags & 0x10) == 0) {
            --this.numSyllables;
            return length2 - 2;
        }
        if (StemmerUtil.endsWith(text, length2, "i") && !StemmerUtil.endsWith(text, length2, "si") && (this.flags & 0x20) == 0 && (this.flags & 1) == 0 && (this.flags & 2) == 0) {
            --this.numSyllables;
            return length2 - 1;
        }
        return length2;
    }
}

