/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ElisionFilter
extends TokenFilter {
    private CharArraySet articles = CharArraySet.EMPTY_SET;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private static final CharArraySet DEFAULT_ARTICLES = CharArraySet.unmodifiableSet(new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList("l", "m", "t", "qu", "n", "s", "j"), true));
    private static char[] apostrophes = new char[]{'\'', '\u2019'};

    @Deprecated
    public void setArticles(Version matchVersion, Set<?> articles) {
        this.articles = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, articles));
    }

    @Deprecated
    public void setArticles(Set<?> articles) {
        this.setArticles(Version.LUCENE_CURRENT, articles);
    }

    public ElisionFilter(Version matchVersion, TokenStream input) {
        this(matchVersion, input, DEFAULT_ARTICLES);
    }

    @Deprecated
    public ElisionFilter(TokenStream input) {
        this(Version.LUCENE_30, input);
    }

    @Deprecated
    public ElisionFilter(TokenStream input, Set<?> articles) {
        this(Version.LUCENE_30, input, articles);
    }

    public ElisionFilter(Version matchVersion, TokenStream input, Set<?> articles) {
        super(input);
        this.articles = CharArraySet.unmodifiableSet(new CharArraySet(matchVersion, articles, true));
    }

    @Deprecated
    public ElisionFilter(TokenStream input, String[] articles) {
        this(Version.LUCENE_CURRENT, input, new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList(articles), true));
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            char[] termBuffer = this.termAtt.buffer();
            int termLength = this.termAtt.length();
            int minPoz = Integer.MAX_VALUE;
            block0: for (int i2 = 0; i2 < apostrophes.length; ++i2) {
                char apos = apostrophes[i2];
                for (int poz = 0; poz < termLength; ++poz) {
                    if (termBuffer[poz] != apos) continue;
                    minPoz = Math.min(poz, minPoz);
                    continue block0;
                }
            }
            if (minPoz != Integer.MAX_VALUE && this.articles.contains(this.termAtt.buffer(), 0, minPoz)) {
                this.termAtt.copyBuffer(this.termAtt.buffer(), minPoz + 1, this.termAtt.length() - (minPoz + 1));
            }
            return true;
        }
        return false;
    }
}

