/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.StemmerUtil;

public final class GermanNormalizationFilter
extends TokenFilter {
    private static final int N = 0;
    private static final int V = 1;
    private static final int U = 2;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);

    public GermanNormalizationFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            int state2 = 0;
            char[] buffer = this.termAtt.buffer();
            int length2 = this.termAtt.length();
            block10: for (int i2 = 0; i2 < length2; ++i2) {
                char c = buffer[i2];
                switch (c) {
                    case 'a': 
                    case 'o': {
                        state2 = 2;
                        continue block10;
                    }
                    case 'u': {
                        state2 = state2 == 0 ? 2 : 1;
                        continue block10;
                    }
                    case 'e': {
                        if (state2 == 2) {
                            length2 = StemmerUtil.delete(buffer, i2--, length2);
                        }
                        state2 = 1;
                        continue block10;
                    }
                    case 'i': 
                    case 'q': 
                    case 'y': {
                        state2 = 1;
                        continue block10;
                    }
                    case '\u00e4': {
                        buffer[i2] = 97;
                        state2 = 1;
                        continue block10;
                    }
                    case '\u00f6': {
                        buffer[i2] = 111;
                        state2 = 1;
                        continue block10;
                    }
                    case '\u00fc': {
                        buffer[i2] = 117;
                        state2 = 1;
                        continue block10;
                    }
                    case '\u00df': {
                        buffer[i2++] = 115;
                        buffer = this.termAtt.resizeBuffer(1 + length2);
                        if (i2 < length2) {
                            System.arraycopy(buffer, i2, buffer, i2 + 1, length2 - i2);
                        }
                        buffer[i2] = 115;
                        ++length2;
                        state2 = 0;
                        continue block10;
                    }
                    default: {
                        state2 = 0;
                    }
                }
            }
            this.termAtt.setLength(length2);
            return true;
        }
        return false;
    }
}

