/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.de.GermanLightStemFilter;
import org.apache.lucene.analysis.de.GermanNormalizationFilter;
import org.apache.lucene.analysis.de.GermanStemFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;
import org.tartarus.snowball.ext.German2Stemmer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GermanAnalyzer
extends StopwordAnalyzerBase {
    @Deprecated
    public static final String[] GERMAN_STOP_WORDS = new String[]{"einer", "eine", "eines", "einem", "einen", "der", "die", "das", "dass", "da\u00df", "du", "er", "sie", "es", "was", "wer", "wie", "wir", "und", "oder", "ohne", "mit", "am", "im", "in", "aus", "auf", "ist", "sein", "war", "wird", "ihr", "ihre", "ihres", "als", "f\u00fcr", "von", "mit", "dich", "dir", "mich", "mir", "mein", "sein", "kein", "durch", "wegen", "wird"};
    public static final String DEFAULT_STOPWORD_FILE = "german_stop.txt";
    private Set<?> exclusionSet;

    public static final Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_SET;
    }

    public GermanAnalyzer(Version matchVersion) {
        this(matchVersion, matchVersion.onOrAfter(Version.LUCENE_31) ? DefaultSetHolder.DEFAULT_SET : DefaultSetHolder.DEFAULT_SET_30);
    }

    public GermanAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET);
    }

    public GermanAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.exclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionSet));
    }

    @Deprecated
    public GermanAnalyzer(Version matchVersion, String ... stopwords) {
        this(matchVersion, StopFilter.makeStopSet(matchVersion, stopwords));
    }

    @Deprecated
    public GermanAnalyzer(Version matchVersion, Map<?, ?> stopwords) {
        this(matchVersion, stopwords.keySet());
    }

    @Deprecated
    public GermanAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(IOUtils.getDecodingReader(stopwords, IOUtils.CHARSET_UTF_8), matchVersion));
    }

    @Deprecated
    public void setStemExclusionTable(String[] exclusionlist) {
        this.exclusionSet = StopFilter.makeStopSet(this.matchVersion, exclusionlist);
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(Map<?, ?> exclusionlist) {
        this.exclusionSet = new HashSet(exclusionlist.keySet());
        this.setPreviousTokenStream(null);
    }

    @Deprecated
    public void setStemExclusionTable(File exclusionlist) throws IOException {
        this.exclusionSet = WordlistLoader.getWordSet(IOUtils.getDecodingReader(exclusionlist, IOUtils.CHARSET_UTF_8), this.matchVersion);
        this.setPreviousTokenStream(null);
    }

    @Override
    protected ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source2 = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result2 = new StandardFilter(this.matchVersion, source2);
        result2 = new LowerCaseFilter(this.matchVersion, result2);
        result2 = new StopFilter(this.matchVersion, (TokenStream)result2, this.stopwords);
        result2 = new KeywordMarkerFilter((TokenStream)result2, this.exclusionSet);
        if (this.matchVersion.onOrAfter(Version.LUCENE_36)) {
            result2 = new GermanNormalizationFilter(result2);
            result2 = new GermanLightStemFilter(result2);
        } else {
            result2 = this.matchVersion.onOrAfter(Version.LUCENE_31) ? new SnowballFilter((TokenStream)result2, new German2Stemmer()) : new GermanStemFilter(result2);
        }
        return new ReusableAnalyzerBase.TokenStreamComponents(source2, result2);
    }

    private static class DefaultSetHolder {
        @Deprecated
        private static final Set<?> DEFAULT_SET_30 = CharArraySet.unmodifiableSet(new CharArraySet(Version.LUCENE_CURRENT, Arrays.asList(GERMAN_STOP_WORDS), false));
        private static final Set<?> DEFAULT_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_SET = WordlistLoader.getSnowballWordSet(IOUtils.getDecodingReader(SnowballFilter.class, GermanAnalyzer.DEFAULT_STOPWORD_FILE, IOUtils.CHARSET_UTF_8), Version.LUCENE_CURRENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

