/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.compound.hyphenation;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.lucene.analysis.compound.hyphenation.ByteVector;
import org.apache.lucene.analysis.compound.hyphenation.Hyphenation;
import org.apache.lucene.analysis.compound.hyphenation.HyphenationException;
import org.apache.lucene.analysis.compound.hyphenation.PatternConsumer;
import org.apache.lucene.analysis.compound.hyphenation.PatternParser;
import org.apache.lucene.analysis.compound.hyphenation.TernaryTree;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyphenationTree
extends TernaryTree
implements PatternConsumer,
Serializable {
    private static final long serialVersionUID = -7842107987915665573L;
    protected ByteVector vspace;
    protected HashMap<String, ArrayList<Object>> stoplist = new HashMap(23);
    protected TernaryTree classmap = new TernaryTree();
    private transient TernaryTree ivalues;

    public HyphenationTree() {
        this.vspace = new ByteVector();
        this.vspace.alloc(1);
    }

    protected int packValues(String values2) {
        int n = values2.length();
        int m = (n & 1) == 1 ? (n >> 1) + 2 : (n >> 1) + 1;
        int offset2 = this.vspace.alloc(m);
        byte[] va = this.vspace.getArray();
        for (int i2 = 0; i2 < n; ++i2) {
            int j = i2 >> 1;
            byte v = (byte)(values2.charAt(i2) - 48 + 1 & 0xF);
            va[j + offset2] = (i2 & 1) == 1 ? (byte)(va[j + offset2] | v) : (byte)(v << 4);
        }
        va[m - 1 + offset2] = 0;
        return offset2;
    }

    protected String unpackValues(int k) {
        StringBuilder buf = new StringBuilder();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1 + 48);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001' + 48);
            buf.append(c);
            v = this.vspace.get(k++);
        }
        return buf.toString();
    }

    public void loadPatterns(File f) throws HyphenationException {
        try {
            InputSource src = new InputSource(f.toURL().toExternalForm());
            this.loadPatterns(src);
        }
        catch (MalformedURLException e) {
            throw new HyphenationException("Error converting the File '" + f + "' to a URL: " + e.getMessage());
        }
    }

    public void loadPatterns(InputSource source2) throws HyphenationException {
        PatternParser pp = new PatternParser(this);
        this.ivalues = new TernaryTree();
        pp.parse(source2);
        this.trimToSize();
        this.vspace.trimToSize();
        this.classmap.trimToSize();
        this.ivalues = null;
    }

    public String findPattern(String pat) {
        int k = super.find(pat);
        if (k >= 0) {
            return this.unpackValues(k);
        }
        return "";
    }

    protected int hstrcmp(char[] s2, int si, char[] t, int ti) {
        while (s2[si] == t[ti]) {
            if (s2[si] == '\u0000') {
                return 0;
            }
            ++si;
            ++ti;
        }
        if (t[ti] == '\u0000') {
            return 0;
        }
        return s2[si] - t[ti];
    }

    protected byte[] getValues(int k) {
        StringBuilder buf = new StringBuilder();
        byte v = this.vspace.get(k++);
        while (v != 0) {
            char c = (char)((v >>> 4) - 1);
            buf.append(c);
            c = (char)(v & 0xF);
            if (c == '\u0000') break;
            c = (char)(c - '\u0001');
            buf.append(c);
            v = this.vspace.get(k++);
        }
        byte[] res = new byte[buf.length()];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = (byte)buf.charAt(i2);
        }
        return res;
    }

    protected void searchPatterns(char[] word, int index2, byte[] il) {
        int i2 = index2;
        char sp = word[i2];
        char p2 = this.root;
        block0: while (p2 > '\u0000' && p2 < this.sc.length) {
            byte[] values2;
            if (this.sc[p2] == '\uffff') {
                if (this.hstrcmp(word, i2, this.kv.getArray(), this.lo[p2]) == 0) {
                    values2 = this.getValues(this.eq[p2]);
                    int j = index2;
                    for (int k = 0; k < values2.length; ++k) {
                        if (j < il.length && values2[k] > il[j]) {
                            il[j] = values2[k];
                        }
                        ++j;
                    }
                }
                return;
            }
            int d = sp - this.sc[p2];
            if (d == 0) {
                if (sp == '\u0000') break;
                sp = word[++i2];
                char q = p2 = this.eq[p2];
                while (q > '\u0000' && q < this.sc.length && this.sc[q] != '\uffff') {
                    if (this.sc[q] == '\u0000') {
                        values2 = this.getValues(this.eq[q]);
                        int j = index2;
                        for (int k = 0; k < values2.length; ++k) {
                            if (j < il.length && values2[k] > il[j]) {
                                il[j] = values2[k];
                            }
                            ++j;
                        }
                        continue block0;
                    }
                    q = this.lo[q];
                }
                continue;
            }
            p2 = d < 0 ? this.lo[p2] : this.hi[p2];
        }
    }

    public Hyphenation hyphenate(String word, int remainCharCount, int pushCharCount) {
        char[] w = word.toCharArray();
        return this.hyphenate(w, 0, w.length, remainCharCount, pushCharCount);
    }

    public Hyphenation hyphenate(char[] w, int offset2, int len, int remainCharCount, int pushCharCount) {
        int i2;
        char[] word = new char[len + 3];
        char[] c = new char[2];
        int iIgnoreAtBeginning = 0;
        int iLength = len;
        boolean bEndOfLetters = false;
        for (i2 = 1; i2 <= len; ++i2) {
            c[0] = w[offset2 + i2 - 1];
            int nc = this.classmap.find(c, 0);
            if (nc < 0) {
                if (i2 == 1 + iIgnoreAtBeginning) {
                    ++iIgnoreAtBeginning;
                } else {
                    bEndOfLetters = true;
                }
                --iLength;
                continue;
            }
            if (!bEndOfLetters) {
                word[i2 - iIgnoreAtBeginning] = (char)nc;
                continue;
            }
            return null;
        }
        len = iLength;
        if (len < remainCharCount + pushCharCount) {
            return null;
        }
        int[] result2 = new int[len + 1];
        int k = 0;
        String sw = new String(word, 1, len);
        if (this.stoplist.containsKey(sw)) {
            ArrayList<Object> hw = this.stoplist.get(sw);
            int j = 0;
            for (i2 = 0; i2 < hw.size(); ++i2) {
                Object o = hw.get(i2);
                if (!(o instanceof String) || (j += ((String)o).length()) < remainCharCount || j >= len - pushCharCount) continue;
                result2[k++] = j + iIgnoreAtBeginning;
            }
        } else {
            word[0] = 46;
            word[len + 1] = 46;
            word[len + 2] = '\u0000';
            byte[] il = new byte[len + 3];
            for (i2 = 0; i2 < len + 1; ++i2) {
                this.searchPatterns(word, i2, il);
            }
            for (i2 = 0; i2 < len; ++i2) {
                if ((il[i2 + 1] & 1) != 1 || i2 < remainCharCount || i2 > len - pushCharCount) continue;
                result2[k++] = i2 + iIgnoreAtBeginning;
            }
        }
        if (k > 0) {
            int[] res = new int[k + 2];
            System.arraycopy(result2, 0, res, 1, k);
            res[0] = 0;
            res[k + 1] = len;
            return new Hyphenation(res);
        }
        return null;
    }

    @Override
    public void addClass(String chargroup) {
        if (chargroup.length() > 0) {
            char equivChar = chargroup.charAt(0);
            char[] key2 = new char[2];
            key2[1] = '\u0000';
            for (int i2 = 0; i2 < chargroup.length(); ++i2) {
                key2[0] = chargroup.charAt(i2);
                this.classmap.insert(key2, 0, equivChar);
            }
        }
    }

    @Override
    public void addException(String word, ArrayList<Object> hyphenatedword) {
        this.stoplist.put(word, hyphenatedword);
    }

    @Override
    public void addPattern(String pattern, String ivalue) {
        int k = this.ivalues.find(ivalue);
        if (k <= 0) {
            k = this.packValues(ivalue);
            this.ivalues.insert(ivalue, (char)k);
        }
        this.insert(pattern, (char)k);
    }

    @Override
    public void printStats() {
        System.out.println("Value space size = " + Integer.toString(this.vspace.length()));
        super.printStats();
    }
}

