/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cjk;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeSource;

public final class CJKBigramFilter
extends TokenFilter {
    public static final int HAN = 1;
    public static final int HIRAGANA = 2;
    public static final int KATAKANA = 4;
    public static final int HANGUL = 8;
    public static final String DOUBLE_TYPE = "<DOUBLE>";
    public static final String SINGLE_TYPE = "<SINGLE>";
    private static final String HAN_TYPE = StandardTokenizer.TOKEN_TYPES[10];
    private static final String HIRAGANA_TYPE = StandardTokenizer.TOKEN_TYPES[11];
    private static final String KATAKANA_TYPE = StandardTokenizer.TOKEN_TYPES[12];
    private static final String HANGUL_TYPE = StandardTokenizer.TOKEN_TYPES[13];
    private static final Object NO = new Object();
    private final Object doHan;
    private final Object doHiragana;
    private final Object doKatakana;
    private final Object doHangul;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    int[] buffer = new int[8];
    int[] startOffset = new int[8];
    int[] endOffset = new int[8];
    int bufferLen;
    int index;
    int lastEndOffset;
    private boolean exhausted;
    private AttributeSource.State loneState;

    public CJKBigramFilter(TokenStream in) {
        this(in, 15);
    }

    public CJKBigramFilter(TokenStream in, int flags) {
        super(in);
        this.doHan = (flags & 1) == 0 ? NO : HAN_TYPE;
        this.doHiragana = (flags & 2) == 0 ? NO : HIRAGANA_TYPE;
        this.doKatakana = (flags & 4) == 0 ? NO : KATAKANA_TYPE;
        this.doHangul = (flags & 8) == 0 ? NO : HANGUL_TYPE;
    }

    public boolean incrementToken() throws IOException {
        block6: {
            while (true) {
                if (this.hasBufferedBigram()) {
                    this.flushBigram();
                    return true;
                }
                if (!this.doNext()) break block6;
                String type2 = this.typeAtt.type();
                if (type2 != this.doHan && type2 != this.doHiragana && type2 != this.doKatakana && type2 != this.doHangul) break;
                if (this.offsetAtt.startOffset() != this.lastEndOffset) {
                    if (this.hasBufferedUnigram()) {
                        this.loneState = this.captureState();
                        this.flushUnigram();
                        return true;
                    }
                    this.index = 0;
                    this.bufferLen = 0;
                }
                this.refill();
            }
            if (this.hasBufferedUnigram()) {
                this.loneState = this.captureState();
                this.flushUnigram();
                return true;
            }
            return true;
        }
        if (this.hasBufferedUnigram()) {
            this.flushUnigram();
            return true;
        }
        return false;
    }

    private boolean doNext() throws IOException {
        if (this.loneState != null) {
            this.restoreState(this.loneState);
            this.loneState = null;
            return true;
        }
        if (this.exhausted) {
            return false;
        }
        if (this.input.incrementToken()) {
            return true;
        }
        this.exhausted = true;
        return false;
    }

    private void refill() throws IOException {
        if (this.bufferLen > 64) {
            int last2 = this.bufferLen - 1;
            this.buffer[0] = this.buffer[last2];
            this.startOffset[0] = this.startOffset[last2];
            this.endOffset[0] = this.endOffset[last2];
            this.bufferLen = 1;
            this.index -= last2;
        }
        char[] termBuffer = this.termAtt.buffer();
        int len = this.termAtt.length();
        int start2 = this.offsetAtt.startOffset();
        int end2 = this.offsetAtt.endOffset();
        int newSize = this.bufferLen + len;
        this.buffer = ArrayUtil.grow(this.buffer, newSize);
        this.startOffset = ArrayUtil.grow(this.startOffset, newSize);
        this.endOffset = ArrayUtil.grow(this.endOffset, newSize);
        this.lastEndOffset = end2;
        if (end2 - start2 != len) {
            int cp = 0;
            for (int i2 = 0; i2 < len; i2 += Character.charCount(cp)) {
                cp = this.buffer[this.bufferLen] = Character.codePointAt(termBuffer, i2, len);
                this.startOffset[this.bufferLen] = start2;
                this.endOffset[this.bufferLen] = end2;
                ++this.bufferLen;
            }
        } else {
            int cp = 0;
            int cpLen = 0;
            for (int i3 = 0; i3 < len; i3 += cpLen) {
                cp = this.buffer[this.bufferLen] = Character.codePointAt(termBuffer, i3, len);
                cpLen = Character.charCount(cp);
                this.startOffset[this.bufferLen] = start2;
                start2 = this.endOffset[this.bufferLen] = start2 + cpLen;
                ++this.bufferLen;
            }
        }
    }

    private void flushBigram() {
        this.clearAttributes();
        char[] termBuffer = this.termAtt.resizeBuffer(4);
        int len1 = Character.toChars(this.buffer[this.index], termBuffer, 0);
        int len2 = len1 + Character.toChars(this.buffer[this.index + 1], termBuffer, len1);
        this.termAtt.setLength(len2);
        this.offsetAtt.setOffset(this.startOffset[this.index], this.endOffset[this.index + 1]);
        this.typeAtt.setType(DOUBLE_TYPE);
        ++this.index;
    }

    private void flushUnigram() {
        this.clearAttributes();
        char[] termBuffer = this.termAtt.resizeBuffer(2);
        int len = Character.toChars(this.buffer[this.index], termBuffer, 0);
        this.termAtt.setLength(len);
        this.offsetAtt.setOffset(this.startOffset[this.index], this.endOffset[this.index]);
        this.typeAtt.setType(SINGLE_TYPE);
        ++this.index;
    }

    private boolean hasBufferedBigram() {
        return this.bufferLen - this.index > 1;
    }

    private boolean hasBufferedUnigram() {
        return this.bufferLen == 1 && this.index == 0;
    }

    public void reset() throws IOException {
        super.reset();
        this.bufferLen = 0;
        this.index = 0;
        this.lastEndOffset = 0;
        this.loneState = null;
        this.exhausted = false;
    }
}

