/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.bg;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.KeywordMarkerFilter;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.bg.BulgarianStemFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BulgarianAnalyzer
extends StopwordAnalyzerBase {
    public static final String DEFAULT_STOPWORD_FILE = "stopwords.txt";
    @Deprecated
    public static final String STOPWORDS_COMMENT = "#";
    private final Set<?> stemExclusionSet;

    public static Set<?> getDefaultStopSet() {
        return DefaultSetHolder.DEFAULT_STOP_SET;
    }

    public BulgarianAnalyzer(Version matchVersion) {
        this(matchVersion, DefaultSetHolder.DEFAULT_STOP_SET);
    }

    public BulgarianAnalyzer(Version matchVersion, Set<?> stopwords) {
        this(matchVersion, stopwords, CharArraySet.EMPTY_SET);
    }

    public BulgarianAnalyzer(Version matchVersion, Set<?> stopwords, Set<?> stemExclusionSet) {
        super(matchVersion, stopwords);
        this.stemExclusionSet = CharArraySet.unmodifiableSet(CharArraySet.copy(matchVersion, stemExclusionSet));
    }

    @Override
    public ReusableAnalyzerBase.TokenStreamComponents createComponents(String fieldName, Reader reader) {
        StandardTokenizer source2 = new StandardTokenizer(this.matchVersion, reader);
        TokenFilter result2 = new StandardFilter(this.matchVersion, source2);
        result2 = new LowerCaseFilter(this.matchVersion, result2);
        result2 = new StopFilter(this.matchVersion, (TokenStream)result2, this.stopwords);
        if (!this.stemExclusionSet.isEmpty()) {
            result2 = new KeywordMarkerFilter((TokenStream)result2, this.stemExclusionSet);
        }
        result2 = new BulgarianStemFilter(result2);
        return new ReusableAnalyzerBase.TokenStreamComponents(source2, result2);
    }

    private static class DefaultSetHolder {
        static final Set<?> DEFAULT_STOP_SET;

        private DefaultSetHolder() {
        }

        static {
            try {
                DEFAULT_STOP_SET = BulgarianAnalyzer.loadStopwordSet(false, BulgarianAnalyzer.class, BulgarianAnalyzer.DEFAULT_STOPWORD_FILE, BulgarianAnalyzer.STOPWORDS_COMMENT);
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

