/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.ReusableAnalyzerBase;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class StopwordAnalyzerBase
extends ReusableAnalyzerBase {
    protected final CharArraySet stopwords;
    protected final Version matchVersion;

    public Set<?> getStopwordSet() {
        return this.stopwords;
    }

    protected StopwordAnalyzerBase(Version version, Set<?> stopwords) {
        this.matchVersion = version;
        this.stopwords = stopwords == null ? CharArraySet.EMPTY_SET : CharArraySet.unmodifiableSet(CharArraySet.copy(version, stopwords));
    }

    protected StopwordAnalyzerBase(Version version) {
        this(version, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(boolean ignoreCase, Class<? extends ReusableAnalyzerBase> aClass, String resource2, String comment2) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(aClass.getResourceAsStream(resource2), IOUtils.CHARSET_UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, comment2, new CharArraySet(Version.LUCENE_31, 16, ignoreCase));
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(File stopwords, Version matchVersion) throws IOException {
        CharArraySet charArraySet;
        Reader reader = null;
        try {
            reader = IOUtils.getDecodingReader(stopwords, IOUtils.CHARSET_UTF_8);
            charArraySet = WordlistLoader.getWordSet(reader, matchVersion);
        }
        catch (Throwable throwable) {
            IOUtils.close(reader);
            throw throwable;
        }
        IOUtils.close(reader);
        return charArraySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static CharArraySet loadStopwordSet(Reader stopwords, Version matchVersion) throws IOException {
        CharArraySet charArraySet;
        try {
            charArraySet = WordlistLoader.getWordSet(stopwords, matchVersion);
        }
        catch (Throwable throwable) {
            IOUtils.close(stopwords);
            throw throwable;
        }
        IOUtils.close(stopwords);
        return charArraySet;
    }
}

