/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.LangUtils;

public class BasicHeaderElement
implements HeaderElement,
Cloneable {
    private final String name;
    private final String value;
    private final NameValuePair[] parameters;

    public BasicHeaderElement(String name2, String value2, NameValuePair[] parameters2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        this.name = name2;
        this.value = value2;
        this.parameters = parameters2 != null ? parameters2 : new NameValuePair[0];
    }

    public BasicHeaderElement(String name2, String value2) {
        this(name2, value2, null);
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public NameValuePair[] getParameters() {
        return (NameValuePair[])this.parameters.clone();
    }

    public int getParameterCount() {
        return this.parameters.length;
    }

    public NameValuePair getParameter(int index2) {
        return this.parameters[index2];
    }

    public NameValuePair getParameterByName(String name2) {
        if (name2 == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        NameValuePair found = null;
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            NameValuePair current2 = this.parameters[i2];
            if (!current2.getName().equalsIgnoreCase(name2)) continue;
            found = current2;
            break;
        }
        return found;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof HeaderElement) {
            BasicHeaderElement that = (BasicHeaderElement)object;
            return this.name.equals(that.name) && LangUtils.equals(this.value, that.value) && LangUtils.equals(this.parameters, that.parameters);
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = LangUtils.hashCode(hash2, this.name);
        hash2 = LangUtils.hashCode(hash2, this.value);
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            hash2 = LangUtils.hashCode(hash2, this.parameters[i2]);
        }
        return hash2;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.name);
        if (this.value != null) {
            buffer.append("=");
            buffer.append(this.value);
        }
        for (int i2 = 0; i2 < this.parameters.length; ++i2) {
            buffer.append("; ");
            buffer.append(this.parameters[i2]);
        }
        return buffer.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

