/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.cache.Resource;

@ThreadSafe
public class FileResource
implements Resource {
    private static final long serialVersionUID = 4132244415919043397L;
    private final File file;
    private volatile boolean disposed;

    public FileResource(File file2) {
        this.file = file2;
        this.disposed = false;
    }

    private void ensureValid() {
        if (this.disposed) {
            throw new IllegalStateException("Resource has been deallocated");
        }
    }

    synchronized File getFile() {
        this.ensureValid();
        return this.file;
    }

    public synchronized InputStream getInputStream() throws IOException {
        this.ensureValid();
        return new FileInputStream(this.file);
    }

    public synchronized long length() {
        this.ensureValid();
        return this.file.length();
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        this.file.delete();
    }
}

