/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.net.Socket;
import org.apache.http.impl.SocketHttpServerConnection;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class DefaultHttpServerConnection
extends SocketHttpServerConnection {
    public void bind(Socket socket2, HttpParams params2) throws IOException {
        if (socket2 == null) {
            throw new IllegalArgumentException("Socket may not be null");
        }
        if (params2 == null) {
            throw new IllegalArgumentException("HTTP parameters may not be null");
        }
        this.assertNotOpen();
        socket2.setTcpNoDelay(HttpConnectionParams.getTcpNoDelay(params2));
        socket2.setSoTimeout(HttpConnectionParams.getSoTimeout(params2));
        int linger2 = HttpConnectionParams.getLinger(params2);
        if (linger2 >= 0) {
            socket2.setSoLinger(linger2 > 0, linger2);
        }
        super.bind(socket2, params2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        if (this.isOpen()) {
            buffer.append(this.getRemotePort());
        } else {
            buffer.append("closed");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

