/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nokogiri.internals.NokogiriHelpers;
import org.cyberneko.html.HTMLElements;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveContextVisitor {
    private final StringBuffer buffer = new StringBuffer();
    private final Stack<String> indentation;
    private String encoding;
    private final String indentString;
    private boolean format;
    private final boolean noDecl;
    private final boolean noEmpty;
    private final boolean noXhtml;
    private final boolean asXhtml;
    private boolean asXml;
    private final boolean asHtml;
    private final boolean asBuilder;
    private boolean htmlDoc;
    private final boolean fragment;
    private final boolean canonical;
    private final boolean incl_ns;
    private final boolean with_comments;
    private boolean subsets;
    private boolean exclusive;
    private final List<Node> c14nNodeList;
    private final Deque<Attr[]> c14nNamespaceStack;
    private final Deque<Attr[]> c14nAttrStack;
    private List<String> c14nExclusiveInclusivePrefixes = null;
    public static final int FORMAT = 1;
    public static final int NO_DECL = 2;
    public static final int NO_EMPTY = 4;
    public static final int NO_XHTML = 8;
    public static final int AS_XHTML = 16;
    public static final int AS_XML = 32;
    public static final int AS_HTML = 64;
    public static final int AS_BUILDER = 128;
    public static final int CANONICAL = 1;
    public static final int INCL_NS = 2;
    public static final int WITH_COMMENTS = 4;
    public static final int SUBSETS = 8;
    public static final int EXCLUSIVE = 16;
    private static Pattern p = Pattern.compile("charset(()|\\s+)=(()|\\s+)(\\w|\\_|\\.|\\-)+", 2);
    public static final String[] HTML_BOOLEAN_ATTRS = new String[]{"checked", "compact", "declare", "defer", "disabled", "ismap", "multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"};
    private static char lineSeparator = (char)10;

    public SaveContextVisitor(int n, String string2, String string3, boolean bl, boolean bl2, int n2) {
        this.encoding = string3;
        this.indentation = new Stack();
        this.indentation.push("");
        this.htmlDoc = bl;
        this.fragment = bl2;
        this.c14nNodeList = new ArrayList<Node>();
        this.c14nNamespaceStack = new ArrayDeque<Attr[]>();
        this.c14nAttrStack = new ArrayDeque<Attr[]>();
        this.format = (n & 1) == 1;
        this.noDecl = (n & 2) == 2;
        this.noEmpty = (n & 4) == 4;
        this.noXhtml = (n & 8) == 8;
        this.asXhtml = (n & 0x10) == 16;
        this.asXml = (n & 0x20) == 32;
        this.asHtml = (n & 0x40) == 64;
        this.asBuilder = (n & 0x80) == 128;
        this.canonical = (n2 & 1) == 1;
        this.incl_ns = (n2 & 2) == 2;
        this.with_comments = (n2 & 4) == 4;
        boolean bl3 = this.subsets = (n2 & 8) == 8;
        if (this.format && string2 == null || this.format && string2.length() == 0) {
            string2 = "  ";
        }
        if (!this.format && string2 != null && string2.length() > 0) {
            this.format = true;
        }
        if (this.asBuilder && string2 == null || this.asBuilder && string2.length() == 0) {
            string2 = "  ";
        }
        this.indentString = string2;
        if (!(this.asXml || this.asHtml || this.asXhtml || this.asBuilder)) {
            this.asXml = true;
        }
    }

    public String toString() {
        return new String(this.buffer);
    }

    public void setHtmlDoc(boolean bl) {
        this.htmlDoc = bl;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
    }

    public List<Node> getC14nNodeList() {
        return this.c14nNodeList;
    }

    public void setC14nExclusiveInclusivePrefixes(List<String> list2) {
        this.c14nExclusiveInclusivePrefixes = list2;
    }

    public boolean enter(Node node) {
        if (node instanceof Document) {
            return this.enter((Document)node);
        }
        if (node instanceof Element) {
            return this.enter((Element)node);
        }
        if (node instanceof Attr) {
            return this.enter((Attr)node);
        }
        if (node instanceof Text) {
            return this.enter((Text)node);
        }
        if (node instanceof CDATASection) {
            return this.enter((CDATASection)node);
        }
        if (node instanceof Comment) {
            return this.enter((Comment)node);
        }
        if (node instanceof DocumentType) {
            return this.enter((DocumentType)node);
        }
        if (node instanceof Entity) {
            return this.enter((Entity)node);
        }
        if (node instanceof EntityReference) {
            return this.enter((EntityReference)node);
        }
        if (node instanceof Notation) {
            return this.enter((Notation)node);
        }
        if (node instanceof ProcessingInstruction) {
            return this.enter((ProcessingInstruction)node);
        }
        return false;
    }

    public void leave(Node node) {
        if (node instanceof Document) {
            this.leave((Document)node);
            return;
        }
        if (node instanceof Element) {
            this.leave((Element)node);
            return;
        }
        if (node instanceof Attr) {
            this.leave((Attr)node);
            return;
        }
        if (node instanceof Text) {
            return;
        }
        if (node instanceof CDATASection) {
            this.leave((CDATASection)node);
            return;
        }
        if (node instanceof Comment) {
            this.leave((Comment)node);
            return;
        }
        if (node instanceof DocumentType) {
            this.leave((DocumentType)node);
            return;
        }
        if (node instanceof Entity) {
            this.leave((Entity)node);
            return;
        }
        if (node instanceof EntityReference) {
            this.leave((EntityReference)node);
            return;
        }
        if (node instanceof Notation) {
            this.leave((Notation)node);
            return;
        }
        if (node instanceof ProcessingInstruction) {
            this.leave((ProcessingInstruction)node);
            return;
        }
    }

    public boolean enter(String string2) {
        this.buffer.append(string2);
        return true;
    }

    public void leave(String string2) {
    }

    public boolean enter(Attr attr2) {
        String string2 = attr2.getName();
        this.buffer.append(string2);
        if (!this.asHtml || !this.isHtmlBooleanAttr(string2)) {
            this.buffer.append("=");
            this.buffer.append("\"");
            String string3 = this.replaceCharsetIfNecessary(attr2);
            this.buffer.append(this.serializeAttrTextContent(string3, this.htmlDoc));
            this.buffer.append("\"");
        }
        return true;
    }

    private String replaceCharsetIfNecessary(Attr attr2) {
        String string2 = attr2.getValue();
        if (this.encoding == null) {
            return string2;
        }
        if (!"content".equals(attr2.getName().toLowerCase())) {
            return string2;
        }
        if (!"meta".equals(attr2.getOwnerElement().getNodeName().toLowerCase())) {
            return string2;
        }
        Matcher matcher = p.matcher(string2);
        if (!matcher.find()) {
            return string2;
        }
        if (string2.contains(this.encoding)) {
            return string2;
        }
        return string2.replace(matcher.group(), "charset=" + this.encoding);
    }

    private boolean isHtmlBooleanAttr(String string2) {
        for (String string3 : HTML_BOOLEAN_ATTRS) {
            if (!string3.equals(string2)) continue;
            return true;
        }
        return false;
    }

    private String serializeAttrTextContent(String string2, boolean bl) {
        if (string2 == null) {
            return "";
        }
        char[] cArray = string2.toCharArray();
        StringBuffer stringBuffer = new StringBuffer(cArray.length);
        block9: for (int j = 0; j < cArray.length; ++j) {
            switch (cArray[j]) {
                case '\n': {
                    stringBuffer.append("&#10;");
                    continue block9;
                }
                case '\r': {
                    stringBuffer.append("&#13;");
                    continue block9;
                }
                case '\t': {
                    stringBuffer.append("&#9;");
                    continue block9;
                }
                case '\"': {
                    if (bl) {
                        stringBuffer.append("%22");
                        continue block9;
                    }
                    stringBuffer.append("&quot;");
                    continue block9;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block9;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block9;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block9;
                }
                default: {
                    stringBuffer.append(cArray[j]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public void leave(Attr attr2) {
    }

    public boolean enter(CDATASection cDATASection) {
        this.buffer.append("<![CDATA[");
        this.buffer.append(cDATASection.getData());
        this.buffer.append("]]>");
        return true;
    }

    public void leave(CDATASection cDATASection) {
    }

    public boolean enter(Comment comment2) {
        if (this.canonical) {
            this.c14nNodeList.add(comment2);
            if (!this.with_comments) {
                return true;
            }
        }
        this.buffer.append("<!--");
        this.buffer.append(comment2.getData());
        this.buffer.append("-->");
        return true;
    }

    public void leave(Comment comment2) {
    }

    public boolean enter(Document document) {
        if (!this.noDecl) {
            this.buffer.append("<?xml version=\"");
            this.buffer.append(document.getXmlVersion());
            this.buffer.append("\"");
            if (this.encoding != null) {
                this.buffer.append(" encoding=\"");
                this.buffer.append(this.encoding);
                this.buffer.append("\"");
            }
            this.buffer.append("?>\n");
        }
        return true;
    }

    public void leave(Document document) {
    }

    public boolean enter(DocumentType documentType) {
        if (this.canonical) {
            this.c14nNodeList.add(documentType);
            return true;
        }
        String string2 = documentType.getName();
        String string3 = documentType.getPublicId();
        String string4 = documentType.getSystemId();
        String string5 = documentType.getInternalSubset();
        if (documentType.getPreviousSibling() != null) {
            this.buffer.append("\n");
        }
        this.buffer.append("<!DOCTYPE " + string2 + " ");
        if (string3 != null) {
            this.buffer.append("PUBLIC \"" + string3 + "\"");
            if (string4 != null) {
                this.buffer.append(" \"" + string4 + "\"");
            }
        } else if (string4 != null) {
            this.buffer.append("SYSTEM \"" + string4 + "\"");
        }
        if (string5 != null) {
            this.buffer.append(" [");
            this.buffer.append(string5);
            this.buffer.append("]");
        }
        this.buffer.append(">\n");
        return true;
    }

    public void leave(DocumentType documentType) {
    }

    public boolean enter(Element element) {
        Attr[] attrArray;
        if (this.canonical) {
            this.c14nNodeList.add(element);
            if (element == element.getOwnerDocument().getDocumentElement()) {
                this.c14nNodeList.add(element.getOwnerDocument());
            }
        }
        String string2 = this.indentation.peek();
        this.buffer.append(string2);
        if (this.needIndent(element)) {
            this.indentation.push(string2 + this.indentString);
        }
        String string3 = element.getTagName();
        this.buffer.append("<" + string3);
        for (Attr attr2 : attrArray = this.getAttrsAndNamespaces(element)) {
            if (!attr2.getSpecified()) continue;
            this.buffer.append(" ");
            this.enter(attr2);
            this.leave(attr2);
        }
        if (element.hasChildNodes()) {
            this.buffer.append(">");
            if (this.needBreakInOpening(element)) {
                this.buffer.append("\n");
            }
            return true;
        }
        if (this.asHtml) {
            this.buffer.append(">");
        } else if (this.asXml && this.noEmpty) {
            this.buffer.append(">");
        } else {
            if (this.asXhtml) {
                this.buffer.append(" ");
            }
            this.buffer.append("/>");
        }
        if (this.needBreakInOpening(element)) {
            this.buffer.append("\n");
        }
        return true;
    }

    private boolean needIndent(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        return this.format || this.asBuilder;
    }

    private boolean needBreakInOpening(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        if (this.format) {
            return true;
        }
        if (this.asBuilder && element.getFirstChild() != null && element.getFirstChild().getNodeType() == 1) {
            return true;
        }
        return this.format && element.getNextSibling() == null && element.hasChildNodes();
    }

    private boolean isEmpty(String string2) {
        HTMLElements.Element element = HTMLElements.getElement(string2);
        return element.isEmpty();
    }

    private Attr[] getAttrsAndNamespaces(Element element) {
        Attr[] attrArray;
        Attr[] attrArray2;
        NamedNodeMap namedNodeMap = element.getAttributes();
        if (!this.canonical) {
            if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
                return new Attr[0];
            }
            Attr[] attrArray3 = new Attr[namedNodeMap.getLength()];
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                attrArray3[j] = (Attr)namedNodeMap.item(j);
            }
            return attrArray3;
        }
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        ArrayList<Attr> arrayList2 = new ArrayList<Attr>();
        if (this.subsets) {
            this.getAttrsOfAncestors(element.getParentNode(), arrayList, arrayList2);
            attrArray2 = this.getSortedArray(arrayList);
            attrArray = this.getSortedArray(arrayList2);
            this.c14nNamespaceStack.push(attrArray2);
            this.c14nAttrStack.push(attrArray);
            this.subsets = false;
        }
        this.getNamespacesAndAttrs(element, arrayList, arrayList2);
        attrArray2 = this.getSortedArray(arrayList);
        attrArray = this.getSortedArray(arrayList2);
        Attr[] attrArray4 = new Attr[attrArray2.length + attrArray.length];
        for (int j = 0; j < attrArray4.length; ++j) {
            attrArray4[j] = j < attrArray2.length ? attrArray2[j] : attrArray[j - attrArray2.length];
        }
        this.c14nNamespaceStack.push(attrArray2);
        this.c14nAttrStack.push(attrArray);
        return attrArray4;
    }

    private void getAttrsOfAncestors(Node node, List<Attr> list2, List<Attr> list3) {
        if (node == null) {
            return;
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap == null || namedNodeMap.getLength() == 0) {
            return;
        }
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Attr attr2 = (Attr)namedNodeMap.item(j);
            if (NokogiriHelpers.isNamespace(attr2.getNodeName())) {
                list2.add(attr2);
                continue;
            }
            list3.add(attr2);
        }
        this.getAttrsOfAncestors(node.getParentNode(), list2, list3);
    }

    private void getNamespacesAndAttrs(Node node, List<Attr> list2, List<Attr> list3) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int j = 0; j < namedNodeMap.getLength(); ++j) {
            Attr attr2 = (Attr)namedNodeMap.item(j);
            if (NokogiriHelpers.isNamespace(attr2.getNodeName())) {
                this.getNamespacesWithPropagated(list2, attr2);
            } else {
                this.getAttributesWithPropagated(list3, attr2);
            }
            if (!this.exclusive) continue;
            this.verifyXmlSpace(list3, namedNodeMap);
        }
    }

    private void getNamespacesWithPropagated(List<Attr> list2, Attr attr2) {
        boolean bl = true;
        for (Attr[] attrArray : this.c14nNamespaceStack) {
            for (int j = 0; j < attrArray.length; ++j) {
                if (!attrArray[j].getNodeName().equals(attr2.getNodeName())) continue;
                if (attrArray[j].getNodeValue().equals(attr2.getNodeValue())) {
                    bl = false;
                    continue;
                }
                list2.remove(attrArray[j]);
            }
            if (!bl || list2.contains(attr2)) continue;
            list2.add(attr2);
        }
    }

    private void getAttributesWithPropagated(List<Attr> list2, Attr attr2) {
        boolean bl = true;
        for (Attr[] attrArray : this.c14nAttrStack) {
            for (int j = 0; j < attrArray.length; ++j) {
                if (!attrArray[j].getNodeName().startsWith("xml:") || !attrArray[j].getNodeName().equals(attr2.getNodeName())) continue;
                if (attrArray[j].getNodeValue().equals(attr2.getNodeValue())) {
                    bl = false;
                    continue;
                }
                list2.remove(attrArray[j]);
            }
            if (!bl) continue;
            list2.add(attr2);
        }
    }

    private void verifyXmlSpace(List<Attr> list2, NamedNodeMap namedNodeMap) {
        Attr attr2 = (Attr)namedNodeMap.getNamedItem("xml:space");
        if (attr2 == null) {
            for (int j = 0; j < list2.size(); ++j) {
                if (!list2.get(j).getNodeName().equals("xml:space")) continue;
                list2.remove(j);
                break;
            }
        }
    }

    private Attr[] getSortedArray(List<Attr> list2) {
        Attr[] attrArray = list2.toArray(new Attr[0]);
        Arrays.sort(attrArray, new Comparator<Attr>(){

            @Override
            public int compare(Attr attr2, Attr attr3) {
                return attr2.getNodeName().compareTo(attr3.getNodeName());
            }
        });
        return attrArray;
    }

    public void leave(Element element) {
        if (this.canonical) {
            this.c14nNamespaceStack.poll();
            this.c14nAttrStack.poll();
        }
        String string2 = element.getTagName();
        if (element.hasChildNodes()) {
            if (this.needIndentInClosing(element)) {
                this.indentation.pop();
                this.buffer.append(this.indentation.peek());
            } else if (this.asBuilder && !this.containsText(element)) {
                this.indentation.pop();
            }
            this.buffer.append("</" + string2 + ">");
            if (this.needBreakInClosing(element)) {
                this.buffer.append("\n");
            }
            return;
        }
        if ((this.asHtml || this.noEmpty) && !this.isEmpty(string2) && this.noEmpty) {
            this.buffer.append("</" + string2 + ">");
        }
        if (this.needBreakInClosing(element)) {
            if (!this.containsText(element)) {
                this.indentation.pop();
            }
            this.buffer.append("\n");
        }
    }

    private boolean needIndentInClosing(Element element) {
        if (this.containsText(element)) {
            return false;
        }
        if (this.fragment) {
            return false;
        }
        if (this.format) {
            return true;
        }
        return this.asBuilder && element.getFirstChild() != null && element.getFirstChild().getNodeType() == 1;
    }

    private boolean needBreakInClosing(Element element) {
        if (this.fragment) {
            return false;
        }
        return this.format || this.asBuilder;
    }

    private boolean containsText(Element element) {
        return element.getFirstChild() != null && element.getFirstChild().getNodeType() == 3;
    }

    public boolean enter(Entity entity) {
        String string2 = entity.getNodeName();
        String string3 = entity.getPublicId();
        String string4 = entity.getSystemId();
        String string5 = entity.getNotationName();
        this.buffer.append("<!ENTITY ");
        this.buffer.append(string2);
        if (string3 != null) {
            this.buffer.append(" PUBLIC \"");
            this.buffer.append(string3);
            this.buffer.append("\"");
        }
        if (string4 != null) {
            this.buffer.append(" SYSTEM \"");
            this.buffer.append(string4);
            this.buffer.append("\"");
        }
        if (string5 != null) {
            this.buffer.append(" NDATA ");
            this.buffer.append(string5);
        }
        this.buffer.append(">");
        return true;
    }

    public void leave(Entity entity) {
    }

    public boolean enter(EntityReference entityReference) {
        this.buffer.append("&" + entityReference.getNodeName() + ";");
        return true;
    }

    public void leave(EntityReference entityReference) {
    }

    public boolean enter(Notation notation) {
        String string2 = notation.getNodeName();
        String string3 = notation.getPublicId();
        String string4 = notation.getSystemId();
        this.buffer.append("<!NOTATION ");
        this.buffer.append(string2);
        if (string3 != null) {
            this.buffer.append(" PUBLIC \"");
            this.buffer.append(string3);
            this.buffer.append("\"");
            if (string4 != null) {
                this.buffer.append(" \"");
                this.buffer.append(string4);
                this.buffer.append("\"");
            }
        } else if (string4 != null) {
            this.buffer.append(" SYSTEM \"");
            this.buffer.append(string4);
            this.buffer.append("\"");
        }
        this.buffer.append(">");
        return true;
    }

    public void leave(Notation notation) {
    }

    public boolean enter(ProcessingInstruction processingInstruction) {
        this.buffer.append("<?");
        this.buffer.append(processingInstruction.getTarget());
        this.buffer.append(" ");
        this.buffer.append(processingInstruction.getData());
        if (this.asHtml) {
            this.buffer.append(">");
        } else {
            this.buffer.append("?>");
        }
        this.buffer.append("\n");
        if (this.canonical) {
            this.c14nNodeList.add(processingInstruction);
        }
        return true;
    }

    public void leave(ProcessingInstruction processingInstruction) {
    }

    private boolean isHtmlScript(Text text) {
        return this.htmlDoc && text.getParentNode().getNodeName().equals("script");
    }

    public boolean enter(Text text) {
        String string2 = text.getNodeValue();
        if (this.canonical) {
            this.c14nNodeList.add(text);
            if (NokogiriHelpers.isWhitespaceText(string2)) {
                this.buffer.append(NokogiriHelpers.canonicalizeWhitespce(string2));
                return true;
            }
        }
        if (NokogiriHelpers.shouldEncode(text) && !this.isHtmlScript(text)) {
            string2 = NokogiriHelpers.encodeJavaString(string2);
        }
        string2 = this.encodeStringToHtmlEntity(string2);
        this.buffer.append(string2);
        return true;
    }

    private String getEncoding(Text text) {
        if (this.encoding != null) {
            return this.encoding;
        }
        this.encoding = text.getOwnerDocument().getInputEncoding();
        return this.encoding;
    }

    private String encodeStringToHtmlEntity(String string2) {
        if (this.encoding == null) {
            return string2;
        }
        CharsetEncoder charsetEncoder = Charset.forName(this.encoding).newEncoder();
        int n = 126;
        StringBuffer stringBuffer = new StringBuffer();
        for (int j = 0; j < string2.length(); ++j) {
            char c = string2.charAt(j);
            if (charsetEncoder.canEncode(c)) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append("&#x" + Integer.toHexString(c) + ";");
        }
        return new String(stringBuffer);
    }
}

