/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import nokogiri.NokogiriService;
import nokogiri.XmlAttr;
import nokogiri.XmlDocument;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import org.apache.xerces.xni.XMLAttributes;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyHash;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReaderNode {
    Ruby ruby;
    public ReaderAttributeList attributeList;
    public Map<String, String> namespaces;
    public int depth;
    public int nodeType;
    public String lang;
    public String localName;
    public String xmlBase;
    public String prefix;
    public String name;
    public String uri;
    public String value;
    public String xmlVersion = "1.0";
    public int startOffset;
    public int endOffset;
    public boolean hasChildren = false;
    private Document document = null;
    private static ElementNode elementNode = null;
    private static ClosingNode closingNode = null;
    private static TextNode textNode = null;

    public abstract String getString();

    public IRubyObject getAttributeByIndex(IRubyObject iRubyObject) {
        if (iRubyObject.isNil()) {
            return iRubyObject;
        }
        long l = iRubyObject.convertToInteger().getLongValue();
        if (l > Integer.MAX_VALUE) {
            throw this.ruby.newArgumentError("value too long to be an array index");
        }
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        if (l < 0L || (long)this.attributeList.length <= l) {
            return this.ruby.getNil();
        }
        return NokogiriHelpers.stringOrBlank(this.ruby, this.attributeList.values.get(Long.valueOf(l).intValue()));
    }

    public IRubyObject getAttributeByName(IRubyObject iRubyObject) {
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        String string2 = this.attributeList.getByName(NokogiriHelpers.rubyStringToString(iRubyObject));
        return NokogiriHelpers.stringOrNil(this.ruby, string2);
    }

    public IRubyObject getAttributeByName(String string2) {
        if (this.attributeList == null) {
            return this.ruby.getNil();
        }
        String string3 = this.attributeList.getByName(string2);
        return NokogiriHelpers.stringOrNil(this.ruby, string3);
    }

    public IRubyObject getAttributeCount() {
        if (this.attributeList == null) {
            return this.ruby.newFixnum(0);
        }
        return this.ruby.newFixnum(this.attributeList.length);
    }

    public IRubyObject getAttributesNodes() {
        RubyArray rubyArray = RubyArray.newArray(this.ruby);
        if (this.attributeList != null && this.attributeList.length > 0) {
            if (this.document == null) {
                XmlDocument xmlDocument = (XmlDocument)XmlDocument.rbNew(this.ruby.getCurrentContext(), NokogiriHelpers.getNokogiriClass(this.ruby, "Nokogiri::XML::Document"), new IRubyObject[0]);
                this.document = xmlDocument.getDocument();
            }
            for (int j = 0; j < this.attributeList.length; ++j) {
                if (NokogiriHelpers.isNamespace(this.attributeList.names.get(j))) continue;
                Attr attr2 = this.document.createAttributeNS(this.attributeList.namespaces.get(j), this.attributeList.names.get(j));
                attr2.setValue(this.attributeList.values.get(j));
                XmlAttr xmlAttr = (XmlAttr)NokogiriService.XML_ATTR_ALLOCATOR.allocate(this.ruby, NokogiriHelpers.getNokogiriClass(this.ruby, "Nokogiri::XML::Attr"));
                xmlAttr.setNode(this.ruby.getCurrentContext(), attr2);
                rubyArray.append(xmlAttr);
            }
        }
        return rubyArray;
    }

    public IRubyObject getAttributes(ThreadContext threadContext) {
        if (this.attributeList == null) {
            return threadContext.getRuntime().getNil();
        }
        RubyHash rubyHash = RubyHash.newHash(threadContext.getRuntime());
        for (int j = 0; j < this.attributeList.length; ++j) {
            IRubyObject iRubyObject = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), this.attributeList.names.get(j));
            IRubyObject iRubyObject2 = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), this.attributeList.values.get(j));
            if (threadContext.getRuntime().is1_9()) {
                rubyHash.op_aset19(threadContext, iRubyObject, iRubyObject2);
                continue;
            }
            rubyHash.op_aset(threadContext, iRubyObject, iRubyObject2);
        }
        return rubyHash;
    }

    public IRubyObject getDepth() {
        return this.ruby.newFixnum(this.depth);
    }

    public IRubyObject getLang() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.lang);
    }

    public IRubyObject getLocalName() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.localName);
    }

    public IRubyObject getName() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.name);
    }

    public IRubyObject getNamespaces(ThreadContext threadContext) {
        if (this.namespaces == null) {
            return this.ruby.getNil();
        }
        RubyHash rubyHash = RubyHash.newHash(this.ruby);
        Set<String> set = this.namespaces.keySet();
        for (String string2 : set) {
            String string3 = this.namespaces.get(string2);
            IRubyObject iRubyObject = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), string2);
            IRubyObject iRubyObject2 = NokogiriHelpers.stringOrBlank(threadContext.getRuntime(), string3);
            if (threadContext.getRuntime().is1_9()) {
                rubyHash.op_aset19(threadContext, iRubyObject, iRubyObject2);
                continue;
            }
            rubyHash.op_aset(threadContext, iRubyObject, iRubyObject2);
        }
        return rubyHash;
    }

    public IRubyObject getXmlBase() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.xmlBase);
    }

    public IRubyObject getPrefix() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.prefix);
    }

    public IRubyObject getUri() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.uri);
    }

    public IRubyObject getValue() {
        return NokogiriHelpers.stringOrNil(this.ruby, this.value);
    }

    public IRubyObject getXmlVersion() {
        return this.ruby.newString(this.xmlVersion);
    }

    public RubyBoolean hasAttributes() {
        if (this.attributeList == null || this.attributeList.length == 0) {
            return this.ruby.getFalse();
        }
        return this.ruby.getTrue();
    }

    public abstract RubyBoolean hasValue();

    public RubyBoolean isDefault() {
        return this.ruby.getFalse();
    }

    public boolean isError() {
        return false;
    }

    protected void parsePrefix(String string2) {
        int n = string2.indexOf(58);
        if (n != -1) {
            this.prefix = string2.substring(0, n);
        }
    }

    public void setLang(String string2) {
        string2 = string2 != null ? string2 : null;
    }

    public IRubyObject toSyntaxError() {
        return this.ruby.getNil();
    }

    public IRubyObject getNodeType() {
        return this.ruby.newFixnum(this.nodeType);
    }

    public static ClosingNode createClosingNode(Ruby ruby2, String string2, String string3, String string4, int n, Stack<String> stack, Stack<String> stack2) {
        ClosingNode closingNode;
        if (ReaderNode.closingNode == null) {
            ReaderNode.closingNode = new ClosingNode();
        }
        try {
            closingNode = (ClosingNode)ReaderNode.closingNode.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            closingNode = new ClosingNode();
        }
        closingNode.init(ruby2, string2, string3, string4, n, stack, stack2);
        return closingNode;
    }

    public static ElementNode createElementNode(Ruby ruby2, String string2, String string3, String string4, XMLAttributes xMLAttributes, int n, Stack<String> stack, Stack<String> stack2) {
        ElementNode elementNode;
        if (ReaderNode.elementNode == null) {
            ReaderNode.elementNode = new ElementNode();
        }
        try {
            elementNode = (ElementNode)ReaderNode.elementNode.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            elementNode = new ElementNode();
        }
        elementNode.init(ruby2, string2, string3, string4, xMLAttributes, n, stack, stack2);
        return elementNode;
    }

    public static TextNode createTextNode(Ruby ruby2, String string2, int n, Stack<String> stack, Stack<String> stack2) {
        TextNode textNode;
        if (ReaderNode.textNode == null) {
            ReaderNode.textNode = new TextNode();
        }
        try {
            textNode = (TextNode)ReaderNode.textNode.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            textNode = new TextNode();
        }
        textNode.init(ruby2, string2, n, stack, stack2);
        return textNode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextNode
    extends ReaderNode {
        public TextNode() {
        }

        public TextNode(Ruby ruby2, String string2, int n, Stack<String> stack, Stack<String> stack2) {
            this.init(ruby2, string2, n, stack, stack2);
        }

        public void init(Ruby ruby2, String string2, int n, Stack<String> stack, Stack<String> stack2) {
            this.ruby = ruby2;
            this.value = string2;
            this.localName = "#text";
            this.name = "#text";
            this.depth = n;
            this.nodeType = string2.trim().length() > 0 ? ReaderNodeType.TEXT.getValue() : ReaderNodeType.SIGNIFICANT_WHITESPACE.getValue();
            if (!stack.isEmpty()) {
                this.lang = stack.peek();
            }
            if (!stack2.isEmpty()) {
                this.xmlBase = stack2.peek();
            }
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getTrue();
        }

        @Override
        public String getString() {
            return this.value;
        }
    }

    public static class ExceptionNode
    extends EmptyNode {
        private final XmlSyntaxError exception;

        public ExceptionNode(Ruby ruby2, Exception exception2) {
            super(ruby2);
            this.exception = (XmlSyntaxError)NokogiriService.XML_SYNTAXERROR_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(this.ruby, "Nokogiri::XML::SyntaxError"));
        }

        public boolean isError() {
            return true;
        }

        public IRubyObject toSyntaxError() {
            return this.exception;
        }
    }

    public static class EmptyNode
    extends ReaderNode {
        public EmptyNode(Ruby ruby2) {
            this.ruby = ruby2;
            this.nodeType = ReaderNodeType.NODE.getValue();
        }

        public IRubyObject getXmlVersion() {
            return this.ruby.getNil();
        }

        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        public String getString() {
            return null;
        }
    }

    public static class ReaderAttributeList {
        List<String> namespaces = new ArrayList<String>();
        List<String> names = new ArrayList<String>();
        List<String> values = new ArrayList<String>();
        int length = 0;

        void add(String string2, String string3, String string4) {
            string2 = string2 != null ? string2 : "";
            this.namespaces.add(string2);
            string3 = string3 != null ? string3 : "";
            this.names.add(string3);
            string4 = string4 != null ? string4 : "";
            this.values.add(string4);
            ++this.length;
        }

        String getByName(String string2) {
            for (int j = 0; j < this.names.size(); ++j) {
                if (!string2.equals(this.names.get(j))) continue;
                return this.values.get(j);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ElementNode
    extends ReaderNode {
        private final List<String> attributeStrings = new ArrayList<String>();

        public ElementNode() {
        }

        public ElementNode(Ruby ruby2, String string2, String string3, String string4, XMLAttributes xMLAttributes, int n, Stack<String> stack, Stack<String> stack2) {
            this.init(ruby2, string2, string3, string4, xMLAttributes, n, stack, stack2);
        }

        public void init(Ruby ruby2, String string2, String string3, String string4, XMLAttributes xMLAttributes, int n, Stack<String> stack, Stack<String> stack2) {
            this.ruby = ruby2;
            this.nodeType = ReaderNodeType.ELEMENT.getValue();
            this.uri = "".equals(string2) ? null : string2;
            this.localName = string3.trim().length() > 0 ? string3 : string4;
            this.name = string4;
            this.parsePrefix(string4);
            this.depth = n;
            this.parseAttributes(xMLAttributes, stack, stack2);
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        private void parseAttributes(XMLAttributes xMLAttributes, Stack<String> stack, Stack<String> stack2) {
            if (xMLAttributes.getLength() > 0) {
                this.attributeList = new ReaderAttributeList();
            }
            for (int j = 0; j < xMLAttributes.getLength(); ++j) {
                String string2 = xMLAttributes.getURI(j);
                String string3 = xMLAttributes.getQName(j);
                String string4 = xMLAttributes.getValue(j);
                if (NokogiriHelpers.isNamespace(string3)) {
                    if (this.namespaces == null) {
                        this.namespaces = new HashMap();
                    }
                    this.namespaces.put(string3, string4);
                } else {
                    if (this.lang == null) {
                        this.lang = this.resolveLang(string3, string4, stack);
                    }
                    if (this.xmlBase == null) {
                        this.xmlBase = this.resolveXmlBase(string3, string4, stack2);
                    }
                }
                this.attributeList.add(string2, string3, string4);
                this.attributeStrings.add(string3 + "=\"" + string4 + "\"");
            }
        }

        private String resolveLang(String string2, String string3, Stack<String> stack) {
            if ("xml:lang".equals(string2)) {
                return string3;
            }
            if (!stack.isEmpty()) {
                return stack.peek();
            }
            return null;
        }

        private String resolveXmlBase(String string2, String string3, Stack<String> stack) {
            if (NokogiriHelpers.isXmlBase(string2)) {
                return this.getXmlBaseUri(string2, string3, stack);
            }
            if (!stack.isEmpty()) {
                return stack.peek();
            }
            return null;
        }

        private String getXmlBaseUri(String string2, String string3, Stack<String> stack) {
            if ("xml:base".equals(string2)) {
                if (string3.startsWith("http://")) {
                    return string3;
                }
                if (string3.startsWith("/") && string3.endsWith("/")) {
                    String string4 = string3.substring(1, string3.length() - 2);
                    String string5 = stack.peek();
                    if (string5.endsWith("/")) {
                        string5 = string5.substring(0, string5.length() - 1);
                    }
                    int n = string5.lastIndexOf("/");
                    return string5.substring(0, n).concat(string4);
                }
                String string6 = stack.peek();
                if (string6.endsWith("/")) {
                    return string6.concat(string3);
                }
                return string6.concat("/").concat(string3);
            }
            if ("xlink:href".equals(string2)) {
                if (string3.startsWith("http://")) {
                    return string3;
                }
                if (!stack.isEmpty()) {
                    String string7 = stack.peek();
                    return string7;
                }
            }
            return null;
        }

        @Override
        public String getString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<").append(this.name);
            if (this.attributeList != null) {
                for (int j = 0; j < this.attributeList.length; ++j) {
                    stringBuffer.append(" ").append(this.attributeStrings.get(j));
                }
            }
            if (this.hasChildren) {
                stringBuffer.append(">");
            } else {
                stringBuffer.append("/>");
            }
            return new String(stringBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClosingNode
    extends ReaderNode {
        public ClosingNode() {
        }

        public ClosingNode(Ruby ruby2, String string2, String string3, String string4, int n, Stack<String> stack, Stack<String> stack2) {
            this.init(ruby2, string2, string3, string4, n, stack, stack2);
        }

        public void init(Ruby ruby2, String string2, String string3, String string4, int n, Stack<String> stack, Stack<String> stack2) {
            this.ruby = ruby2;
            this.nodeType = ReaderNodeType.END_ELEMENT.getValue();
            this.uri = "".equals(string2) ? null : string2;
            this.localName = string3.trim().length() > 0 ? string3 : string4;
            this.name = string4;
            this.parsePrefix(string4);
            this.depth = n;
            if (!stack.isEmpty()) {
                this.lang = stack.peek();
            }
            if (!stack2.isEmpty()) {
                this.xmlBase = stack2.peek();
            }
        }

        @Override
        public IRubyObject getAttributeCount() {
            return this.ruby.newFixnum(0);
        }

        @Override
        public RubyBoolean hasValue() {
            return this.ruby.getFalse();
        }

        @Override
        public String getString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("</").append(this.name).append(">");
            return new String(stringBuffer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReaderNodeType {
        NODE(0),
        ELEMENT(1),
        ATTRIBUTE(2),
        TEXT(3),
        CDATA(4),
        ENTITY_REFERENCE(5),
        ENTITY(6),
        PROCESSING_INSTRUCTION(7),
        COMMENT(8),
        DOCUMENT(9),
        DOCUMENT_TYPE(10),
        DOCUMENTFRAGMENT(11),
        NOTATION(12),
        WHITESPACE(13),
        SIGNIFICANT_WHITESPACE(14),
        END_ELEMENT(15),
        END_ENTITY(16),
        XML_DECLARATION(17);

        private final int value;

        private ReaderNodeType(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

