/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.util.List;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import nokogiri.NokogiriService;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFloat;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.NodeList;

public class NokogiriXPathFunction
implements XPathFunction {
    private static NokogiriXPathFunction xpathFunction;
    private IRubyObject handler;
    private String name;
    private int arity;

    public static NokogiriXPathFunction create(IRubyObject iRubyObject, String string2, int n) {
        if (xpathFunction == null) {
            xpathFunction = new NokogiriXPathFunction();
        }
        try {
            NokogiriXPathFunction nokogiriXPathFunction = (NokogiriXPathFunction)xpathFunction.clone();
            nokogiriXPathFunction.init(iRubyObject, string2, n);
            return nokogiriXPathFunction;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            NokogiriXPathFunction nokogiriXPathFunction = new NokogiriXPathFunction();
            nokogiriXPathFunction.init(iRubyObject, string2, n);
            return nokogiriXPathFunction;
        }
    }

    private void init(IRubyObject iRubyObject, String string2, int n) {
        this.handler = iRubyObject;
        this.name = string2;
        this.arity = n;
    }

    private NokogiriXPathFunction() {
    }

    public Object evaluate(List list2) throws XPathFunctionException {
        if (list2.size() != this.arity) {
            throw new XPathFunctionException("arity does not match");
        }
        Ruby ruby2 = this.handler.getRuntime();
        ThreadContext threadContext = ruby2.getCurrentContext();
        IRubyObject iRubyObject = RuntimeHelpers.invoke(threadContext, this.handler, this.name, this.fromObjectToRubyArgs(list2));
        return this.fromRubyToObject(iRubyObject);
    }

    private IRubyObject[] fromObjectToRubyArgs(List list2) {
        IRubyObject[] iRubyObjectArray = new IRubyObject[list2.size()];
        for (int j = 0; j < list2.size(); ++j) {
            iRubyObjectArray[j] = this.fromObjectToRuby(list2.get(j));
        }
        return iRubyObjectArray;
    }

    private IRubyObject fromObjectToRuby(Object object) {
        Ruby ruby2 = this.handler.getRuntime();
        if (object instanceof NodeList) {
            XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::NodeSet"));
            xmlNodeSet.setNodeList((NodeList)object);
            return xmlNodeSet;
        }
        return JavaUtil.convertJavaToUsableRubyObject(ruby2, object);
    }

    private Object fromRubyToObject(IRubyObject iRubyObject) {
        Ruby ruby2 = this.handler.getRuntime();
        if (iRubyObject instanceof RubyString) {
            return iRubyObject.toJava(String.class);
        }
        if (iRubyObject instanceof RubyFloat) {
            return iRubyObject.toJava(Double.class);
        }
        if (iRubyObject instanceof RubyBoolean) {
            return iRubyObject.toJava(Boolean.class);
        }
        if (iRubyObject instanceof XmlNodeSet) {
            return (NodeList)((Object)iRubyObject);
        }
        if (iRubyObject instanceof RubyArray) {
            XmlNodeSet xmlNodeSet = XmlNodeSet.newXmlNodeSet(ruby2.getCurrentContext(), (RubyArray)iRubyObject);
            return xmlNodeSet;
        }
        return ((XmlNode)iRubyObject).getNode();
    }
}

