/*
 * Decompiled with CFR 0.152.
 */
package nokogiri.internals;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import nokogiri.internals.NokogiriErrorHandler;
import nokogiri.internals.ParserContext;
import org.jruby.Ruby;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class NokogiriEntityResolver
implements EntityResolver2 {
    protected Ruby runtime;
    private final NokogiriErrorHandler handler;
    private final ParserContext.Options options;

    public NokogiriEntityResolver(Ruby ruby2, NokogiriErrorHandler nokogiriErrorHandler, ParserContext.Options options2) {
        this.runtime = ruby2;
        this.handler = nokogiriErrorHandler;
        this.options = options2;
    }

    public InputSource getExternalSubset(String string2, String string3) throws SAXException, IOException {
        return null;
    }

    public InputSource resolveEntity(String string2, String string3) throws SAXException, IOException {
        return this.resolveEntity(this.runtime, null, string2, null, string3);
    }

    public InputSource resolveEntity(String string2, String string3, String string4, String string5) throws SAXException, IOException {
        return this.resolveEntity(this.runtime, string2, string3, string4, string5);
    }

    private File join(String string2, String string3) {
        if (new File(string2).isFile()) {
            string2 = new File(string2).getParent();
        }
        return new File(string2, string3);
    }

    private InputSource emptyInputSource(InputSource inputSource) {
        inputSource.setByteStream(new ByteArrayInputStream(new byte[0]));
        return inputSource;
    }

    private boolean shouldLoadDtd() {
        return this.options.dtdLoad || this.options.dtdValid;
    }

    private void addError(String string2) {
        if (this.handler != null) {
            this.handler.errors.add(new Exception(string2));
        }
    }

    protected InputSource resolveEntity(Ruby ruby2, String string2, String string3, String string4, String string5) throws IOException, SAXException {
        String string6;
        InputSource inputSource = new InputSource();
        if (string2.equals("[dtd]") && !this.shouldLoadDtd()) {
            return this.emptyInputSource(inputSource);
        }
        if (!string2.equals("[dtd]") && !this.options.noEnt) {
            return this.emptyInputSource(inputSource);
        }
        URI uRI = URI.create(string5);
        if (this.options.noNet && uRI.getHost() != null) {
            this.addError("Attempt to load network entity " + string5);
            return this.emptyInputSource(inputSource);
        }
        if (uRI.isAbsolute() && !uRI.isOpaque()) {
            string6 = uRI.toURL().toString();
        } else if (new File(uRI.getPath()).isAbsolute()) {
            string6 = uRI.getPath();
        } else if (string4 != null) {
            URI uRI2 = URI.create(string4);
            if (this.options.noNet && uRI2.getHost() != null) {
                this.addError("Attempt to load network entity " + string5);
                return this.emptyInputSource(inputSource);
            }
            string6 = uRI2.getHost() == null ? this.join(uRI2.getPath(), uRI.getPath()).getCanonicalPath() : uRI2.resolve(string5).toURL().toString();
        } else {
            String string7 = ruby2.getCurrentDirectory();
            string6 = this.join(string7, uRI.getPath()).getCanonicalPath();
        }
        inputSource.setSystemId(string6);
        inputSource.setPublicId(string3);
        return inputSource;
    }
}

