/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nokogiri.NokogiriService;
import nokogiri.XmlNode;
import nokogiri.XmlNodeSet;
import nokogiri.XmlSyntaxError;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.NokogiriNamespaceContext;
import nokogiri.internals.NokogiriXPathFunctionResolver;
import nokogiri.internals.NokogiriXPathVariableResolver;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::XPathContext"})
public class XmlXpathContext
extends RubyObject {
    private XmlNode context;
    private XPath xpath;
    private static Pattern boolean_pattern = Pattern.compile("true|false");

    public XmlXpathContext(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public void setNode(XmlNode xmlNode) {
        this.context = xmlNode;
        this.xpath.setNamespaceContext(NokogiriNamespaceContext.create());
        this.xpath.setXPathVariableResolver(NokogiriXPathVariableResolver.create());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject rbNew(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlNode xmlNode = (XmlNode)iRubyObject2;
        XmlXpathContext xmlXpathContext = (XmlXpathContext)NokogiriService.XML_XPATHCONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlXpathContext.xpath = XPathFactory.newInstance().newXPath();
        xmlXpathContext.setNode(xmlNode);
        return xmlXpathContext;
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string2 = (String)iRubyObject.toJava(String.class);
        try {
            Object object;
            if (!iRubyObject2.isNil()) {
                if (!this.isContainsPrefix(string2)) {
                    object = iRubyObject2.getMetaClass().getMethods().keySet();
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string3 = (String)iterator.next();
                        string2 = string2.replaceAll(string3, "nokogiri:" + string3);
                    }
                }
                this.xpath.setXPathFunctionResolver(NokogiriXPathFunctionResolver.create(iRubyObject2));
            }
            object = this.xpath.compile(string2);
            return this.node_set(threadContext, (XPathExpression)object);
        }
        catch (XPathExpressionException xPathExpressionException) {
            XPathExpressionException xPathExpressionException2 = new XPathExpressionException(string2);
            RubyException rubyException = XmlSyntaxError.createXPathSyntaxError(this.getRuntime(), xPathExpressionException2);
            throw new RaiseException(rubyException);
        }
    }

    protected IRubyObject node_set(ThreadContext threadContext, XPathExpression xPathExpression) {
        XmlNodeSet xmlNodeSet = null;
        try {
            xmlNodeSet = this.tryGetNodeSet(threadContext, xPathExpression);
            return xmlNodeSet;
        }
        catch (XPathExpressionException xPathExpressionException) {
            try {
                return this.tryGetOpaqueValue(xPathExpression);
            }
            catch (XPathExpressionException xPathExpressionException2) {
                RubyException rubyException = XmlSyntaxError.createXPathSyntaxError(this.getRuntime(), xPathExpressionException2);
                throw new RaiseException(rubyException);
            }
        }
    }

    private XmlNodeSet tryGetNodeSet(ThreadContext threadContext, XPathExpression xPathExpression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPathExpression.evaluate(this.context.node, XPathConstants.NODESET);
        XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(this.getRuntime(), NokogiriHelpers.getNokogiriClass(this.getRuntime(), "Nokogiri::XML::NodeSet"));
        xmlNodeSet.setNodeList(nodeList);
        xmlNodeSet.initialize(threadContext.getRuntime(), this.context);
        return xmlNodeSet;
    }

    private IRubyObject tryGetOpaqueValue(XPathExpression xPathExpression) throws XPathExpressionException {
        String string2 = (String)xPathExpression.evaluate(this.context.node, XPathConstants.STRING);
        Double d = null;
        d = this.getDoubleValue(string2);
        if (d != null) {
            return new RubyFloat(this.getRuntime(), d);
        }
        if (this.doesMatch(boolean_pattern, string2.toLowerCase())) {
            return RubyBoolean.newBoolean(this.getRuntime(), Boolean.parseBoolean(string2));
        }
        return RubyString.newString(this.getRuntime(), string2);
    }

    private Double getDoubleValue(String string2) {
        try {
            return Double.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private boolean doesMatch(Pattern pattern, String string2) {
        Matcher matcher = pattern.matcher(string2);
        return matcher.matches();
    }

    private boolean isContainsPrefix(String string2) {
        Set<String> set = ((NokogiriNamespaceContext)this.xpath.getNamespaceContext()).getAllPrefixes();
        for (String string3 : set) {
            if (!string2.contains(string3 + ":")) continue;
            return true;
        }
        return false;
    }

    @JRubyMethod
    public IRubyObject evaluate(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.evaluate(threadContext, iRubyObject, threadContext.getRuntime().getNil());
    }

    @JRubyMethod
    public IRubyObject register_ns(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ((NokogiriNamespaceContext)this.xpath.getNamespaceContext()).registerNamespace((String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class));
        return this;
    }

    @JRubyMethod
    public IRubyObject register_variable(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ((NokogiriXPathVariableResolver)this.xpath.getXPathVariableResolver()).registerVariable((String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class));
        return this;
    }
}

