/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.io.IOException;
import java.io.InputStream;
import nokogiri.NokogiriService;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHandler;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.ParserContext;
import nokogiri.internals.XmlSaxParser;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObjectAdapter;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

@JRubyClass(name={"Nokogiri::XML::SAX::ParserContext"})
public class XmlSaxParserContext
extends ParserContext {
    protected static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String FEATURE_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected AbstractSAXParser parser;
    protected NokogiriHandler handler = null;
    private IRubyObject replaceEntities;

    public XmlSaxParserContext(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    protected void initialize(Ruby ruby2) {
        this.replaceEntities = ruby2.getTrue();
        try {
            this.parser = this.createParser();
        }
        catch (SAXException sAXException) {
            throw RaiseException.createNativeRaiseException(ruby2, sAXException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected AbstractSAXParser createParser() throws SAXException {
        XmlSaxParser xmlSaxParser = new XmlSaxParser();
        xmlSaxParser.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
        xmlSaxParser.setFeature(FEATURE_LOAD_EXTERNAL_DTD, false);
        return xmlSaxParser;
    }

    @JRubyMethod(name={"memory"}, meta=true)
    public static IRubyObject parse_memory(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlSaxParserContext xmlSaxParserContext = (XmlSaxParserContext)NokogiriService.XML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlSaxParserContext.initialize(threadContext.getRuntime());
        xmlSaxParserContext.setInputSource(threadContext, iRubyObject2, threadContext.getRuntime().getNil());
        return xmlSaxParserContext;
    }

    @JRubyMethod(name={"file"}, meta=true)
    public static IRubyObject parse_file(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        XmlSaxParserContext xmlSaxParserContext = (XmlSaxParserContext)NokogiriService.XML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlSaxParserContext.initialize(threadContext.getRuntime());
        xmlSaxParserContext.setInputSourceFile(threadContext, iRubyObject2);
        return xmlSaxParserContext;
    }

    @JRubyMethod(name={"io"}, meta=true)
    public static IRubyObject parse_io(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        XmlSaxParserContext xmlSaxParserContext = (XmlSaxParserContext)NokogiriService.XML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlSaxParserContext.initialize(threadContext.getRuntime());
        xmlSaxParserContext.setInputSource(threadContext, iRubyObject2, threadContext.getRuntime().getNil());
        return xmlSaxParserContext;
    }

    public static IRubyObject parse_stream(ThreadContext threadContext, IRubyObject iRubyObject, InputStream inputStream) {
        XmlSaxParserContext xmlSaxParserContext = (XmlSaxParserContext)NokogiriService.XML_SAXPARSER_CONTEXT_ALLOCATOR.allocate(threadContext.getRuntime(), (RubyClass)iRubyObject);
        xmlSaxParserContext.initialize(threadContext.getRuntime());
        xmlSaxParserContext.setInputSource(inputStream);
        return xmlSaxParserContext;
    }

    protected void setProperty(String string2, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setProperty(string2, object);
    }

    protected void setContentHandler(ContentHandler contentHandler) {
        this.parser.setContentHandler(contentHandler);
    }

    protected void setErrorHandler(ErrorHandler errorHandler) {
        this.parser.setErrorHandler(errorHandler);
    }

    public NokogiriHandler getNokogiriHandler() {
        return this.handler;
    }

    protected void preParse(ThreadContext threadContext, IRubyObject iRubyObject, NokogiriHandler nokogiriHandler) {
        ((XmlSaxParser)this.parser).setXmlDeclHandler(nokogiriHandler);
    }

    protected void postParse(ThreadContext threadContext, IRubyObject iRubyObject, NokogiriHandler nokogiriHandler) {
    }

    protected void do_parse() throws SAXException, IOException {
        this.parser.parse(this.getInputSource());
    }

    @JRubyMethod
    public IRubyObject parse_with(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby2 = threadContext.getRuntime();
        if (!RuntimeHelpers.invoke(threadContext, iRubyObject, "respond_to?", (IRubyObject)ruby2.newSymbol("document")).isTrue()) {
            String string2 = "argument must respond_to document";
            throw ruby2.newArgumentError(string2);
        }
        this.handler = new NokogiriHandler(ruby2, iRubyObject);
        this.preParse(threadContext, iRubyObject, this.handler);
        this.setContentHandler(this.handler);
        this.setErrorHandler(this.handler);
        try {
            this.setProperty("http://xml.org/sax/properties/lexical-handler", this.handler);
        }
        catch (Exception exception2) {
            throw ruby2.newRuntimeError("Problem while creating XML SAX Parser: " + exception2.toString());
        }
        try {
            try {
                this.do_parse();
            }
            catch (SAXParseException sAXParseException) {
                String string3 = sAXParseException.getMessage();
                if ("Premature end of file.".matches(string3) && this.stringDataSize < 1) {
                    throw ruby2.newRuntimeError("couldn't parse document: " + string3);
                }
                this.handler.error(sAXParseException);
            }
        }
        catch (SAXException sAXException) {
            throw RaiseException.createNativeRaiseException(ruby2, sAXException);
        }
        catch (IOException iOException) {
            throw ruby2.newIOErrorFromException(iOException);
        }
        this.postParse(threadContext, iRubyObject, this.handler);
        return ruby2.getNil();
    }

    @JRubyMethod(name={"replace_entities="})
    public IRubyObject set_replace_entities(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.replaceEntities = !iRubyObject.isTrue() ? threadContext.getRuntime().getFalse() : threadContext.getRuntime().getTrue();
        return this;
    }

    @JRubyMethod(name={"replace_entities"})
    public IRubyObject get_replace_entities(ThreadContext threadContext) {
        return this.replaceEntities;
    }

    protected void maybeTrimLeadingAndTrailingWhitespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        IRubyObject iRubyObject2;
        IRubyObject iRubyObject3;
        RubyObjectAdapter rubyObjectAdapter = JavaEmbedUtils.newObjectAdapter();
        RubyModule rubyModule = threadContext.getRuntime().getClassFromPath("Nokogiri::XML::FragmentHandler");
        IRubyObject iRubyObject4 = rubyObjectAdapter.getInstanceVariable(iRubyObject, "@document");
        if (iRubyObject4 == null || iRubyObject4.isNil() || !rubyObjectAdapter.isKindOf(iRubyObject4, rubyModule)) {
            return;
        }
        IRubyObject iRubyObject5 = rubyObjectAdapter.getInstanceVariable(iRubyObject4, "@stack");
        if (iRubyObject5 == null || iRubyObject5.isNil()) {
            return;
        }
        IRubyObject iRubyObject6 = rubyObjectAdapter.callMethod(iRubyObject5, "first");
        if (iRubyObject6 == null || iRubyObject6.isNil()) {
            return;
        }
        while (NokogiriHelpers.isWhitespaceText(threadContext, iRubyObject3 = rubyObjectAdapter.callMethod(iRubyObject2 = rubyObjectAdapter.callMethod(iRubyObject6, "children"), "first"))) {
            rubyObjectAdapter.callMethod(iRubyObject3, "unlink");
        }
        while (NokogiriHelpers.isWhitespaceText(threadContext, iRubyObject3 = rubyObjectAdapter.callMethod(iRubyObject2 = rubyObjectAdapter.callMethod(iRubyObject6, "children"), "last"))) {
            rubyObjectAdapter.callMethod(iRubyObject3, "unlink");
        }
        ((XmlNode)iRubyObject6).normalize();
    }

    @JRubyMethod(name={"column"})
    public IRubyObject column(ThreadContext threadContext) {
        Integer n = this.handler.getColumn();
        if (n == null) {
            return threadContext.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(threadContext.getRuntime(), n.longValue());
    }

    @JRubyMethod(name={"line"})
    public IRubyObject line(ThreadContext threadContext) {
        Integer n = this.handler.getLine();
        if (n == null) {
            return threadContext.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(threadContext.getRuntime(), n.longValue());
    }
}

