/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import nokogiri.NokogiriService;
import nokogiri.XmlDocument;
import nokogiri.internals.NokogiriHelpers;
import nokogiri.internals.SaveContextVisitor;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@JRubyClass(name={"Nokogiri::XML::Namespace"})
public class XmlNamespace
extends RubyObject {
    private Attr attr;
    private IRubyObject prefix;
    private IRubyObject href;
    private String prefixString;
    private String hrefString;

    public XmlNamespace(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    public Node getNode() {
        return this.attr;
    }

    public String getPrefix() {
        return this.prefixString;
    }

    public String getHref() {
        return this.hrefString;
    }

    void deleteHref() {
        this.hrefString = "http://www.w3.org/XML/1998/namespace";
        this.href = NokogiriHelpers.stringOrNil(this.getRuntime(), this.hrefString);
        this.attr.getOwnerElement().removeAttributeNode(this.attr);
    }

    public void init(Attr attr2, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        this.init(attr2, iRubyObject, iRubyObject2, (String)iRubyObject.toJava(String.class), (String)iRubyObject2.toJava(String.class), iRubyObject3);
    }

    public void init(Attr attr2, IRubyObject iRubyObject, IRubyObject iRubyObject2, String string2, String string3, IRubyObject iRubyObject3) {
        this.attr = attr2;
        this.prefix = iRubyObject;
        this.href = iRubyObject2;
        this.prefixString = string2;
        this.hrefString = string3;
        this.setInstanceVariable("@document", iRubyObject3);
    }

    public static XmlNamespace createFromAttr(Ruby ruby2, Attr attr2) {
        IRubyObject iRubyObject;
        String string2 = NokogiriHelpers.getLocalNameForNamespace(attr2.getName());
        if (string2 == null) {
            iRubyObject = ruby2.getNil();
            string2 = "";
        } else {
            iRubyObject = RubyString.newString(ruby2, string2);
        }
        String string3 = attr2.getValue();
        RubyString rubyString = RubyString.newString(ruby2, string3);
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby2, attr2.getOwnerDocument());
        xmlDocument.initializeNamespaceCacheIfNecessary();
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string2, string3);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Namespace"));
        xmlNamespace2.init(attr2, iRubyObject, rubyString, string2, string3, xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, attr2.getOwnerElement());
        return xmlNamespace2;
    }

    public static XmlNamespace createFromPrefixAndHref(Node node, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        String string2 = iRubyObject.isNil() ? "" : (String)iRubyObject.toJava(String.class);
        String string3 = (String)iRubyObject2.toJava(String.class);
        Ruby ruby2 = iRubyObject.getRuntime();
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby2, document);
        xmlDocument.initializeNamespaceCacheIfNecessary();
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string2, string3);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Namespace"));
        String string4 = "xmlns";
        if (!"".equals(string2)) {
            string4 = string4 + ":" + string2;
        }
        Attr attr2 = document.createAttribute(string4);
        attr2.setNodeValue(string3);
        xmlNamespace2.init(attr2, iRubyObject, iRubyObject2, string2, string3, xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, node);
        return xmlNamespace2;
    }

    public static XmlNamespace createDefaultNamespace(Ruby ruby2, Node node) {
        String string2 = node.getPrefix();
        String string3 = node.getNamespaceURI();
        Document document = node.getOwnerDocument();
        XmlDocument xmlDocument = (XmlDocument)NokogiriHelpers.getCachedNodeOrCreate(ruby2, document);
        XmlNamespace xmlNamespace = xmlDocument.getNamespaceCache().get(string2, string3);
        if (xmlNamespace != null) {
            return xmlNamespace;
        }
        XmlNamespace xmlNamespace2 = (XmlNamespace)NokogiriService.XML_NAMESPACE_ALLOCATOR.allocate(ruby2, NokogiriHelpers.getNokogiriClass(ruby2, "Nokogiri::XML::Namespace"));
        IRubyObject iRubyObject = NokogiriHelpers.stringOrNil(ruby2, string2);
        IRubyObject iRubyObject2 = NokogiriHelpers.stringOrNil(ruby2, string3);
        xmlNamespace2.init((Attr)node, iRubyObject, iRubyObject2, string2, string3, xmlDocument);
        xmlDocument.getNamespaceCache().put(xmlNamespace2, node);
        return xmlNamespace2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isEmpty() {
        return this.prefix.isNil() && this.href.isNil();
    }

    @JRubyMethod
    public IRubyObject href(ThreadContext threadContext) {
        return this.href;
    }

    @JRubyMethod
    public IRubyObject prefix(ThreadContext threadContext) {
        return this.prefix;
    }

    public void accept(ThreadContext threadContext, SaveContextVisitor saveContextVisitor) {
        String string2 = " " + this.prefix + "=\"" + this.href + "\"";
        saveContextVisitor.enter(string2);
        saveContextVisitor.leave(string2);
    }
}

