/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import java.lang.ref.WeakReference;
import json.ext.Generator;
import json.ext.RuntimeInfo;
import json.ext.Utils;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

class GeneratorMethods {
    GeneratorMethods() {
    }

    static void populate(RuntimeInfo runtimeInfo, RubyModule rubyModule) {
        GeneratorMethods.defineMethods(rubyModule, "Array", RbArray.class);
        GeneratorMethods.defineMethods(rubyModule, "FalseClass", RbFalse.class);
        GeneratorMethods.defineMethods(rubyModule, "Float", RbFloat.class);
        GeneratorMethods.defineMethods(rubyModule, "Hash", RbHash.class);
        GeneratorMethods.defineMethods(rubyModule, "Integer", RbInteger.class);
        GeneratorMethods.defineMethods(rubyModule, "NilClass", RbNil.class);
        GeneratorMethods.defineMethods(rubyModule, "Object", RbObject.class);
        GeneratorMethods.defineMethods(rubyModule, "String", RbString.class);
        GeneratorMethods.defineMethods(rubyModule, "TrueClass", RbTrue.class);
        runtimeInfo.stringExtendModule = new WeakReference<RubyModule>(rubyModule.defineModuleUnder("String").defineModuleUnder("Extend"));
        ((RubyModule)runtimeInfo.stringExtendModule.get()).defineAnnotatedMethods(StringExtend.class);
    }

    private static void defineMethods(RubyModule rubyModule, String string2, Class clazz) {
        RubyModule rubyModule2 = rubyModule.defineModuleUnder(string2);
        rubyModule2.defineAnnotatedMethods(clazz);
    }

    public static class RbObject {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RbString.to_json(threadContext, iRubyObject.asString(), iRubyObjectArray);
        }
    }

    public static class RbNil {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, iRubyObject, Generator.NIL_HANDLER, iRubyObjectArray);
        }
    }

    public static class RbFalse {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.FALSE_HANDLER, iRubyObjectArray);
        }
    }

    public static class RbTrue {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyBoolean)iRubyObject, Generator.TRUE_HANDLER, iRubyObjectArray);
        }
    }

    public static class StringExtend {
        @JRubyMethod(required=1)
        public static IRubyObject json_create(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            Ruby ruby2 = threadContext.getRuntime();
            RubyHash rubyHash = iRubyObject2.convertToHash();
            IRubyObject iRubyObject3 = rubyHash.fastARef(ruby2.newString("raw"));
            if (iRubyObject3 == null) {
                throw ruby2.newArgumentError("\"raw\" value not defined for encoded String");
            }
            RubyArray rubyArray = Utils.ensureArray(iRubyObject3);
            byte[] byArray = new byte[rubyArray.getLength()];
            int n = rubyArray.getLength();
            for (int j = 0; j < n; ++j) {
                IRubyObject iRubyObject4 = rubyArray.eltInternal(j);
                if (!(iRubyObject4 instanceof RubyFixnum)) {
                    throw ruby2.newTypeError(iRubyObject4, ruby2.getFixnum());
                }
                byArray[j] = (byte)RubyNumeric.fix2long(iRubyObject4);
            }
            return ruby2.newString(new ByteList(byArray, false));
        }
    }

    public static class RbString {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyString)iRubyObject, Generator.STRING_HANDLER, iRubyObjectArray);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject to_json_raw(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            RubyHash rubyHash = RbString.toJsonRawObject(threadContext, Utils.ensureString(iRubyObject));
            return Generator.generateJson(threadContext, rubyHash, Generator.HASH_HANDLER, iRubyObjectArray);
        }

        @JRubyMethod(rest=true)
        public static IRubyObject to_json_raw_object(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return RbString.toJsonRawObject(threadContext, Utils.ensureString(iRubyObject));
        }

        private static RubyHash toJsonRawObject(ThreadContext threadContext, RubyString rubyString) {
            Ruby ruby2 = threadContext.getRuntime();
            RubyHash rubyHash = RubyHash.newHash(ruby2);
            IRubyObject iRubyObject = ((RubyModule)RuntimeInfo.forRuntime((Ruby)ruby2).jsonModule.get()).callMethod(threadContext, "create_id");
            rubyHash.op_aset(threadContext, iRubyObject, rubyString.getMetaClass().to_s());
            ByteList byteList = rubyString.getByteList();
            byte[] byArray = byteList.unsafeBytes();
            RubyArray rubyArray = ruby2.newArray(byteList.length());
            int n = byteList.begin() + byteList.length();
            for (int j = byteList.begin(); j < n; ++j) {
                rubyArray.store(j, ruby2.newFixnum(byArray[j] & 0xFF));
            }
            rubyHash.op_aset(threadContext, ruby2.newString("raw"), rubyArray);
            return rubyHash;
        }

        @JRubyMethod(required=1, module=true)
        public static IRubyObject included(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            RuntimeInfo runtimeInfo = RuntimeInfo.forRuntime(threadContext.getRuntime());
            return iRubyObject2.callMethod(threadContext, "extend", (IRubyObject)runtimeInfo.stringExtendModule.get());
        }
    }

    public static class RbFloat {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyFloat)iRubyObject, Generator.FLOAT_HANDLER, iRubyObjectArray);
        }
    }

    public static class RbInteger {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, iRubyObject, iRubyObjectArray);
        }
    }

    public static class RbArray {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyArray)iRubyObject, Generator.ARRAY_HANDLER, iRubyObjectArray);
        }
    }

    public static class RbHash {
        @JRubyMethod(rest=true)
        public static IRubyObject to_json(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject[] iRubyObjectArray) {
            return Generator.generateJson(threadContext, (RubyHash)iRubyObject, Generator.HASH_HANDLER, iRubyObjectArray);
        }
    }
}

