/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.io.InvalidClassException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javassist.util.proxy.SecurityActions;
import javassist.util.proxy.SerializedProxy;

public class RuntimeSupport {
    public static MethodHandler default_interceptor = new DefaultMethodHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void find2Methods(Object self, String superMethod, String thisMethod, int index2, String desc, Method[] methods2) {
        Method[] methodArray = methods2;
        synchronized (methods2) {
            if (methods2[index2] == null) {
                methods2[index2 + 1] = thisMethod == null ? null : RuntimeSupport.findMethod(self, thisMethod, desc);
                methods2[index2] = RuntimeSupport.findSuperMethod(self, superMethod, desc);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public static Method findMethod(Object self, String name2, String desc) {
        Method m = RuntimeSupport.findMethod2(self.getClass(), name2, desc);
        if (m == null) {
            RuntimeSupport.error(self, name2, desc);
        }
        return m;
    }

    public static Method findSuperMethod(Object self, String name2, String desc) {
        Class<?> clazz = self.getClass();
        Method m = RuntimeSupport.findSuperMethod2(clazz.getSuperclass(), name2, desc);
        if (m == null) {
            m = RuntimeSupport.searchInterfaces(clazz, name2, desc);
        }
        if (m == null) {
            RuntimeSupport.error(self, name2, desc);
        }
        return m;
    }

    private static void error(Object self, String name2, String desc) {
        throw new RuntimeException("not found " + name2 + ":" + desc + " in " + self.getClass().getName());
    }

    private static Method findSuperMethod2(Class clazz, String name2, String desc) {
        Method m = RuntimeSupport.findMethod2(clazz, name2, desc);
        if (m != null) {
            return m;
        }
        Class superClass = clazz.getSuperclass();
        if (superClass != null && (m = RuntimeSupport.findSuperMethod2(superClass, name2, desc)) != null) {
            return m;
        }
        return RuntimeSupport.searchInterfaces(clazz, name2, desc);
    }

    private static Method searchInterfaces(Class clazz, String name2, String desc) {
        Method m = null;
        Class<?>[] interfaces2 = clazz.getInterfaces();
        for (int i2 = 0; i2 < interfaces2.length; ++i2) {
            m = RuntimeSupport.findSuperMethod2(interfaces2[i2], name2, desc);
            if (m == null) continue;
            return m;
        }
        return m;
    }

    private static Method findMethod2(Class clazz, String name2, String desc) {
        Method[] methods2 = SecurityActions.getDeclaredMethods(clazz);
        int n = methods2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            if (!methods2[i2].getName().equals(name2) || !RuntimeSupport.makeDescriptor(methods2[i2]).equals(desc)) continue;
            return methods2[i2];
        }
        return null;
    }

    public static String makeDescriptor(Method m) {
        Class[] params2 = m.getParameterTypes();
        return RuntimeSupport.makeDescriptor(params2, m.getReturnType());
    }

    public static String makeDescriptor(Class[] params2, Class retType) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append('(');
        for (int i2 = 0; i2 < params2.length; ++i2) {
            RuntimeSupport.makeDesc(sbuf, params2[i2]);
        }
        sbuf.append(')');
        RuntimeSupport.makeDesc(sbuf, retType);
        return sbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void makeDesc(StringBuffer sbuf, Class type2) {
        if (type2.isArray()) {
            sbuf.append('[');
            RuntimeSupport.makeDesc(sbuf, type2.getComponentType());
            return;
        } else if (type2.isPrimitive()) {
            if (type2 == Void.TYPE) {
                sbuf.append('V');
                return;
            } else if (type2 == Integer.TYPE) {
                sbuf.append('I');
                return;
            } else if (type2 == Byte.TYPE) {
                sbuf.append('B');
                return;
            } else if (type2 == Long.TYPE) {
                sbuf.append('J');
                return;
            } else if (type2 == Double.TYPE) {
                sbuf.append('D');
                return;
            } else if (type2 == Float.TYPE) {
                sbuf.append('F');
                return;
            } else if (type2 == Character.TYPE) {
                sbuf.append('C');
                return;
            } else if (type2 == Short.TYPE) {
                sbuf.append('S');
                return;
            } else {
                if (type2 != Boolean.TYPE) throw new RuntimeException("bad type: " + type2.getName());
                sbuf.append('Z');
            }
            return;
        } else {
            sbuf.append('L').append(type2.getName().replace('.', '/')).append(';');
        }
    }

    public static SerializedProxy makeSerializedProxy(Object proxy2) throws InvalidClassException {
        Class<?> clazz = proxy2.getClass();
        MethodHandler methodHandler = null;
        if (proxy2 instanceof ProxyObject) {
            methodHandler = ((ProxyObject)proxy2).getHandler();
        }
        return new SerializedProxy(clazz, ProxyFactory.getFilterSignature(clazz), methodHandler);
    }

    static class DefaultMethodHandler
    implements MethodHandler,
    Serializable {
        DefaultMethodHandler() {
        }

        public Object invoke(Object self, Method m, Method proceed, Object[] args2) throws Exception {
            return proceed.invoke(self, args2);
        }
    }
}

