/*
 * Decompiled with CFR 0.152.
 */
package javassist.util.proxy;

import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionsAttribute;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMapTable;
import javassist.util.proxy.FactoryHelper;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import javassist.util.proxy.RuntimeSupport;
import javassist.util.proxy.SecurityActions;

public class ProxyFactory {
    private Class superClass = null;
    private Class[] interfaces = null;
    private MethodFilter methodFilter = null;
    private MethodHandler handler = null;
    private List signatureMethods = null;
    private byte[] signature = null;
    private String classname;
    private String basename;
    private String superName;
    private Class thisClass = null;
    private boolean factoryUseCache = useCache;
    private boolean factoryWriteReplace = useWriteReplace;
    public String writeDirectory = null;
    private static final Class OBJECT_TYPE = Object.class;
    private static final String HOLDER = "_methods_";
    private static final String HOLDER_TYPE = "[Ljava/lang/reflect/Method;";
    private static final String FILTER_SIGNATURE_FIELD = "_filter_signature";
    private static final String FILTER_SIGNATURE_TYPE = "[B";
    private static final String HANDLER = "handler";
    private static final String NULL_INTERCEPTOR_HOLDER = "javassist.util.proxy.RuntimeSupport";
    private static final String DEFAULT_INTERCEPTOR = "default_interceptor";
    private static final String HANDLER_TYPE = 'L' + MethodHandler.class.getName().replace('.', '/') + ';';
    private static final String HANDLER_SETTER = "setHandler";
    private static final String HANDLER_SETTER_TYPE = "(" + HANDLER_TYPE + ")V";
    private static final String HANDLER_GETTER = "getHandler";
    private static final String HANDLER_GETTER_TYPE = "()" + HANDLER_TYPE;
    private static final String SERIAL_VERSION_UID_FIELD = "serialVersionUID";
    private static final String SERIAL_VERSION_UID_TYPE = "J";
    private static final int SERIAL_VERSION_UID_VALUE = -1;
    public static volatile boolean useCache = true;
    public static volatile boolean useWriteReplace = true;
    private static WeakHashMap proxyCache = new WeakHashMap();
    private static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static ClassLoaderProvider classLoaderProvider = new ClassLoaderProvider(){

        public ClassLoader get(ProxyFactory pf) {
            return pf.getClassLoader0();
        }
    };
    private static int counter = 0;
    private static Comparator sorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            Map.Entry e1 = (Map.Entry)o1;
            Map.Entry e2 = (Map.Entry)o2;
            String key1 = (String)e1.getKey();
            String key2 = (String)e2.getKey();
            return key1.compareTo(key2);
        }
    };

    public boolean isUseCache() {
        return this.factoryUseCache;
    }

    public void setUseCache(boolean useCache) {
        if (this.handler != null && useCache) {
            throw new RuntimeException("caching cannot be enabled if the factory default interceptor has been set");
        }
        this.factoryUseCache = useCache;
    }

    public boolean isUseWriteReplace() {
        return this.factoryWriteReplace;
    }

    public void setUseWriteReplace(boolean useWriteReplace) {
        this.factoryWriteReplace = useWriteReplace;
    }

    public static boolean isProxyClass(Class cl) {
        return ProxyObject.class.isAssignableFrom(cl);
    }

    public void setSuperclass(Class clazz) {
        this.superClass = clazz;
        this.signature = null;
    }

    public Class getSuperclass() {
        return this.superClass;
    }

    public void setInterfaces(Class[] ifs) {
        this.interfaces = ifs;
        this.signature = null;
    }

    public Class[] getInterfaces() {
        return this.interfaces;
    }

    public void setFilter(MethodFilter mf) {
        this.methodFilter = mf;
        this.signature = null;
    }

    public Class createClass() {
        if (this.signature == null) {
            this.computeSignature(this.methodFilter);
        }
        return this.createClass1();
    }

    public Class createClass(MethodFilter filter) {
        this.computeSignature(filter);
        return this.createClass1();
    }

    Class createClass(byte[] signature) {
        this.installSignature(signature);
        return this.createClass1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class createClass1() {
        if (this.thisClass == null) {
            ClassLoader cl = this.getClassLoader();
            WeakHashMap weakHashMap = proxyCache;
            synchronized (weakHashMap) {
                if (this.factoryUseCache) {
                    this.createClass2(cl);
                } else {
                    this.createClass3(cl);
                }
            }
        }
        Class result2 = this.thisClass;
        this.thisClass = null;
        return result2;
    }

    public String getKey(Class superClass, Class[] interfaces2, byte[] signature, boolean useWriteReplace) {
        int i2;
        StringBuffer sbuf = new StringBuffer();
        if (superClass != null) {
            sbuf.append(superClass.getName());
        }
        sbuf.append(":");
        for (i2 = 0; i2 < interfaces2.length; ++i2) {
            sbuf.append(interfaces2[i2].getName());
            sbuf.append(":");
        }
        for (i2 = 0; i2 < signature.length; ++i2) {
            byte b = signature[i2];
            int lo = b & 0xF;
            int hi = b >> 4 & 0xF;
            sbuf.append(hexDigits[lo]);
            sbuf.append(hexDigits[hi]);
        }
        if (useWriteReplace) {
            sbuf.append(":w");
        }
        return sbuf.toString();
    }

    private void createClass2(ClassLoader cl) {
        ProxyDetails details;
        String key2 = this.getKey(this.superClass, this.interfaces, this.signature, this.factoryWriteReplace);
        HashMap<String, ProxyDetails> cacheForTheLoader = (HashMap<String, ProxyDetails>)proxyCache.get(cl);
        if (cacheForTheLoader == null) {
            cacheForTheLoader = new HashMap<String, ProxyDetails>();
            proxyCache.put(cl, cacheForTheLoader);
        }
        if ((details = (ProxyDetails)cacheForTheLoader.get(key2)) != null) {
            WeakReference reference2 = details.proxyClass;
            this.thisClass = (Class)reference2.get();
            if (this.thisClass != null) {
                return;
            }
        }
        this.createClass3(cl);
        details = new ProxyDetails(this.signature, this.thisClass, this.factoryWriteReplace);
        cacheForTheLoader.put(key2, details);
    }

    private void createClass3(ClassLoader cl) {
        this.allocateClassName();
        try {
            ClassFile cf = this.make();
            if (this.writeDirectory != null) {
                FactoryHelper.writeFile(cf, this.writeDirectory);
            }
            this.thisClass = FactoryHelper.toClass(cf, cl, this.getDomain());
            this.setField(FILTER_SIGNATURE_FIELD, this.signature);
            if (!this.factoryUseCache) {
                this.setField(DEFAULT_INTERCEPTOR, this.handler);
            }
        }
        catch (CannotCompileException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void setField(String fieldName, Object value2) {
        if (this.thisClass != null && value2 != null) {
            try {
                Field f = this.thisClass.getField(fieldName);
                SecurityActions.setAccessible(f, true);
                f.set(null, value2);
                SecurityActions.setAccessible(f, false);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static byte[] getFilterSignature(Class clazz) {
        return (byte[])ProxyFactory.getField(clazz, FILTER_SIGNATURE_FIELD);
    }

    private static Object getField(Class clazz, String fieldName) {
        try {
            Field f = clazz.getField(fieldName);
            f.setAccessible(true);
            Object value2 = f.get(null);
            f.setAccessible(false);
            return value2;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassLoader getClassLoader() {
        return classLoaderProvider.get(this);
    }

    protected ClassLoader getClassLoader0() {
        ClassLoader loader = null;
        if (this.superClass != null && !this.superClass.getName().equals("java.lang.Object")) {
            loader = this.superClass.getClassLoader();
        } else if (this.interfaces != null && this.interfaces.length > 0) {
            loader = this.interfaces[0].getClassLoader();
        }
        if (loader == null && (loader = this.getClass().getClassLoader()) == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    protected ProtectionDomain getDomain() {
        Class clazz = this.superClass != null && !this.superClass.getName().equals("java.lang.Object") ? this.superClass : (this.interfaces != null && this.interfaces.length > 0 ? this.interfaces[0] : this.getClass());
        return clazz.getProtectionDomain();
    }

    public Object create(Class[] paramTypes, Object[] args2, MethodHandler mh) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Object obj = this.create(paramTypes, args2);
        ((ProxyObject)obj).setHandler(mh);
        return obj;
    }

    public Object create(Class[] paramTypes, Object[] args2) throws NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class c = this.createClass();
        Constructor cons = c.getConstructor(paramTypes);
        return cons.newInstance(args2);
    }

    public void setHandler(MethodHandler mi) {
        if (this.factoryUseCache && mi != null) {
            this.factoryUseCache = false;
            this.thisClass = null;
        }
        this.handler = mi;
        this.setField(DEFAULT_INTERCEPTOR, this.handler);
    }

    private static synchronized String makeProxyName(String classname) {
        return classname + "_$$_javassist_" + counter++;
    }

    private ClassFile make() throws CannotCompileException {
        ClassFile cf = new ClassFile(false, this.classname, this.superName);
        cf.setAccessFlags(1);
        ProxyFactory.setInterfaces(cf, this.interfaces);
        ConstPool pool = cf.getConstPool();
        if (!this.factoryUseCache) {
            FieldInfo finfo = new FieldInfo(pool, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            finfo.setAccessFlags(9);
            cf.addField(finfo);
        }
        FieldInfo finfo2 = new FieldInfo(pool, HANDLER, HANDLER_TYPE);
        finfo2.setAccessFlags(2);
        cf.addField(finfo2);
        FieldInfo finfo3 = new FieldInfo(pool, FILTER_SIGNATURE_FIELD, FILTER_SIGNATURE_TYPE);
        finfo3.setAccessFlags(9);
        cf.addField(finfo3);
        FieldInfo finfo4 = new FieldInfo(pool, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        finfo4.setAccessFlags(25);
        cf.addField(finfo4);
        this.makeConstructors(this.classname, cf, pool, this.classname);
        int s2 = this.overrideMethods(cf, pool, this.classname);
        ProxyFactory.addMethodsHolder(cf, pool, this.classname, s2);
        ProxyFactory.addSetter(this.classname, cf, pool);
        ProxyFactory.addGetter(this.classname, cf, pool);
        if (this.factoryWriteReplace) {
            try {
                cf.addMethod(ProxyFactory.makeWriteReplace(pool));
            }
            catch (DuplicateMemberException e) {
                // empty catch block
            }
        }
        this.thisClass = null;
        return cf;
    }

    private void checkClassAndSuperName() {
        if (this.interfaces == null) {
            this.interfaces = new Class[0];
        }
        if (this.superClass == null) {
            this.superClass = OBJECT_TYPE;
            this.superName = this.superClass.getName();
            this.basename = this.interfaces.length == 0 ? this.superName : this.interfaces[0].getName();
        } else {
            this.basename = this.superName = this.superClass.getName();
        }
        if (Modifier.isFinal(this.superClass.getModifiers())) {
            throw new RuntimeException(this.superName + " is final");
        }
        if (this.basename.startsWith("java.")) {
            this.basename = "org.javassist.tmp." + this.basename;
        }
    }

    private void allocateClassName() {
        this.classname = ProxyFactory.makeProxyName(this.basename);
    }

    private void makeSortedMethodList() {
        this.checkClassAndSuperName();
        HashMap allMethods = ProxyFactory.getMethods(this.superClass, this.interfaces);
        this.signatureMethods = new ArrayList(allMethods.entrySet());
        Collections.sort(this.signatureMethods, sorter);
    }

    private void computeSignature(MethodFilter filter) {
        this.makeSortedMethodList();
        int l = this.signatureMethods.size();
        int maxBytes = l + 7 >> 3;
        this.signature = new byte[maxBytes];
        for (int idx = 0; idx < l; ++idx) {
            Map.Entry e = (Map.Entry)this.signatureMethods.get(idx);
            Method m = (Method)e.getValue();
            int mod = m.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isStatic(mod) || !ProxyFactory.isVisible(mod, this.basename, m) || filter != null && !filter.isHandled(m)) continue;
            this.setBit(this.signature, idx);
        }
    }

    private void installSignature(byte[] signature) {
        this.makeSortedMethodList();
        int l = this.signatureMethods.size();
        int maxBytes = l + 7 >> 3;
        if (signature.length != maxBytes) {
            throw new RuntimeException("invalid filter signature length for deserialized proxy class");
        }
        this.signature = signature;
    }

    private boolean testBit(byte[] signature, int idx) {
        int byteIdx = idx >> 3;
        if (byteIdx > signature.length) {
            return false;
        }
        byte sigByte = signature[byteIdx];
        int bitIdx = idx & 7;
        int mask = 1 << bitIdx;
        return (sigByte & mask) != 0;
    }

    private void setBit(byte[] signature, int idx) {
        int byteIdx = idx >> 3;
        if (byteIdx < signature.length) {
            int bitIdx = idx & 7;
            int mask = 1 << bitIdx;
            byte sigByte = signature[byteIdx];
            signature[byteIdx] = (byte)(sigByte | mask);
        }
    }

    private static void setInterfaces(ClassFile cf, Class[] interfaces2) {
        String[] list2;
        String setterIntf = ProxyObject.class.getName();
        if (interfaces2 == null || interfaces2.length == 0) {
            list2 = new String[]{setterIntf};
        } else {
            list2 = new String[interfaces2.length + 1];
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                list2[i2] = interfaces2[i2].getName();
            }
            list2[interfaces2.length] = setterIntf;
        }
        cf.setInterfaces(list2);
    }

    private static void addMethodsHolder(ClassFile cf, ConstPool cp, String classname, int size2) throws CannotCompileException {
        FieldInfo finfo = new FieldInfo(cp, HOLDER, HOLDER_TYPE);
        finfo.setAccessFlags(10);
        cf.addField(finfo);
        MethodInfo minfo = new MethodInfo(cp, "<clinit>", "()V");
        minfo.setAccessFlags(8);
        Bytecode code = new Bytecode(cp, 0, 0);
        code.addIconst(size2 * 2);
        code.addAnewarray("java.lang.reflect.Method");
        code.addPutstatic(classname, HOLDER, HOLDER_TYPE);
        code.addLconst(-1L);
        code.addPutstatic(classname, SERIAL_VERSION_UID_FIELD, SERIAL_VERSION_UID_TYPE);
        code.addOpcode(177);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cf.addMethod(minfo);
    }

    private static void addSetter(String classname, ClassFile cf, ConstPool cp) throws CannotCompileException {
        MethodInfo minfo = new MethodInfo(cp, HANDLER_SETTER, HANDLER_SETTER_TYPE);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 2, 2);
        code.addAload(0);
        code.addAload(1);
        code.addPutfield(classname, HANDLER, HANDLER_TYPE);
        code.addOpcode(177);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cf.addMethod(minfo);
    }

    private static void addGetter(String classname, ClassFile cf, ConstPool cp) throws CannotCompileException {
        MethodInfo minfo = new MethodInfo(cp, HANDLER_GETTER, HANDLER_GETTER_TYPE);
        minfo.setAccessFlags(1);
        Bytecode code = new Bytecode(cp, 1, 1);
        code.addAload(0);
        code.addGetfield(classname, HANDLER, HANDLER_TYPE);
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        cf.addMethod(minfo);
    }

    private int overrideMethods(ClassFile cf, ConstPool cp, String className) throws CannotCompileException {
        String prefix = ProxyFactory.makeUniqueName("_d", this.signatureMethods);
        Iterator it = this.signatureMethods.iterator();
        int index2 = 0;
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String key2 = (String)e.getKey();
            Method meth = (Method)e.getValue();
            int mod = meth.getModifiers();
            if (this.testBit(this.signature, index2)) {
                this.override(className, meth, prefix, index2, ProxyFactory.keyToDesc(key2), cf, cp);
            }
            ++index2;
        }
        return index2;
    }

    private void override(String thisClassname, Method meth, String prefix, int index2, String desc, ClassFile cf, ConstPool cp) throws CannotCompileException {
        Class<?> declClass = meth.getDeclaringClass();
        String delegatorName = prefix + index2 + meth.getName();
        if (Modifier.isAbstract(meth.getModifiers())) {
            delegatorName = null;
        } else {
            MethodInfo delegator = ProxyFactory.makeDelegator(meth, desc, cp, declClass, delegatorName);
            delegator.setAccessFlags(delegator.getAccessFlags() & 0xFFFFFFBF);
            cf.addMethod(delegator);
        }
        MethodInfo forwarder = ProxyFactory.makeForwarder(thisClassname, meth, desc, cp, declClass, delegatorName, index2);
        cf.addMethod(forwarder);
    }

    private void makeConstructors(String thisClassName, ClassFile cf, ConstPool cp, String classname) throws CannotCompileException {
        Constructor[] cons = SecurityActions.getDeclaredConstructors(this.superClass);
        boolean doHandlerInit = !this.factoryUseCache;
        for (int i2 = 0; i2 < cons.length; ++i2) {
            Constructor c = cons[i2];
            int mod = c.getModifiers();
            if (Modifier.isFinal(mod) || Modifier.isPrivate(mod) || !ProxyFactory.isVisible(mod, this.basename, c)) continue;
            MethodInfo m = ProxyFactory.makeConstructor(thisClassName, c, cp, this.superClass, doHandlerInit);
            cf.addMethod(m);
        }
    }

    private static String makeUniqueName(String name2, List sortedMethods) {
        if (ProxyFactory.makeUniqueName0(name2, sortedMethods.iterator())) {
            return name2;
        }
        for (int i2 = 100; i2 < 999; ++i2) {
            String s2 = name2 + i2;
            if (!ProxyFactory.makeUniqueName0(s2, sortedMethods.iterator())) continue;
            return s2;
        }
        throw new RuntimeException("cannot make a unique method name");
    }

    private static boolean makeUniqueName0(String name2, Iterator it) {
        while (it.hasNext()) {
            Map.Entry e = (Map.Entry)it.next();
            String key2 = (String)e.getKey();
            if (!key2.startsWith(name2)) continue;
            return false;
        }
        return true;
    }

    private static boolean isVisible(int mod, String from, Member meth) {
        if ((mod & 2) != 0) {
            return false;
        }
        if ((mod & 5) != 0) {
            return true;
        }
        String p2 = ProxyFactory.getPackageName(from);
        String q = ProxyFactory.getPackageName(meth.getDeclaringClass().getName());
        if (p2 == null) {
            return q == null;
        }
        return p2.equals(q);
    }

    private static String getPackageName(String name2) {
        int i2 = name2.lastIndexOf(46);
        if (i2 < 0) {
            return null;
        }
        return name2.substring(0, i2);
    }

    private static HashMap getMethods(Class superClass, Class[] interfaceTypes) {
        HashMap hash2 = new HashMap();
        for (int i2 = 0; i2 < interfaceTypes.length; ++i2) {
            ProxyFactory.getMethods(hash2, interfaceTypes[i2]);
        }
        ProxyFactory.getMethods(hash2, superClass);
        return hash2;
    }

    private static void getMethods(HashMap hash2, Class clazz) {
        Class<?>[] ifs = clazz.getInterfaces();
        for (int i2 = 0; i2 < ifs.length; ++i2) {
            ProxyFactory.getMethods(hash2, ifs[i2]);
        }
        Class parent = clazz.getSuperclass();
        if (parent != null) {
            ProxyFactory.getMethods(hash2, parent);
        }
        Method[] methods2 = SecurityActions.getDeclaredMethods(clazz);
        for (int i3 = 0; i3 < methods2.length; ++i3) {
            Method m;
            String key2;
            Method oldMethod;
            if (Modifier.isPrivate(methods2[i3].getModifiers()) || null == (oldMethod = hash2.put(key2 = (m = methods2[i3]).getName() + ':' + RuntimeSupport.makeDescriptor(m), methods2[i3])) || !Modifier.isPublic(oldMethod.getModifiers()) || Modifier.isPublic(methods2[i3].getModifiers())) continue;
            hash2.put(key2, oldMethod);
        }
    }

    private static String keyToDesc(String key2) {
        return key2.substring(key2.indexOf(58) + 1);
    }

    private static MethodInfo makeConstructor(String thisClassName, Constructor cons, ConstPool cp, Class superClass, boolean doHandlerInit) {
        String desc = RuntimeSupport.makeDescriptor(cons.getParameterTypes(), Void.TYPE);
        MethodInfo minfo = new MethodInfo(cp, "<init>", desc);
        minfo.setAccessFlags(1);
        ProxyFactory.setThrows(minfo, cp, cons.getExceptionTypes());
        Bytecode code = new Bytecode(cp, 0, 0);
        if (doHandlerInit) {
            code.addAload(0);
            code.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            code.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
            code.addGetstatic(thisClassName, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
            code.addOpcode(199);
            code.addIndex(10);
        }
        code.addAload(0);
        code.addGetstatic(NULL_INTERCEPTOR_HOLDER, DEFAULT_INTERCEPTOR, HANDLER_TYPE);
        code.addPutfield(thisClassName, HANDLER, HANDLER_TYPE);
        int pc = code.currentPc();
        code.addAload(0);
        int s2 = ProxyFactory.addLoadParameters(code, cons.getParameterTypes(), 1);
        code.addInvokespecial(superClass.getName(), "<init>", desc);
        code.addOpcode(177);
        code.setMaxLocals(s2 + 1);
        CodeAttribute ca = code.toCodeAttribute();
        minfo.setCodeAttribute(ca);
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        writer.sameFrame(pc);
        ca.setAttribute(writer.toStackMapTable(cp));
        return minfo;
    }

    private static MethodInfo makeDelegator(Method meth, String desc, ConstPool cp, Class declClass, String delegatorName) {
        MethodInfo delegator = new MethodInfo(cp, delegatorName, desc);
        delegator.setAccessFlags(0x11 | meth.getModifiers() & 0xFFFFFAD9);
        ProxyFactory.setThrows(delegator, cp, meth);
        Bytecode code = new Bytecode(cp, 0, 0);
        code.addAload(0);
        int s2 = ProxyFactory.addLoadParameters(code, meth.getParameterTypes(), 1);
        code.addInvokespecial(declClass.getName(), meth.getName(), desc);
        ProxyFactory.addReturn(code, meth.getReturnType());
        code.setMaxLocals(++s2);
        delegator.setCodeAttribute(code.toCodeAttribute());
        return delegator;
    }

    private static MethodInfo makeForwarder(String thisClassName, Method meth, String desc, ConstPool cp, Class declClass, String delegatorName, int index2) {
        MethodInfo forwarder = new MethodInfo(cp, meth.getName(), desc);
        forwarder.setAccessFlags(0x10 | meth.getModifiers() & 0xFFFFFADF);
        ProxyFactory.setThrows(forwarder, cp, meth);
        int args2 = Descriptor.paramSize(desc);
        Bytecode code = new Bytecode(cp, 0, args2 + 2);
        int origIndex = index2 * 2;
        int delIndex = index2 * 2 + 1;
        int arrayVar = args2 + 1;
        code.addGetstatic(thisClassName, HOLDER, HOLDER_TYPE);
        code.addAstore(arrayVar);
        ProxyFactory.callFind2Methods(code, meth.getName(), delegatorName, origIndex, desc, arrayVar);
        code.addAload(0);
        code.addGetfield(thisClassName, HANDLER, HANDLER_TYPE);
        code.addAload(0);
        code.addAload(arrayVar);
        code.addIconst(origIndex);
        code.addOpcode(50);
        code.addAload(arrayVar);
        code.addIconst(delIndex);
        code.addOpcode(50);
        ProxyFactory.makeParameterList(code, meth.getParameterTypes());
        code.addInvokeinterface(MethodHandler.class.getName(), "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", 5);
        Class<?> retType = meth.getReturnType();
        ProxyFactory.addUnwrapper(code, retType);
        ProxyFactory.addReturn(code, retType);
        CodeAttribute ca = code.toCodeAttribute();
        forwarder.setCodeAttribute(ca);
        return forwarder;
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Method orig) {
        Class[] exceptions = orig.getExceptionTypes();
        ProxyFactory.setThrows(minfo, cp, exceptions);
    }

    private static void setThrows(MethodInfo minfo, ConstPool cp, Class[] exceptions) {
        if (exceptions.length == 0) {
            return;
        }
        String[] list2 = new String[exceptions.length];
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            list2[i2] = exceptions[i2].getName();
        }
        ExceptionsAttribute ea = new ExceptionsAttribute(cp);
        ea.setExceptions(list2);
        minfo.setExceptionsAttribute(ea);
    }

    private static int addLoadParameters(Bytecode code, Class[] params2, int offset2) {
        int stacksize = 0;
        int n = params2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            stacksize += ProxyFactory.addLoad(code, stacksize + offset2, params2[i2]);
        }
        return stacksize;
    }

    private static int addLoad(Bytecode code, int n, Class type2) {
        if (type2.isPrimitive()) {
            if (type2 == Long.TYPE) {
                code.addLload(n);
                return 2;
            }
            if (type2 == Float.TYPE) {
                code.addFload(n);
            } else {
                if (type2 == Double.TYPE) {
                    code.addDload(n);
                    return 2;
                }
                code.addIload(n);
            }
        } else {
            code.addAload(n);
        }
        return 1;
    }

    private static int addReturn(Bytecode code, Class type2) {
        if (type2.isPrimitive()) {
            if (type2 == Long.TYPE) {
                code.addOpcode(173);
                return 2;
            }
            if (type2 == Float.TYPE) {
                code.addOpcode(174);
            } else {
                if (type2 == Double.TYPE) {
                    code.addOpcode(175);
                    return 2;
                }
                if (type2 == Void.TYPE) {
                    code.addOpcode(177);
                    return 0;
                }
                code.addOpcode(172);
            }
        } else {
            code.addOpcode(176);
        }
        return 1;
    }

    private static void makeParameterList(Bytecode code, Class[] params2) {
        int regno = 1;
        int n = params2.length;
        code.addIconst(n);
        code.addAnewarray("java/lang/Object");
        for (int i2 = 0; i2 < n; ++i2) {
            code.addOpcode(89);
            code.addIconst(i2);
            Class type2 = params2[i2];
            if (type2.isPrimitive()) {
                regno = ProxyFactory.makeWrapper(code, type2, regno);
            } else {
                code.addAload(regno);
                ++regno;
            }
            code.addOpcode(83);
        }
    }

    private static int makeWrapper(Bytecode code, Class type2, int regno) {
        int index2 = FactoryHelper.typeIndex(type2);
        String wrapper = FactoryHelper.wrapperTypes[index2];
        code.addNew(wrapper);
        code.addOpcode(89);
        ProxyFactory.addLoad(code, regno, type2);
        code.addInvokespecial(wrapper, "<init>", FactoryHelper.wrapperDesc[index2]);
        return regno + FactoryHelper.dataSize[index2];
    }

    private static void callFind2Methods(Bytecode code, String superMethod, String thisMethod, int index2, String desc, int arrayVar) {
        String findClass = RuntimeSupport.class.getName();
        String findDesc = "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;[Ljava/lang/reflect/Method;)V";
        code.addAload(0);
        code.addLdc(superMethod);
        if (thisMethod == null) {
            code.addOpcode(1);
        } else {
            code.addLdc(thisMethod);
        }
        code.addIconst(index2);
        code.addLdc(desc);
        code.addAload(arrayVar);
        code.addInvokestatic(findClass, "find2Methods", findDesc);
    }

    private static void addUnwrapper(Bytecode code, Class type2) {
        if (type2.isPrimitive()) {
            if (type2 == Void.TYPE) {
                code.addOpcode(87);
            } else {
                int index2 = FactoryHelper.typeIndex(type2);
                String wrapper = FactoryHelper.wrapperTypes[index2];
                code.addCheckcast(wrapper);
                code.addInvokevirtual(wrapper, FactoryHelper.unwarpMethods[index2], FactoryHelper.unwrapDesc[index2]);
            }
        } else {
            code.addCheckcast(type2.getName());
        }
    }

    private static MethodInfo makeWriteReplace(ConstPool cp) {
        MethodInfo minfo = new MethodInfo(cp, "writeReplace", "()Ljava/lang/Object;");
        String[] list2 = new String[]{"java.io.ObjectStreamException"};
        ExceptionsAttribute ea = new ExceptionsAttribute(cp);
        ea.setExceptions(list2);
        minfo.setExceptionsAttribute(ea);
        Bytecode code = new Bytecode(cp, 0, 1);
        code.addAload(0);
        code.addInvokestatic(NULL_INTERCEPTOR_HOLDER, "makeSerializedProxy", "(Ljava/lang/Object;)Ljavassist/util/proxy/SerializedProxy;");
        code.addOpcode(176);
        minfo.setCodeAttribute(code.toCodeAttribute());
        return minfo;
    }

    public static interface ClassLoaderProvider {
        public ClassLoader get(ProxyFactory var1);
    }

    static class ProxyDetails {
        byte[] signature;
        WeakReference proxyClass;
        boolean isUseWriteReplace;

        ProxyDetails(byte[] signature, Class proxyClass, boolean isUseWriteReplace) {
            this.signature = signature;
            this.proxyClass = new WeakReference<Class>(proxyClass);
            this.isUseWriteReplace = isUseWriteReplace;
        }
    }
}

