/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import javassist.ClassPool;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;
import javassist.bytecode.stackmap.BasicBlock;
import javassist.bytecode.stackmap.Tracer;
import javassist.bytecode.stackmap.TypeData;
import javassist.bytecode.stackmap.TypedBlock;

public class MapMaker
extends Tracer {
    public static StackMapTable make(ClassPool classes2, MethodInfo minfo) throws BadBytecode {
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        TypedBlock[] blocks2 = TypedBlock.makeBlocks(minfo, ca, true);
        if (blocks2 == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes2, minfo, ca);
        mm.make(blocks2, ca.getCode());
        return mm.toStackMap(blocks2);
    }

    public static StackMap make2(ClassPool classes2, MethodInfo minfo) throws BadBytecode {
        CodeAttribute ca = minfo.getCodeAttribute();
        if (ca == null) {
            return null;
        }
        TypedBlock[] blocks2 = TypedBlock.makeBlocks(minfo, ca, true);
        if (blocks2 == null) {
            return null;
        }
        MapMaker mm = new MapMaker(classes2, minfo, ca);
        mm.make(blocks2, ca.getCode());
        return mm.toStackMap2(minfo.getConstPool(), blocks2);
    }

    public MapMaker(ClassPool classes2, MethodInfo minfo, CodeAttribute ca) {
        super(classes2, minfo.getConstPool(), ca.getMaxStack(), ca.getMaxLocals(), TypedBlock.getRetType(minfo.getDescriptor()));
    }

    protected MapMaker(MapMaker old, boolean copyStack) {
        super(old, copyStack);
    }

    void make(TypedBlock[] blocks2, byte[] code) throws BadBytecode {
        TypedBlock first2 = blocks2[0];
        this.fixParamTypes(first2);
        TypeData[] srcTypes = first2.localsTypes;
        MapMaker.copyFrom(srcTypes.length, srcTypes, this.localsTypes);
        this.make(code, first2);
        int n = blocks2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.evalExpected(blocks2[i2]);
        }
    }

    private void fixParamTypes(TypedBlock first2) throws BadBytecode {
        TypeData[] types = first2.localsTypes;
        int n = types.length;
        for (int i2 = 0; i2 < n; ++i2) {
            TypeData t = types[i2];
            if (!(t instanceof TypeData.ClassName)) continue;
            TypeData.setType(t, t.getName(), this.classPool);
        }
    }

    private void make(byte[] code, TypedBlock tb) throws BadBytecode {
        int pos2;
        BasicBlock.Catch handlers = tb.toCatch;
        while (handlers != null) {
            this.traceException(code, handlers);
            handlers = handlers.next;
        }
        int end2 = pos2 + tb.length;
        for (pos2 = tb.position; pos2 < end2; pos2 += this.doOpcode(pos2, code)) {
        }
        if (tb.exit != null) {
            for (int i2 = 0; i2 < tb.exit.length; ++i2) {
                TypedBlock e = (TypedBlock)tb.exit[i2];
                if (e.alreadySet()) {
                    this.mergeMap(e, true);
                    continue;
                }
                this.recordStackMap(e);
                MapMaker maker = new MapMaker(this, true);
                maker.make(code, e);
            }
        }
    }

    private void traceException(byte[] code, BasicBlock.Catch handler) throws BadBytecode {
        TypedBlock tb = (TypedBlock)handler.body;
        if (tb.alreadySet()) {
            this.mergeMap(tb, false);
        } else {
            this.recordStackMap(tb, handler.typeIndex);
            MapMaker maker = new MapMaker(this, false);
            maker.stackTypes[0] = tb.stackTypes[0].getSelf();
            maker.stackTop = 1;
            maker.make(code, tb);
        }
    }

    private void mergeMap(TypedBlock dest, boolean mergeStack) {
        int i2;
        boolean[] inputs = dest.inputs;
        int n = inputs.length;
        for (i2 = 0; i2 < n; ++i2) {
            if (!inputs[i2]) continue;
            this.merge(this.localsTypes[i2], dest.localsTypes[i2]);
        }
        if (mergeStack) {
            n = this.stackTop;
            for (i2 = 0; i2 < n; ++i2) {
                this.merge(this.stackTypes[i2], dest.stackTypes[i2]);
            }
        }
    }

    private void merge(TypeData td, TypeData target) {
        boolean tdIsObj = false;
        boolean targetIsObj = false;
        if (td != TOP && td.isObjectType()) {
            tdIsObj = true;
        }
        if (target != TOP && target.isObjectType()) {
            targetIsObj = true;
        }
        if (tdIsObj && targetIsObj) {
            target.merge(td);
        }
    }

    private void recordStackMap(TypedBlock target) throws BadBytecode {
        TypeData[] tStackTypes = new TypeData[this.stackTypes.length];
        int st = this.stackTop;
        MapMaker.copyFrom(st, this.stackTypes, tStackTypes);
        this.recordStackMap0(target, st, tStackTypes);
    }

    private void recordStackMap(TypedBlock target, int exceptionType) throws BadBytecode {
        String type2 = exceptionType == 0 ? "java.lang.Throwable" : this.cpool.getClassInfo(exceptionType);
        TypeData[] tStackTypes = new TypeData[this.stackTypes.length];
        tStackTypes[0] = new TypeData.ClassName(type2);
        this.recordStackMap0(target, 1, tStackTypes);
    }

    private void recordStackMap0(TypedBlock target, int st, TypeData[] tStackTypes) throws BadBytecode {
        int n = this.localsTypes.length;
        TypeData[] tLocalsTypes = new TypeData[n];
        int k = MapMaker.copyFrom(n, this.localsTypes, tLocalsTypes);
        boolean[] inputs = target.inputs;
        for (int i2 = 0; i2 < n; ++i2) {
            if (inputs[i2]) continue;
            tLocalsTypes[i2] = TOP;
        }
        target.setStackMap(st, tStackTypes, k, tLocalsTypes);
    }

    void evalExpected(TypedBlock target) throws BadBytecode {
        ClassPool cp = this.classPool;
        MapMaker.evalExpected(cp, target.stackTop, target.stackTypes);
        TypeData[] types = target.localsTypes;
        if (types != null) {
            MapMaker.evalExpected(cp, types.length, types);
        }
    }

    private static void evalExpected(ClassPool cp, int n, TypeData[] types) throws BadBytecode {
        for (int i2 = 0; i2 < n; ++i2) {
            TypeData td = types[i2];
            if (td == null) continue;
            td.evalExpectedType(cp);
        }
    }

    public StackMapTable toStackMap(TypedBlock[] blocks2) {
        StackMapTable.Writer writer = new StackMapTable.Writer(32);
        int n = blocks2.length;
        TypedBlock prev = blocks2[0];
        int offsetDelta = prev.length;
        if (prev.incoming > 0) {
            writer.sameFrame(0);
            --offsetDelta;
        }
        for (int i2 = 1; i2 < n; ++i2) {
            TypedBlock bb = blocks2[i2];
            if (this.isTarget(bb, blocks2[i2 - 1])) {
                bb.resetNumLocals();
                int diffL = MapMaker.stackMapDiff(prev.numLocals, prev.localsTypes, bb.numLocals, bb.localsTypes);
                this.toStackMapBody(writer, bb, diffL, offsetDelta, prev);
                offsetDelta = bb.length - 1;
                prev = bb;
                continue;
            }
            offsetDelta += bb.length;
        }
        return writer.toStackMapTable(this.cpool);
    }

    private boolean isTarget(TypedBlock cur, TypedBlock prev) {
        int in = cur.incoming;
        if (in > 1) {
            return true;
        }
        if (in < 1) {
            return false;
        }
        return prev.stop;
    }

    private void toStackMapBody(StackMapTable.Writer writer, TypedBlock bb, int diffL, int offsetDelta, TypedBlock prev) {
        int stackTop = bb.stackTop;
        if (stackTop == 0) {
            if (diffL == 0) {
                writer.sameFrame(offsetDelta);
                return;
            }
            if (0 > diffL && diffL >= -3) {
                writer.chopFrame(offsetDelta, -diffL);
                return;
            }
            if (0 < diffL && diffL <= 3) {
                int[] data2 = new int[diffL];
                int[] tags = this.fillStackMap(bb.numLocals - prev.numLocals, prev.numLocals, data2, bb.localsTypes);
                writer.appendFrame(offsetDelta, tags, data2);
                return;
            }
        } else {
            TypeData td;
            if (stackTop == 1 && diffL == 0) {
                TypeData td2 = bb.stackTypes[0];
                if (td2 == TOP) {
                    writer.sameLocals(offsetDelta, 0, 0);
                } else {
                    writer.sameLocals(offsetDelta, td2.getTypeTag(), td2.getTypeData(this.cpool));
                }
                return;
            }
            if (stackTop == 2 && diffL == 0 && (td = bb.stackTypes[0]) != TOP && td.is2WordType()) {
                writer.sameLocals(offsetDelta, td.getTypeTag(), td.getTypeData(this.cpool));
                return;
            }
        }
        int[] sdata = new int[stackTop];
        int[] stags = this.fillStackMap(stackTop, 0, sdata, bb.stackTypes);
        int[] ldata = new int[bb.numLocals];
        int[] ltags = this.fillStackMap(bb.numLocals, 0, ldata, bb.localsTypes);
        writer.fullFrame(offsetDelta, ltags, ldata, stags, sdata);
    }

    private int[] fillStackMap(int num, int offset2, int[] data2, TypeData[] types) {
        int realNum = MapMaker.diffSize(types, offset2, offset2 + num);
        ConstPool cp = this.cpool;
        int[] tags = new int[realNum];
        int j = 0;
        for (int i2 = 0; i2 < num; ++i2) {
            TypeData td = types[offset2 + i2];
            if (td == TOP) {
                tags[j] = 0;
                data2[j] = 0;
            } else {
                tags[j] = td.getTypeTag();
                data2[j] = td.getTypeData(cp);
                if (td.is2WordType()) {
                    ++i2;
                }
            }
            ++j;
        }
        return tags;
    }

    private static int stackMapDiff(int oldTdLen, TypeData[] oldTd, int newTdLen, TypeData[] newTd) {
        int diff = newTdLen - oldTdLen;
        int len = diff > 0 ? oldTdLen : newTdLen;
        if (MapMaker.stackMapEq(oldTd, newTd, len)) {
            if (diff > 0) {
                return MapMaker.diffSize(newTd, len, newTdLen);
            }
            return -MapMaker.diffSize(oldTd, len, oldTdLen);
        }
        return -100;
    }

    private static boolean stackMapEq(TypeData[] oldTd, TypeData[] newTd, int len) {
        for (int i2 = 0; i2 < len; ++i2) {
            TypeData td = oldTd[i2];
            if (!(td == TOP ? newTd[i2] != TOP : !oldTd[i2].equals(newTd[i2]))) continue;
            return false;
        }
        return true;
    }

    private static int diffSize(TypeData[] types, int offset2, int len) {
        int num = 0;
        while (offset2 < len) {
            TypeData td = types[offset2++];
            ++num;
            if (td == TOP || !td.is2WordType()) continue;
            ++offset2;
        }
        return num;
    }

    public StackMap toStackMap2(ConstPool cp, TypedBlock[] blocks2) {
        int i2;
        StackMap.Writer writer = new StackMap.Writer();
        int n = blocks2.length;
        boolean[] effective = new boolean[n];
        TypedBlock prev = blocks2[0];
        effective[0] = prev.incoming > 0;
        int num = effective[0] ? 1 : 0;
        for (i2 = 1; i2 < n; ++i2) {
            TypedBlock bb = blocks2[i2];
            effective[i2] = this.isTarget(bb, blocks2[i2 - 1]);
            if (!effective[i2]) continue;
            bb.resetNumLocals();
            prev = bb;
            ++num;
        }
        if (num == 0) {
            return null;
        }
        writer.write16bit(num);
        for (i2 = 0; i2 < n; ++i2) {
            if (!effective[i2]) continue;
            this.writeStackFrame(writer, cp, blocks2[i2].position, blocks2[i2]);
        }
        return writer.toStackMap(cp);
    }

    private void writeStackFrame(StackMap.Writer writer, ConstPool cp, int offset2, TypedBlock tb) {
        writer.write16bit(offset2);
        this.writeVerifyTypeInfo(writer, cp, tb.localsTypes, tb.numLocals);
        this.writeVerifyTypeInfo(writer, cp, tb.stackTypes, tb.stackTop);
    }

    private void writeVerifyTypeInfo(StackMap.Writer writer, ConstPool cp, TypeData[] types, int num) {
        TypeData td;
        int i2;
        int numDWord = 0;
        for (i2 = 0; i2 < num; ++i2) {
            td = types[i2];
            if (td == null || !td.is2WordType()) continue;
            ++numDWord;
            ++i2;
        }
        writer.write16bit(num - numDWord);
        for (i2 = 0; i2 < num; ++i2) {
            td = types[i2];
            if (td == TOP) {
                writer.writeVerifyTypeInfo(0, 0);
                continue;
            }
            writer.writeVerifyTypeInfo(td.getTypeTag(), td.getTypeData(cp));
            if (!td.is2WordType()) continue;
            ++i2;
        }
    }
}

