/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode.stackmap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;

public class BasicBlock {
    public int position;
    public int length;
    public int incoming;
    public BasicBlock[] exit;
    public boolean stop;
    public Catch toCatch;

    protected BasicBlock(int pos2) {
        this.position = pos2;
        this.length = 0;
        this.incoming = 0;
    }

    public static BasicBlock find(BasicBlock[] blocks2, int pos2) throws BadBytecode {
        for (int i2 = 0; i2 < blocks2.length; ++i2) {
            int iPos = blocks2[i2].position;
            if (iPos > pos2 || pos2 >= iPos + blocks2[i2].length) continue;
            return blocks2[i2];
        }
        throw new BadBytecode("no basic block at " + pos2);
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        String cname = this.getClass().getName();
        int i2 = cname.lastIndexOf(46);
        sbuf.append(i2 < 0 ? cname : cname.substring(i2 + 1));
        sbuf.append("[");
        this.toString2(sbuf);
        sbuf.append("]");
        return sbuf.toString();
    }

    protected void toString2(StringBuffer sbuf) {
        sbuf.append("pos=").append(this.position).append(", len=").append(this.length).append(", in=").append(this.incoming).append(", exit{");
        if (this.exit != null) {
            for (int i2 = 0; i2 < this.exit.length; ++i2) {
                sbuf.append(this.exit[i2].position).append(", ");
            }
        }
        sbuf.append("}, {");
        Catch th = this.toCatch;
        while (th != null) {
            sbuf.append("(").append(th.body.position).append(", ").append(th.typeIndex).append("), ");
            th = th.next;
        }
        sbuf.append("}");
    }

    public static class Maker {
        protected BasicBlock makeBlock(int pos2) {
            return new BasicBlock(pos2);
        }

        protected BasicBlock[] makeArray(int size2) {
            return new BasicBlock[size2];
        }

        private BasicBlock[] makeArray(BasicBlock b) {
            BasicBlock[] array = this.makeArray(1);
            array[0] = b;
            return array;
        }

        private BasicBlock[] makeArray(BasicBlock b1, BasicBlock b2) {
            BasicBlock[] array = this.makeArray(2);
            array[0] = b1;
            array[1] = b2;
            return array;
        }

        public BasicBlock[] make(MethodInfo minfo) throws BadBytecode {
            CodeAttribute ca = minfo.getCodeAttribute();
            if (ca == null) {
                return null;
            }
            CodeIterator ci = ca.iterator();
            return this.make(ci, 0, ci.getCodeLength(), ca.getExceptionTable());
        }

        public BasicBlock[] make(CodeIterator ci, int begin2, int end2, ExceptionTable et) throws BadBytecode {
            HashMap marks = this.makeMarks(ci, begin2, end2, et);
            BasicBlock[] bb = this.makeBlocks(marks);
            this.addCatchers(bb, et);
            return bb;
        }

        private Mark makeMark(HashMap table, int pos2) {
            return this.makeMark0(table, pos2, true, true);
        }

        private Mark makeMark(HashMap table, int pos2, BasicBlock[] jump, int size2, boolean always) {
            Mark m = this.makeMark0(table, pos2, false, false);
            m.setJump(jump, size2, always);
            return m;
        }

        private Mark makeMark0(HashMap table, int pos2, boolean isBlockBegin, boolean isTarget) {
            Integer p2 = new Integer(pos2);
            Mark m = (Mark)table.get(p2);
            if (m == null) {
                m = new Mark(pos2);
                table.put(p2, m);
            }
            if (isBlockBegin) {
                if (m.block == null) {
                    m.block = this.makeBlock(pos2);
                }
                if (isTarget) {
                    ++m.block.incoming;
                }
            }
            return m;
        }

        private HashMap makeMarks(CodeIterator ci, int begin2, int end2, ExceptionTable et) throws BadBytecode {
            int index2;
            ci.begin();
            ci.move(begin2);
            HashMap marks = new HashMap();
            while (ci.hasNext() && (index2 = ci.next()) < end2) {
                int op = ci.byteAt(index2);
                if (153 <= op && op <= 166 || op == 198 || op == 199) {
                    Mark to = this.makeMark(marks, index2 + ci.s16bitAt(index2 + 1));
                    Mark next = this.makeMark(marks, index2 + 3);
                    this.makeMark(marks, index2, this.makeArray(to.block, next.block), 3, false);
                    continue;
                }
                if (167 <= op && op <= 171) {
                    switch (op) {
                        case 167: {
                            this.makeGoto(marks, index2, index2 + ci.s16bitAt(index2 + 1), 3);
                            break;
                        }
                        case 168: {
                            this.makeJsr(marks, index2, index2 + ci.s16bitAt(index2 + 1), 3);
                            break;
                        }
                        case 169: {
                            this.makeMark(marks, index2, null, 2, true);
                            break;
                        }
                        case 170: {
                            int p2;
                            int pos2 = (index2 & 0xFFFFFFFC) + 4;
                            int low = ci.s32bitAt(pos2 + 4);
                            int high = ci.s32bitAt(pos2 + 8);
                            int ncases = high - low + 1;
                            BasicBlock[] to = this.makeArray(ncases + 1);
                            to[0] = this.makeMark(marks, (int)(index2 + ci.s32bitAt((int)pos2))).block;
                            int n = p2 + ncases * 4;
                            int k = 1;
                            for (p2 = pos2 + 12; p2 < n; p2 += 4) {
                                to[k++] = this.makeMark(marks, (int)(index2 + ci.s32bitAt((int)p2))).block;
                            }
                            this.makeMark(marks, index2, to, n - index2, true);
                            break;
                        }
                        case 171: {
                            int p3;
                            int pos3 = (index2 & 0xFFFFFFFC) + 4;
                            int ncases = ci.s32bitAt(pos3 + 4);
                            BasicBlock[] to = this.makeArray(ncases + 1);
                            to[0] = this.makeMark(marks, (int)(index2 + ci.s32bitAt((int)pos3))).block;
                            int n = p3 + ncases * 8 - 4;
                            int k = 1;
                            for (p3 = pos3 + 8 + 4; p3 < n; p3 += 8) {
                                to[k++] = this.makeMark(marks, (int)(index2 + ci.s32bitAt((int)p3))).block;
                            }
                            this.makeMark(marks, index2, to, n - index2, true);
                            break;
                        }
                    }
                    continue;
                }
                if (172 <= op && op <= 177 || op == 191) {
                    this.makeMark(marks, index2, null, 1, true);
                    continue;
                }
                if (op == 200) {
                    this.makeGoto(marks, index2, index2 + ci.s32bitAt(index2 + 1), 5);
                    continue;
                }
                if (op == 201) {
                    this.makeJsr(marks, index2, index2 + ci.s32bitAt(index2 + 1), 5);
                    continue;
                }
                if (op != 196 || ci.byteAt(index2 + 1) != 169) continue;
                this.makeMark(marks, index2, null, 1, true);
            }
            if (et != null) {
                int i2 = et.size();
                while (--i2 >= 0) {
                    this.makeMark0(marks, et.startPc(i2), true, false);
                    this.makeMark(marks, et.handlerPc(i2));
                }
            }
            return marks;
        }

        private void makeGoto(HashMap marks, int pos2, int target, int size2) {
            Mark to = this.makeMark(marks, target);
            BasicBlock[] jumps = this.makeArray(to.block);
            this.makeMark(marks, pos2, jumps, size2, true);
        }

        protected void makeJsr(HashMap marks, int pos2, int target, int size2) {
        }

        private BasicBlock[] makeBlocks(HashMap markTable) {
            Object[] marks = markTable.values().toArray(new Mark[markTable.size()]);
            Arrays.sort(marks);
            ArrayList<BasicBlock> blocks2 = new ArrayList<BasicBlock>();
            int i2 = 0;
            BasicBlock prev = marks.length > 0 && ((Mark)marks[0]).position == 0 && ((Mark)marks[0]).block != null ? Maker.getBBlock((Mark)marks[i2++]) : this.makeBlock(0);
            blocks2.add(prev);
            while (i2 < marks.length) {
                Object m;
                BasicBlock bb;
                if ((bb = Maker.getBBlock((Mark)(m = marks[i2++]))) == null) {
                    if (prev.length > 0) {
                        prev = this.makeBlock(prev.position + prev.length);
                        blocks2.add(prev);
                    }
                    prev.length = ((Mark)m).position + ((Mark)m).size - prev.position;
                    prev.exit = ((Mark)m).jump;
                    prev.stop = ((Mark)m).alwaysJmp;
                    continue;
                }
                if (prev.length == 0) {
                    prev.length = ((Mark)m).position - prev.position;
                    ++bb.incoming;
                    prev.exit = this.makeArray(bb);
                } else {
                    int prevPos = prev.position;
                    if (prevPos + prev.length < ((Mark)m).position) {
                        prev = this.makeBlock(prevPos + prev.length);
                        prev.length = ((Mark)m).position - prevPos;
                        prev.exit = this.makeArray(bb);
                    }
                }
                blocks2.add(bb);
                prev = bb;
            }
            return blocks2.toArray(this.makeArray(blocks2.size()));
        }

        private static BasicBlock getBBlock(Mark m) {
            BasicBlock b = m.block;
            if (b != null && m.size > 0) {
                b.exit = m.jump;
                b.length = m.size;
                b.stop = m.alwaysJmp;
            }
            return b;
        }

        private void addCatchers(BasicBlock[] blocks2, ExceptionTable et) throws BadBytecode {
            if (et == null) {
                return;
            }
            int i2 = et.size();
            while (--i2 >= 0) {
                BasicBlock handler = BasicBlock.find(blocks2, et.handlerPc(i2));
                int start2 = et.startPc(i2);
                int end2 = et.endPc(i2);
                int type2 = et.catchType(i2);
                --handler.incoming;
                for (int k = 0; k < blocks2.length; ++k) {
                    BasicBlock bb = blocks2[k];
                    int iPos = bb.position;
                    if (start2 > iPos || iPos >= end2) continue;
                    bb.toCatch = new Catch(handler, type2, bb.toCatch);
                    ++handler.incoming;
                }
            }
        }
    }

    static class Mark
    implements Comparable {
        int position;
        BasicBlock block;
        BasicBlock[] jump;
        boolean alwaysJmp;
        int size;
        Catch catcher;

        Mark(int p2) {
            this.position = p2;
            this.block = null;
            this.jump = null;
            this.alwaysJmp = false;
            this.size = 0;
            this.catcher = null;
        }

        public int compareTo(Object obj) {
            if (obj instanceof Mark) {
                int pos2 = ((Mark)obj).position;
                return this.position - pos2;
            }
            return -1;
        }

        void setJump(BasicBlock[] bb, int s2, boolean always) {
            this.jump = bb;
            this.size = s2;
            this.alwaysJmp = always;
        }
    }

    public static class Catch {
        Catch next;
        BasicBlock body;
        int typeIndex;

        Catch(BasicBlock b, int i2, Catch c) {
            this.body = b;
            this.typeIndex = i2;
            this.next = c;
        }
    }
}

