/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class StackMapTable
extends AttributeInfo {
    public static final String tag = "StackMapTable";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    StackMapTable(ConstPool cp, byte[] newInfo) {
        super(cp, tag, newInfo);
    }

    StackMapTable(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, in);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) throws RuntimeCopyException {
        try {
            return new StackMapTable(newCp, new Copier(this.constPool, this.info, newCp).doit());
        }
        catch (BadBytecode e) {
            throw new RuntimeCopyException("bad bytecode. fatal?");
        }
    }

    void write(DataOutputStream out) throws IOException {
        super.write(out);
    }

    public void insertLocal(int index2, int tag2, int classInfo) throws BadBytecode {
        byte[] data2 = new InsertLocal(this.get(), index2, tag2, classInfo).doit();
        this.set(data2);
    }

    public static int typeTagOf(char descriptor) {
        switch (descriptor) {
            case 'D': {
                return 3;
            }
            case 'F': {
                return 2;
            }
            case 'J': {
                return 4;
            }
            case 'L': 
            case '[': {
                return 7;
            }
        }
        return 1;
    }

    public void println(PrintWriter w) {
        Printer.print(this, w);
    }

    public void println(PrintStream ps) {
        Printer.print(this, new PrintWriter(ps, true));
    }

    void shiftPc(int where, int gapSize, boolean exclusive2) throws BadBytecode {
        new Shifter(this, where, gapSize, exclusive2).doit();
    }

    public void removeNew(int where) throws CannotCompileException {
        try {
            byte[] data2 = new NewRemover(this.get(), where).doit();
            this.set(data2);
        }
        catch (BadBytecode e) {
            throw new CannotCompileException("bad stack map table", e);
        }
    }

    static class NewRemover
    extends SimpleCopy {
        int posOfNew;

        public NewRemover(byte[] data2, int pos2) {
            super(data2);
            this.posOfNew = pos2;
        }

        public void sameLocals(int pos2, int offsetDelta, int stackTag, int stackData) {
            if (stackTag == 8 && stackData == this.posOfNew) {
                super.sameFrame(pos2, offsetDelta);
            } else {
                super.sameLocals(pos2, offsetDelta, stackTag, stackData);
            }
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int n = stackTags.length - 1;
            for (int i2 = 0; i2 < n; ++i2) {
                if (stackTags[i2] != 8 || stackData[i2] != this.posOfNew || stackTags[i2 + 1] != 8 || stackData[i2 + 1] != this.posOfNew) continue;
                int[] stackTags2 = new int[++n - 2];
                int[] stackData2 = new int[n - 2];
                int k = 0;
                for (int j = 0; j < n; ++j) {
                    if (j == i2) {
                        ++j;
                        continue;
                    }
                    stackTags2[k] = stackTags[j];
                    stackData2[k++] = stackData[j];
                }
                stackTags = stackTags2;
                stackData = stackData2;
                break;
            }
            super.fullFrame(pos2, offsetDelta, localTags, localData, stackTags, stackData);
        }
    }

    static class Shifter
    extends Walker {
        private StackMapTable stackMap;
        private int where;
        private int gap;
        private int position;
        private byte[] updatedInfo;
        private boolean exclusive;

        public Shifter(StackMapTable smt, int where, int gap, boolean exclusive2) {
            super(smt);
            this.stackMap = smt;
            this.where = where;
            this.gap = gap;
            this.position = 0;
            this.updatedInfo = null;
            this.exclusive = exclusive2;
        }

        public void doit() throws BadBytecode {
            this.parse();
            if (this.updatedInfo != null) {
                this.stackMap.set(this.updatedInfo);
            }
        }

        public void sameFrame(int pos2, int offsetDelta) {
            this.update(pos2, offsetDelta, 0, 251);
        }

        public void sameLocals(int pos2, int offsetDelta, int stackTag, int stackData) {
            this.update(pos2, offsetDelta, 64, 247);
        }

        private void update(int pos2, int offsetDelta, int base, int entry) {
            boolean match2;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                match2 = oldPos < this.where && this.where <= this.position;
            } else {
                boolean bl = match2 = oldPos <= this.where && this.where < this.position;
            }
            if (match2) {
                int newDelta = offsetDelta + this.gap;
                this.position += this.gap;
                if (newDelta < 64) {
                    this.info[pos2] = (byte)(newDelta + base);
                } else if (offsetDelta < 64) {
                    byte[] newinfo = Shifter.insertGap(this.info, pos2, 2);
                    newinfo[pos2] = (byte)entry;
                    ByteArray.write16bit(newDelta, newinfo, pos2 + 1);
                    this.updatedInfo = newinfo;
                } else {
                    ByteArray.write16bit(newDelta, this.info, pos2 + 1);
                }
            }
        }

        private static byte[] insertGap(byte[] info, int where, int gap) {
            int len = info.length;
            byte[] newinfo = new byte[len + gap];
            for (int i2 = 0; i2 < len; ++i2) {
                newinfo[i2 + (i2 < where ? 0 : gap)] = info[i2];
            }
            return newinfo;
        }

        public void chopFrame(int pos2, int offsetDelta, int k) {
            this.update(pos2, offsetDelta);
        }

        public void appendFrame(int pos2, int offsetDelta, int[] tags, int[] data2) {
            this.update(pos2, offsetDelta);
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            this.update(pos2, offsetDelta);
        }

        private void update(int pos2, int offsetDelta) {
            boolean match2;
            int oldPos;
            this.position = oldPos + offsetDelta + ((oldPos = this.position) == 0 ? 0 : 1);
            if (this.exclusive) {
                match2 = oldPos < this.where && this.where <= this.position;
            } else {
                boolean bl = match2 = oldPos <= this.where && this.where < this.position;
            }
            if (match2) {
                int newDelta = offsetDelta + this.gap;
                ByteArray.write16bit(newDelta, this.info, pos2 + 1);
                this.position += this.gap;
            }
        }
    }

    static class Printer
    extends Walker {
        private PrintWriter writer;
        private int offset;

        public static void print(StackMapTable smt, PrintWriter writer) {
            try {
                new Printer(smt.get(), writer).parse();
            }
            catch (BadBytecode e) {
                writer.println(e.getMessage());
            }
        }

        Printer(byte[] data2, PrintWriter pw) {
            super(data2);
            this.writer = pw;
            this.offset = -1;
        }

        public void sameFrame(int pos2, int offsetDelta) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same frame: " + offsetDelta);
        }

        public void sameLocals(int pos2, int offsetDelta, int stackTag, int stackData) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " same locals: " + offsetDelta);
            this.printTypeInfo(stackTag, stackData);
        }

        public void chopFrame(int pos2, int offsetDelta, int k) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " chop frame: " + offsetDelta + ",    " + k + " last locals");
        }

        public void appendFrame(int pos2, int offsetDelta, int[] tags, int[] data2) {
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " append frame: " + offsetDelta);
            for (int i2 = 0; i2 < tags.length; ++i2) {
                this.printTypeInfo(tags[i2], data2[i2]);
            }
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int i2;
            this.offset += offsetDelta + 1;
            this.writer.println(this.offset + " full frame: " + offsetDelta);
            this.writer.println("[locals]");
            for (i2 = 0; i2 < localTags.length; ++i2) {
                this.printTypeInfo(localTags[i2], localData[i2]);
            }
            this.writer.println("[stack]");
            for (i2 = 0; i2 < stackTags.length; ++i2) {
                this.printTypeInfo(stackTags[i2], stackData[i2]);
            }
        }

        private void printTypeInfo(int tag2, int data2) {
            String msg = null;
            switch (tag2) {
                case 0: {
                    msg = "top";
                    break;
                }
                case 1: {
                    msg = "integer";
                    break;
                }
                case 2: {
                    msg = "float";
                    break;
                }
                case 3: {
                    msg = "double";
                    break;
                }
                case 4: {
                    msg = "long";
                    break;
                }
                case 5: {
                    msg = "null";
                    break;
                }
                case 6: {
                    msg = "this";
                    break;
                }
                case 7: {
                    msg = "object (cpool_index " + data2 + ")";
                    break;
                }
                case 8: {
                    msg = "uninitialized (offset " + data2 + ")";
                }
            }
            this.writer.print("    ");
            this.writer.println(msg);
        }
    }

    public static class Writer {
        ByteArrayOutputStream output;
        int numOfEntries;

        public Writer(int size2) {
            this.output = new ByteArrayOutputStream(size2);
            this.numOfEntries = 0;
            this.output.write(0);
            this.output.write(0);
        }

        public byte[] toByteArray() {
            byte[] b = this.output.toByteArray();
            ByteArray.write16bit(this.numOfEntries, b, 0);
            return b;
        }

        public StackMapTable toStackMapTable(ConstPool cp) {
            return new StackMapTable(cp, this.toByteArray());
        }

        public void sameFrame(int offsetDelta) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta);
            } else {
                this.output.write(251);
                this.write16(offsetDelta);
            }
        }

        public void sameLocals(int offsetDelta, int tag2, int data2) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta + 64);
            } else {
                this.output.write(247);
                this.write16(offsetDelta);
            }
            this.writeTypeInfo(tag2, data2);
        }

        public void chopFrame(int offsetDelta, int k) {
            ++this.numOfEntries;
            this.output.write(251 - k);
            this.write16(offsetDelta);
        }

        public void appendFrame(int offsetDelta, int[] tags, int[] data2) {
            ++this.numOfEntries;
            int k = tags.length;
            this.output.write(k + 251);
            this.write16(offsetDelta);
            for (int i2 = 0; i2 < k; ++i2) {
                this.writeTypeInfo(tags[i2], data2[i2]);
            }
        }

        public void fullFrame(int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int i2;
            ++this.numOfEntries;
            this.output.write(255);
            this.write16(offsetDelta);
            int n = localTags.length;
            this.write16(n);
            for (i2 = 0; i2 < n; ++i2) {
                this.writeTypeInfo(localTags[i2], localData[i2]);
            }
            n = stackTags.length;
            this.write16(n);
            for (i2 = 0; i2 < n; ++i2) {
                this.writeTypeInfo(stackTags[i2], stackData[i2]);
            }
        }

        private void writeTypeInfo(int tag2, int data2) {
            this.output.write(tag2);
            if (tag2 == 7 || tag2 == 8) {
                this.write16(data2);
            }
        }

        private void write16(int value2) {
            this.output.write(value2 >>> 8 & 0xFF);
            this.output.write(value2 & 0xFF);
        }
    }

    static class InsertLocal
    extends SimpleCopy {
        private int varIndex;
        private int varTag;
        private int varData;

        public InsertLocal(byte[] data2, int varIndex, int varTag, int varData) {
            super(data2);
            this.varIndex = varIndex;
            this.varTag = varTag;
            this.varData = varData;
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int len = localTags.length;
            if (len < this.varIndex) {
                super.fullFrame(pos2, offsetDelta, localTags, localData, stackTags, stackData);
                return;
            }
            int typeSize = this.varTag == 4 || this.varTag == 3 ? 2 : 1;
            int[] localTags2 = new int[len + typeSize];
            int[] localData2 = new int[len + typeSize];
            int index2 = this.varIndex;
            int j = 0;
            for (int i2 = 0; i2 < len; ++i2) {
                if (j == index2) {
                    j += typeSize;
                }
                localTags2[j] = localTags[i2];
                localData2[j++] = localData[i2];
            }
            localTags2[index2] = this.varTag;
            localData2[index2] = this.varData;
            if (typeSize > 1) {
                localTags2[index2 + 1] = 0;
                localData2[index2 + 1] = 0;
            }
            super.fullFrame(pos2, offsetDelta, localTags2, localData2, stackTags, stackData);
        }
    }

    static class Copier
    extends SimpleCopy {
        private ConstPool srcPool;
        private ConstPool destPool;

        public Copier(ConstPool src, byte[] data2, ConstPool dest) {
            super(data2);
            this.srcPool = src;
            this.destPool = dest;
        }

        protected int copyData(int tag2, int data2) {
            if (tag2 == 7) {
                return this.srcPool.copy(data2, this.destPool, null);
            }
            return data2;
        }

        protected int[] copyData(int[] tags, int[] data2) {
            int[] newData = new int[data2.length];
            for (int i2 = 0; i2 < data2.length; ++i2) {
                newData[i2] = tags[i2] == 7 ? this.srcPool.copy(data2[i2], this.destPool, null) : data2[i2];
            }
            return newData;
        }
    }

    static class SimpleCopy
    extends Walker {
        private Writer writer;

        public SimpleCopy(byte[] data2) {
            super(data2);
            this.writer = new Writer(data2.length);
        }

        public byte[] doit() throws BadBytecode {
            this.parse();
            return this.writer.toByteArray();
        }

        public void sameFrame(int pos2, int offsetDelta) {
            this.writer.sameFrame(offsetDelta);
        }

        public void sameLocals(int pos2, int offsetDelta, int stackTag, int stackData) {
            this.writer.sameLocals(offsetDelta, stackTag, this.copyData(stackTag, stackData));
        }

        public void chopFrame(int pos2, int offsetDelta, int k) {
            this.writer.chopFrame(offsetDelta, k);
        }

        public void appendFrame(int pos2, int offsetDelta, int[] tags, int[] data2) {
            this.writer.appendFrame(offsetDelta, tags, this.copyData(tags, data2));
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            this.writer.fullFrame(offsetDelta, localTags, this.copyData(localTags, localData), stackTags, this.copyData(stackTags, stackData));
        }

        protected int copyData(int tag2, int data2) {
            return data2;
        }

        protected int[] copyData(int[] tags, int[] data2) {
            return data2;
        }
    }

    public static class Walker {
        byte[] info;
        int numOfEntries;

        public Walker(StackMapTable smt) {
            this(smt.get());
        }

        public Walker(byte[] data2) {
            this.info = data2;
            this.numOfEntries = ByteArray.readU16bit(data2, 0);
        }

        public final int size() {
            return this.numOfEntries;
        }

        public void parse() throws BadBytecode {
            int n = this.numOfEntries;
            int pos2 = 2;
            for (int i2 = 0; i2 < n; ++i2) {
                pos2 = this.stackMapFrames(pos2, i2);
            }
        }

        int stackMapFrames(int pos2, int nth) throws BadBytecode {
            int type2 = this.info[pos2] & 0xFF;
            if (type2 < 64) {
                this.sameFrame(pos2, type2);
                ++pos2;
            } else if (type2 < 128) {
                pos2 = this.sameLocals(pos2, type2);
            } else {
                if (type2 < 247) {
                    throw new BadBytecode("bad frame_type in StackMapTable");
                }
                if (type2 == 247) {
                    pos2 = this.sameLocals(pos2, type2);
                } else if (type2 < 251) {
                    int offset2 = ByteArray.readU16bit(this.info, pos2 + 1);
                    this.chopFrame(pos2, offset2, 251 - type2);
                    pos2 += 3;
                } else if (type2 == 251) {
                    int offset3 = ByteArray.readU16bit(this.info, pos2 + 1);
                    this.sameFrame(pos2, offset3);
                    pos2 += 3;
                } else {
                    pos2 = type2 < 255 ? this.appendFrame(pos2, type2) : this.fullFrame(pos2);
                }
            }
            return pos2;
        }

        public void sameFrame(int pos2, int offsetDelta) throws BadBytecode {
        }

        private int sameLocals(int pos2, int type2) throws BadBytecode {
            int offset2;
            int top = pos2;
            if (type2 < 128) {
                offset2 = type2 - 64;
            } else {
                offset2 = ByteArray.readU16bit(this.info, pos2 + 1);
                pos2 += 2;
            }
            int tag2 = this.info[pos2 + 1] & 0xFF;
            int data2 = 0;
            if (tag2 == 7 || tag2 == 8) {
                data2 = ByteArray.readU16bit(this.info, pos2 + 2);
                pos2 += 2;
            }
            this.sameLocals(top, offset2, tag2, data2);
            return pos2 + 2;
        }

        public void sameLocals(int pos2, int offsetDelta, int stackTag, int stackData) throws BadBytecode {
        }

        public void chopFrame(int pos2, int offsetDelta, int k) throws BadBytecode {
        }

        private int appendFrame(int pos2, int type2) throws BadBytecode {
            int k = type2 - 251;
            int offset2 = ByteArray.readU16bit(this.info, pos2 + 1);
            int[] tags = new int[k];
            int[] data2 = new int[k];
            int p2 = pos2 + 3;
            for (int i2 = 0; i2 < k; ++i2) {
                int tag2;
                tags[i2] = tag2 = this.info[p2] & 0xFF;
                if (tag2 == 7 || tag2 == 8) {
                    data2[i2] = ByteArray.readU16bit(this.info, p2 + 1);
                    p2 += 3;
                    continue;
                }
                data2[i2] = 0;
                ++p2;
            }
            this.appendFrame(pos2, offset2, tags, data2);
            return p2;
        }

        public void appendFrame(int pos2, int offsetDelta, int[] tags, int[] data2) throws BadBytecode {
        }

        private int fullFrame(int pos2) throws BadBytecode {
            int offset2 = ByteArray.readU16bit(this.info, pos2 + 1);
            int numOfLocals = ByteArray.readU16bit(this.info, pos2 + 3);
            int[] localsTags = new int[numOfLocals];
            int[] localsData = new int[numOfLocals];
            int p2 = this.verifyTypeInfo(pos2 + 5, numOfLocals, localsTags, localsData);
            int numOfItems = ByteArray.readU16bit(this.info, p2);
            int[] itemsTags = new int[numOfItems];
            int[] itemsData = new int[numOfItems];
            p2 = this.verifyTypeInfo(p2 + 2, numOfItems, itemsTags, itemsData);
            this.fullFrame(pos2, offset2, localsTags, localsData, itemsTags, itemsData);
            return p2;
        }

        public void fullFrame(int pos2, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) throws BadBytecode {
        }

        private int verifyTypeInfo(int pos2, int n, int[] tags, int[] data2) {
            for (int i2 = 0; i2 < n; ++i2) {
                int tag2;
                tags[i2] = tag2 = this.info[pos2++] & 0xFF;
                if (tag2 != 7 && tag2 != 8) continue;
                data2[i2] = ByteArray.readU16bit(this.info, pos2);
                pos2 += 2;
            }
            return pos2;
        }
    }

    public static class RuntimeCopyException
    extends RuntimeException {
        public RuntimeCopyException(String s2) {
            super(s2);
        }
    }
}

