/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.util.ArrayList;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.LineNumberAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.Opcode;
import javassist.bytecode.StackMap;
import javassist.bytecode.StackMapTable;

public class CodeIterator
implements Opcode {
    protected CodeAttribute codeAttr;
    protected byte[] bytecode;
    protected int endPos;
    protected int currentPos;
    protected int mark;
    private static final int[] opcodeLength = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 2, 3, 3, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 0, 0, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 5, 0, 3, 2, 3, 1, 1, 3, 3, 1, 1, 0, 4, 3, 3, 5, 5};

    protected CodeIterator(CodeAttribute ca) {
        this.codeAttr = ca;
        this.bytecode = ca.getCode();
        this.begin();
    }

    public void begin() {
        this.mark = 0;
        this.currentPos = 0;
        this.endPos = this.getCodeLength();
    }

    public void move(int index2) {
        this.currentPos = index2;
    }

    public void setMark(int index2) {
        this.mark = index2;
    }

    public int getMark() {
        return this.mark;
    }

    public CodeAttribute get() {
        return this.codeAttr;
    }

    public int getCodeLength() {
        return this.bytecode.length;
    }

    public int byteAt(int index2) {
        return this.bytecode[index2] & 0xFF;
    }

    public void writeByte(int value2, int index2) {
        this.bytecode[index2] = (byte)value2;
    }

    public int u16bitAt(int index2) {
        return ByteArray.readU16bit(this.bytecode, index2);
    }

    public int s16bitAt(int index2) {
        return ByteArray.readS16bit(this.bytecode, index2);
    }

    public void write16bit(int value2, int index2) {
        ByteArray.write16bit(value2, this.bytecode, index2);
    }

    public int s32bitAt(int index2) {
        return ByteArray.read32bit(this.bytecode, index2);
    }

    public void write32bit(int value2, int index2) {
        ByteArray.write32bit(value2, this.bytecode, index2);
    }

    public void write(byte[] code, int index2) {
        int len = code.length;
        for (int j = 0; j < len; ++j) {
            this.bytecode[index2++] = code[j];
        }
    }

    public boolean hasNext() {
        return this.currentPos < this.endPos;
    }

    public int next() throws BadBytecode {
        int pos2 = this.currentPos;
        this.currentPos = CodeIterator.nextOpcode(this.bytecode, pos2);
        return pos2;
    }

    public int lookAhead() {
        return this.currentPos;
    }

    public int skipConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(-1);
    }

    public int skipSuperConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(0);
    }

    public int skipThisConstructor() throws BadBytecode {
        return this.skipSuperConstructor0(1);
    }

    private int skipSuperConstructor0(int skipThis) throws BadBytecode {
        this.begin();
        ConstPool cp = this.codeAttr.getConstPool();
        String thisClassName = this.codeAttr.getDeclaringClass();
        int nested = 0;
        while (this.hasNext()) {
            int mref;
            int index2 = this.next();
            int c = this.byteAt(index2);
            if (c == 187) {
                ++nested;
                continue;
            }
            if (c != 183 || !cp.getMethodrefName(mref = ByteArray.readU16bit(this.bytecode, index2 + 1)).equals("<init>") || --nested >= 0) continue;
            if (skipThis < 0) {
                return index2;
            }
            String cname = cp.getMethodrefClassName(mref);
            if (cname.equals(thisClassName) != skipThis > 0) break;
            return index2;
        }
        this.begin();
        return -1;
    }

    public int insert(byte[] code) throws BadBytecode {
        return this.insert0(this.currentPos, code, false);
    }

    public void insert(int pos2, byte[] code) throws BadBytecode {
        this.insert0(pos2, code, false);
    }

    public int insertAt(int pos2, byte[] code) throws BadBytecode {
        return this.insert0(pos2, code, false);
    }

    public int insertEx(byte[] code) throws BadBytecode {
        return this.insert0(this.currentPos, code, true);
    }

    public void insertEx(int pos2, byte[] code) throws BadBytecode {
        this.insert0(pos2, code, true);
    }

    public int insertExAt(int pos2, byte[] code) throws BadBytecode {
        return this.insert0(pos2, code, true);
    }

    private int insert0(int pos2, byte[] code, boolean exclusive2) throws BadBytecode {
        int len = code.length;
        if (len <= 0) {
            return pos2;
        }
        int p2 = pos2 = this.insertGapAt((int)pos2, (int)len, (boolean)exclusive2).position;
        for (int j = 0; j < len; ++j) {
            this.bytecode[p2++] = code[j];
        }
        return pos2;
    }

    public int insertGap(int length2) throws BadBytecode {
        return this.insertGapAt((int)this.currentPos, (int)length2, (boolean)false).position;
    }

    public int insertGap(int pos2, int length2) throws BadBytecode {
        return this.insertGapAt((int)pos2, (int)length2, (boolean)false).length;
    }

    public int insertExGap(int length2) throws BadBytecode {
        return this.insertGapAt((int)this.currentPos, (int)length2, (boolean)true).position;
    }

    public int insertExGap(int pos2, int length2) throws BadBytecode {
        return this.insertGapAt((int)pos2, (int)length2, (boolean)true).length;
    }

    public Gap insertGapAt(int pos2, int length2, boolean exclusive2) throws BadBytecode {
        int length22;
        byte[] c;
        Gap gap = new Gap();
        if (length2 <= 0) {
            gap.position = pos2;
            gap.length = 0;
            return gap;
        }
        if (this.bytecode.length + length2 > Short.MAX_VALUE) {
            c = this.insertGapCore0w(this.bytecode, pos2, length2, exclusive2, this.get().getExceptionTable(), this.codeAttr, gap);
            pos2 = gap.position;
            length22 = length2;
        } else {
            int cur = this.currentPos;
            c = CodeIterator.insertGapCore0(this.bytecode, pos2, length2, exclusive2, this.get().getExceptionTable(), this.codeAttr);
            length22 = c.length - this.bytecode.length;
            gap.position = pos2;
            gap.length = length22;
            if (cur >= pos2) {
                this.currentPos = cur + length22;
            }
            if (this.mark > pos2 || this.mark == pos2 && exclusive2) {
                this.mark += length22;
            }
        }
        this.codeAttr.setCode(c);
        this.bytecode = c;
        this.endPos = this.getCodeLength();
        this.updateCursors(pos2, length22);
        return gap;
    }

    protected void updateCursors(int pos2, int length2) {
    }

    public void insert(ExceptionTable et, int offset2) {
        this.codeAttr.getExceptionTable().add(0, et, offset2);
    }

    public int append(byte[] code) {
        int size2 = this.getCodeLength();
        int len = code.length;
        if (len <= 0) {
            return size2;
        }
        this.appendGap(len);
        byte[] dest = this.bytecode;
        for (int i2 = 0; i2 < len; ++i2) {
            dest[i2 + size2] = code[i2];
        }
        return size2;
    }

    public void appendGap(int gapLength) {
        int i2;
        byte[] code = this.bytecode;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        for (i2 = 0; i2 < codeLength; ++i2) {
            newcode[i2] = code[i2];
        }
        for (i2 = codeLength; i2 < codeLength + gapLength; ++i2) {
            newcode[i2] = 0;
        }
        this.codeAttr.setCode(newcode);
        this.bytecode = newcode;
        this.endPos = this.getCodeLength();
    }

    public void append(ExceptionTable et, int offset2) {
        ExceptionTable table = this.codeAttr.getExceptionTable();
        table.add(table.size(), et, offset2);
    }

    static int nextOpcode(byte[] code, int index2) throws BadBytecode {
        int opcode;
        try {
            opcode = code[index2] & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new BadBytecode("invalid opcode address");
        }
        try {
            int len = opcodeLength[opcode];
            if (len > 0) {
                return index2 + len;
            }
            if (opcode == 196) {
                if (code[index2 + 1] == -124) {
                    return index2 + 6;
                }
                return index2 + 4;
            }
            int index22 = (index2 & 0xFFFFFFFC) + 8;
            if (opcode == 171) {
                int npairs = ByteArray.read32bit(code, index22);
                return index22 + npairs * 8 + 4;
            }
            if (opcode == 170) {
                int low = ByteArray.read32bit(code, index22);
                int high = ByteArray.read32bit(code, index22 + 4);
                return index22 + (high - low + 1) * 4 + 8;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        throw new BadBytecode(opcode);
    }

    static byte[] insertGapCore0(byte[] code, int where, int gapLength, boolean exclusive2, ExceptionTable etable, CodeAttribute ca) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        try {
            return CodeIterator.insertGapCore1(code, where, gapLength, exclusive2, etable, ca);
        }
        catch (AlignmentException e) {
            try {
                return CodeIterator.insertGapCore1(code, where, gapLength + 3 & 0xFFFFFFFC, exclusive2, etable, ca);
            }
            catch (AlignmentException e2) {
                throw new RuntimeException("fatal error?");
            }
        }
    }

    private static byte[] insertGapCore1(byte[] code, int where, int gapLength, boolean exclusive2, ExceptionTable etable, CodeAttribute ca) throws BadBytecode, AlignmentException {
        StackMap sm;
        StackMapTable smt;
        LocalVariableAttribute vta;
        LocalVariableAttribute va;
        int codeLength = code.length;
        byte[] newcode = new byte[codeLength + gapLength];
        CodeIterator.insertGap2(code, where, gapLength, codeLength, newcode, exclusive2);
        etable.shiftPc(where, gapLength, exclusive2);
        LineNumberAttribute na = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
        if (na != null) {
            na.shiftPc(where, gapLength, exclusive2);
        }
        if ((va = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable")) != null) {
            va.shiftPc(where, gapLength, exclusive2);
        }
        if ((vta = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable")) != null) {
            vta.shiftPc(where, gapLength, exclusive2);
        }
        if ((smt = (StackMapTable)ca.getAttribute("StackMapTable")) != null) {
            smt.shiftPc(where, gapLength, exclusive2);
        }
        if ((sm = (StackMap)ca.getAttribute("StackMap")) != null) {
            sm.shiftPc(where, gapLength, exclusive2);
        }
        return newcode;
    }

    private static void insertGap2(byte[] code, int where, int gapLength, int endPos, byte[] newcode, boolean exclusive2) throws BadBytecode, AlignmentException {
        int i2 = 0;
        int j = 0;
        while (i2 < endPos) {
            int defaultbyte;
            int i22;
            int offset2;
            if (i2 == where) {
                int j2 = j + gapLength;
                while (j < j2) {
                    newcode[j++] = 0;
                }
            }
            int nextPos = CodeIterator.nextOpcode(code, i2);
            int inst = code[i2] & 0xFF;
            if (153 <= inst && inst <= 168 || inst == 198 || inst == 199) {
                offset2 = code[i2 + 1] << 8 | code[i2 + 2] & 0xFF;
                offset2 = CodeIterator.newOffset(i2, offset2, where, gapLength, exclusive2);
                newcode[j] = code[i2];
                ByteArray.write16bit(offset2, newcode, j + 1);
                j += 3;
            } else if (inst == 200 || inst == 201) {
                offset2 = ByteArray.read32bit(code, i2 + 1);
                offset2 = CodeIterator.newOffset(i2, offset2, where, gapLength, exclusive2);
                newcode[j++] = code[i2];
                ByteArray.write32bit(offset2, newcode, j);
                j += 4;
            } else if (inst == 170) {
                if (i2 != j && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i22 = (i2 & 0xFFFFFFFC) + 4;
                j = CodeIterator.copyGapBytes(newcode, j, code, i2, i22);
                defaultbyte = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i22), where, gapLength, exclusive2);
                ByteArray.write32bit(defaultbyte, newcode, j);
                int lowbyte = ByteArray.read32bit(code, i22 + 4);
                ByteArray.write32bit(lowbyte, newcode, j + 4);
                int highbyte = ByteArray.read32bit(code, i22 + 8);
                ByteArray.write32bit(highbyte, newcode, j + 8);
                j += 12;
                int i0 = i22 + 12;
                i22 = i0 + (highbyte - lowbyte + 1) * 4;
                while (i0 < i22) {
                    int offset3 = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i0), where, gapLength, exclusive2);
                    ByteArray.write32bit(offset3, newcode, j);
                    j += 4;
                    i0 += 4;
                }
            } else if (inst == 171) {
                if (i2 != j && (gapLength & 3) != 0) {
                    throw new AlignmentException();
                }
                i22 = (i2 & 0xFFFFFFFC) + 4;
                j = CodeIterator.copyGapBytes(newcode, j, code, i2, i22);
                defaultbyte = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i22), where, gapLength, exclusive2);
                ByteArray.write32bit(defaultbyte, newcode, j);
                int npairs = ByteArray.read32bit(code, i22 + 4);
                ByteArray.write32bit(npairs, newcode, j + 4);
                j += 8;
                int i0 = i22 + 8;
                i22 = i0 + npairs * 8;
                while (i0 < i22) {
                    ByteArray.copy32bit(code, i0, newcode, j);
                    int offset4 = CodeIterator.newOffset(i2, ByteArray.read32bit(code, i0 + 4), where, gapLength, exclusive2);
                    ByteArray.write32bit(offset4, newcode, j + 4);
                    j += 8;
                    i0 += 8;
                }
            } else {
                while (i2 < nextPos) {
                    newcode[j++] = code[i2++];
                }
            }
            i2 = nextPos;
        }
    }

    private static int copyGapBytes(byte[] newcode, int j, byte[] code, int i2, int iEnd) {
        switch (iEnd - i2) {
            case 4: {
                newcode[j++] = code[i2++];
            }
            case 3: {
                newcode[j++] = code[i2++];
            }
            case 2: {
                newcode[j++] = code[i2++];
            }
            case 1: {
                newcode[j++] = code[i2++];
            }
        }
        return j;
    }

    private static int newOffset(int i2, int offset2, int where, int gapLength, boolean exclusive2) {
        int target = i2 + offset2;
        if (i2 < where) {
            if (where < target || exclusive2 && where == target) {
                offset2 += gapLength;
            }
        } else if (i2 == where) {
            if (target < where) {
                offset2 -= gapLength;
            }
        } else if (target < where || !exclusive2 && where == target) {
            offset2 -= gapLength;
        }
        return offset2;
    }

    static byte[] changeLdcToLdcW(byte[] code, ExceptionTable etable, CodeAttribute ca, CodeAttribute.LdcEntry ldcs) throws BadBytecode {
        ArrayList jumps = CodeIterator.makeJumpList(code, code.length);
        while (ldcs != null) {
            CodeIterator.addLdcW(ldcs, jumps);
            ldcs = ldcs.next;
        }
        Pointers pointers = new Pointers(0, 0, 0, etable, ca);
        byte[] r = CodeIterator.insertGap2w(code, 0, 0, false, jumps, pointers);
        return r;
    }

    private static void addLdcW(CodeAttribute.LdcEntry ldcs, ArrayList jumps) {
        int where = ldcs.where;
        LdcW ldcw = new LdcW(where, ldcs.index);
        int s2 = jumps.size();
        for (int i2 = 0; i2 < s2; ++i2) {
            if (where >= ((Branch)jumps.get((int)i2)).orgPos) continue;
            jumps.add(i2, ldcw);
            return;
        }
        jumps.add(ldcw);
    }

    private byte[] insertGapCore0w(byte[] code, int where, int gapLength, boolean exclusive2, ExceptionTable etable, CodeAttribute ca, Gap newWhere) throws BadBytecode {
        if (gapLength <= 0) {
            return code;
        }
        ArrayList jumps = CodeIterator.makeJumpList(code, code.length);
        Pointers pointers = new Pointers(this.currentPos, this.mark, where, etable, ca);
        byte[] r = CodeIterator.insertGap2w(code, where, gapLength, exclusive2, jumps, pointers);
        this.currentPos = pointers.cursor;
        this.mark = pointers.mark;
        int where2 = pointers.mark0;
        if (where2 == this.currentPos && !exclusive2) {
            this.currentPos += gapLength;
        }
        if (exclusive2) {
            where2 -= gapLength;
        }
        newWhere.position = where2;
        newWhere.length = gapLength;
        return r;
    }

    private static byte[] insertGap2w(byte[] code, int where, int gapLength, boolean exclusive2, ArrayList jumps, Pointers ptrs) throws BadBytecode {
        int n = jumps.size();
        if (gapLength > 0) {
            ptrs.shiftPc(where, gapLength, exclusive2);
            for (int i2 = 0; i2 < n; ++i2) {
                ((Branch)jumps.get(i2)).shift(where, gapLength, exclusive2);
            }
        }
        boolean unstable = true;
        block1: while (true) {
            int j;
            Branch b;
            int i3;
            if (unstable) {
                unstable = false;
                i3 = 0;
                while (true) {
                    if (i3 >= n) continue block1;
                    b = (Branch)jumps.get(i3);
                    if (b.expanded()) {
                        unstable = true;
                        int p2 = b.pos;
                        int delta = b.deltaSize();
                        ptrs.shiftPc(p2, delta, false);
                        for (j = 0; j < n; ++j) {
                            ((Branch)jumps.get(j)).shift(p2, delta, false);
                        }
                    }
                    ++i3;
                }
            }
            for (i3 = 0; i3 < n; ++i3) {
                b = (Branch)jumps.get(i3);
                int diff = b.gapChanged();
                if (diff <= 0) continue;
                unstable = true;
                int p3 = b.pos;
                ptrs.shiftPc(p3, diff, false);
                for (j = 0; j < n; ++j) {
                    ((Branch)jumps.get(j)).shift(p3, diff, false);
                }
            }
            if (!unstable) break;
        }
        return CodeIterator.makeExapndedCode(code, jumps, where, gapLength);
    }

    private static ArrayList makeJumpList(byte[] code, int endPos) throws BadBytecode {
        ArrayList<Branch> jumps = new ArrayList<Branch>();
        int i2 = 0;
        while (i2 < endPos) {
            int i22;
            int offset2;
            int nextPos = CodeIterator.nextOpcode(code, i2);
            int inst = code[i2] & 0xFF;
            if (153 <= inst && inst <= 168 || inst == 198 || inst == 199) {
                offset2 = code[i2 + 1] << 8 | code[i2 + 2] & 0xFF;
                Branch16 b = inst == 167 || inst == 168 ? new Jump16(i2, offset2) : new If16(i2, offset2);
                jumps.add(b);
            } else if (inst == 200 || inst == 201) {
                offset2 = ByteArray.read32bit(code, i2 + 1);
                jumps.add(new Jump32(i2, offset2));
            } else if (inst == 170) {
                i22 = (i2 & 0xFFFFFFFC) + 4;
                int defaultbyte = ByteArray.read32bit(code, i22);
                int lowbyte = ByteArray.read32bit(code, i22 + 4);
                int highbyte = ByteArray.read32bit(code, i22 + 8);
                int i0 = i22 + 12;
                int size2 = highbyte - lowbyte + 1;
                int[] offsets2 = new int[size2];
                for (int j = 0; j < size2; ++j) {
                    offsets2[j] = ByteArray.read32bit(code, i0);
                    i0 += 4;
                }
                jumps.add(new Table(i2, defaultbyte, lowbyte, highbyte, offsets2));
            } else if (inst == 171) {
                i22 = (i2 & 0xFFFFFFFC) + 4;
                int defaultbyte = ByteArray.read32bit(code, i22);
                int npairs = ByteArray.read32bit(code, i22 + 4);
                int i0 = i22 + 8;
                int[] matches = new int[npairs];
                int[] offsets3 = new int[npairs];
                for (int j = 0; j < npairs; ++j) {
                    matches[j] = ByteArray.read32bit(code, i0);
                    offsets3[j] = ByteArray.read32bit(code, i0 + 4);
                    i0 += 8;
                }
                jumps.add(new Lookup(i2, defaultbyte, matches, offsets3));
            }
            i2 = nextPos;
        }
        return jumps;
    }

    private static byte[] makeExapndedCode(byte[] code, ArrayList jumps, int where, int gapLength) throws BadBytecode {
        int bpos;
        Branch b;
        int n = jumps.size();
        int size2 = code.length + gapLength;
        for (int i2 = 0; i2 < n; ++i2) {
            Branch b2 = (Branch)jumps.get(i2);
            size2 += b2.deltaSize();
        }
        byte[] newcode = new byte[size2];
        int src = 0;
        int dest = 0;
        int bindex = 0;
        int len = code.length;
        if (0 < n) {
            b = (Branch)jumps.get(0);
            bpos = b.orgPos;
        } else {
            b = null;
            bpos = len;
        }
        while (src < len) {
            if (src == where) {
                int pos2 = dest + gapLength;
                while (dest < pos2) {
                    newcode[dest++] = 0;
                }
            }
            if (src != bpos) {
                newcode[dest++] = code[src++];
                continue;
            }
            int s2 = b.write(src, code, dest, newcode);
            src += s2;
            dest += s2 + b.deltaSize();
            if (++bindex < n) {
                b = (Branch)jumps.get(bindex);
                bpos = b.orgPos;
                continue;
            }
            b = null;
            bpos = len;
        }
        return newcode;
    }

    static class Lookup
    extends Switcher {
        int[] matches;

        Lookup(int pos2, int defaultByte, int[] matches, int[] offsets2) {
            super(pos2, defaultByte, offsets2);
            this.matches = matches;
        }

        int write2(int dest, byte[] newcode) {
            int n = this.matches.length;
            ByteArray.write32bit(n, newcode, dest);
            dest += 4;
            for (int i2 = 0; i2 < n; ++i2) {
                ByteArray.write32bit(this.matches[i2], newcode, dest);
                ByteArray.write32bit(this.offsets[i2], newcode, dest + 4);
                dest += 8;
            }
            return 4 + 8 * n;
        }

        int tableSize() {
            return 4 + 8 * this.matches.length;
        }
    }

    static class Table
    extends Switcher {
        int low;
        int high;

        Table(int pos2, int defaultByte, int low, int high, int[] offsets2) {
            super(pos2, defaultByte, offsets2);
            this.low = low;
            this.high = high;
        }

        int write2(int dest, byte[] newcode) {
            ByteArray.write32bit(this.low, newcode, dest);
            ByteArray.write32bit(this.high, newcode, dest + 4);
            int n = this.offsets.length;
            dest += 8;
            for (int i2 = 0; i2 < n; ++i2) {
                ByteArray.write32bit(this.offsets[i2], newcode, dest);
                dest += 4;
            }
            return 8 + 4 * n;
        }

        int tableSize() {
            return 8 + 4 * this.offsets.length;
        }
    }

    static abstract class Switcher
    extends Branch {
        int gap;
        int defaultByte;
        int[] offsets;

        Switcher(int pos2, int defaultByte, int[] offsets2) {
            super(pos2);
            this.gap = 3 - (pos2 & 3);
            this.defaultByte = defaultByte;
            this.offsets = offsets2;
        }

        void shift(int where, int gapLength, boolean exclusive2) {
            int p2 = this.pos;
            this.defaultByte = Switcher.shiftOffset(p2, this.defaultByte, where, gapLength, exclusive2);
            int num = this.offsets.length;
            for (int i2 = 0; i2 < num; ++i2) {
                this.offsets[i2] = Switcher.shiftOffset(p2, this.offsets[i2], where, gapLength, exclusive2);
            }
            super.shift(where, gapLength, exclusive2);
        }

        int gapChanged() {
            int newGap = 3 - (this.pos & 3);
            if (newGap > this.gap) {
                int diff = newGap - this.gap;
                this.gap = newGap;
                return diff;
            }
            return 0;
        }

        int deltaSize() {
            return this.gap - (3 - (this.orgPos & 3));
        }

        int write(int src, byte[] code, int dest, byte[] newcode) {
            int padding = 3 - (this.pos & 3);
            int nops = this.gap - padding;
            int bytecodeSize = 5 + (3 - (this.orgPos & 3)) + this.tableSize();
            this.adjustOffsets(bytecodeSize, nops);
            newcode[dest++] = code[src];
            while (padding-- > 0) {
                newcode[dest++] = 0;
            }
            ByteArray.write32bit(this.defaultByte, newcode, dest);
            int size2 = this.write2(dest + 4, newcode);
            dest += size2 + 4;
            while (nops-- > 0) {
                newcode[dest++] = 0;
            }
            return 5 + (3 - (this.orgPos & 3)) + size2;
        }

        abstract int write2(int var1, byte[] var2);

        abstract int tableSize();

        void adjustOffsets(int size2, int nops) {
            if (this.defaultByte == size2) {
                this.defaultByte -= nops;
            }
            for (int i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2] != size2) continue;
                int n = i2;
                this.offsets[n] = this.offsets[n] - nops;
            }
        }
    }

    static class Jump32
    extends Branch {
        int offset;

        Jump32(int p2, int off) {
            super(p2);
            this.offset = off;
        }

        void shift(int where, int gapLength, boolean exclusive2) {
            this.offset = Jump32.shiftOffset(this.pos, this.offset, where, gapLength, exclusive2);
            super.shift(where, gapLength, exclusive2);
        }

        int write(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = code[src];
            ByteArray.write32bit(this.offset, newcode, dest + 1);
            return 5;
        }
    }

    static class If16
    extends Branch16 {
        If16(int p2, int off) {
            super(p2, off);
        }

        int deltaSize() {
            return this.state == 2 ? 5 : 0;
        }

        void write32(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = (byte)this.opcode(code[src] & 0xFF);
            newcode[dest + 1] = 0;
            newcode[dest + 2] = 8;
            newcode[dest + 3] = -56;
            ByteArray.write32bit(this.offset - 3, newcode, dest + 4);
        }

        int opcode(int op) {
            if (op == 198) {
                return 199;
            }
            if (op == 199) {
                return 198;
            }
            if ((op - 153 & 1) == 0) {
                return op + 1;
            }
            return op - 1;
        }
    }

    static class Jump16
    extends Branch16 {
        Jump16(int p2, int off) {
            super(p2, off);
        }

        int deltaSize() {
            return this.state == 2 ? 2 : 0;
        }

        void write32(int src, byte[] code, int dest, byte[] newcode) {
            newcode[dest] = (byte)((code[src] & 0xFF) == 167 ? 200 : 201);
            ByteArray.write32bit(this.offset, newcode, dest + 1);
        }
    }

    static abstract class Branch16
    extends Branch {
        int offset;
        int state;
        static final int BIT16 = 0;
        static final int EXPAND = 1;
        static final int BIT32 = 2;

        Branch16(int p2, int off) {
            super(p2);
            this.offset = off;
            this.state = 0;
        }

        void shift(int where, int gapLength, boolean exclusive2) {
            this.offset = Branch16.shiftOffset(this.pos, this.offset, where, gapLength, exclusive2);
            super.shift(where, gapLength, exclusive2);
            if (this.state == 0 && (this.offset < Short.MIN_VALUE || Short.MAX_VALUE < this.offset)) {
                this.state = 1;
            }
        }

        boolean expanded() {
            if (this.state == 1) {
                this.state = 2;
                return true;
            }
            return false;
        }

        abstract int deltaSize();

        abstract void write32(int var1, byte[] var2, int var3, byte[] var4);

        int write(int src, byte[] code, int dest, byte[] newcode) {
            if (this.state == 2) {
                this.write32(src, code, dest, newcode);
            } else {
                newcode[dest] = code[src];
                ByteArray.write16bit(this.offset, newcode, dest + 1);
            }
            return 3;
        }
    }

    static class LdcW
    extends Branch {
        int index;
        boolean state;

        LdcW(int p2, int i2) {
            super(p2);
            this.index = i2;
            this.state = true;
        }

        boolean expanded() {
            if (this.state) {
                this.state = false;
                return true;
            }
            return false;
        }

        int deltaSize() {
            return 1;
        }

        int write(int srcPos, byte[] code, int destPos, byte[] newcode) {
            newcode[destPos] = 19;
            ByteArray.write16bit(this.index, newcode, destPos + 1);
            return 2;
        }
    }

    static abstract class Branch {
        int pos;
        int orgPos;

        Branch(int p2) {
            this.pos = this.orgPos = p2;
        }

        void shift(int where, int gapLength, boolean exclusive2) {
            if (where < this.pos || where == this.pos && exclusive2) {
                this.pos += gapLength;
            }
        }

        static int shiftOffset(int i2, int offset2, int where, int gapLength, boolean exclusive2) {
            int target = i2 + offset2;
            if (i2 < where) {
                if (where < target || exclusive2 && where == target) {
                    offset2 += gapLength;
                }
            } else if (i2 == where) {
                if (target < where && exclusive2) {
                    offset2 -= gapLength;
                } else if (where < target && !exclusive2) {
                    offset2 += gapLength;
                }
            } else if (target < where || !exclusive2 && where == target) {
                offset2 -= gapLength;
            }
            return offset2;
        }

        boolean expanded() {
            return false;
        }

        int gapChanged() {
            return 0;
        }

        int deltaSize() {
            return 0;
        }

        abstract int write(int var1, byte[] var2, int var3, byte[] var4);
    }

    static class Pointers {
        int cursor;
        int mark0;
        int mark;
        ExceptionTable etable;
        LineNumberAttribute line;
        LocalVariableAttribute vars;
        LocalVariableAttribute types;
        StackMapTable stack;
        StackMap stack2;

        Pointers(int cur, int m, int m0, ExceptionTable et, CodeAttribute ca) {
            this.cursor = cur;
            this.mark = m;
            this.mark0 = m0;
            this.etable = et;
            this.line = (LineNumberAttribute)ca.getAttribute("LineNumberTable");
            this.vars = (LocalVariableAttribute)ca.getAttribute("LocalVariableTable");
            this.types = (LocalVariableAttribute)ca.getAttribute("LocalVariableTypeTable");
            this.stack = (StackMapTable)ca.getAttribute("StackMapTable");
            this.stack2 = (StackMap)ca.getAttribute("StackMap");
        }

        void shiftPc(int where, int gapLength, boolean exclusive2) throws BadBytecode {
            if (where < this.cursor || where == this.cursor && exclusive2) {
                this.cursor += gapLength;
            }
            if (where < this.mark || where == this.mark && exclusive2) {
                this.mark += gapLength;
            }
            if (where < this.mark0 || where == this.mark0 && exclusive2) {
                this.mark0 += gapLength;
            }
            this.etable.shiftPc(where, gapLength, exclusive2);
            if (this.line != null) {
                this.line.shiftPc(where, gapLength, exclusive2);
            }
            if (this.vars != null) {
                this.vars.shiftPc(where, gapLength, exclusive2);
            }
            if (this.types != null) {
                this.types.shiftPc(where, gapLength, exclusive2);
            }
            if (this.stack != null) {
                this.stack.shiftPc(where, gapLength, exclusive2);
            }
            if (this.stack2 != null) {
                this.stack2.shiftPc(where, gapLength, exclusive2);
            }
        }
    }

    static class AlignmentException
    extends Exception {
        AlignmentException() {
        }
    }

    public static class Gap {
        public int position;
        public int length;
    }
}

