/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.ParserType;
import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPErrorCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;

public class WrongContentLength {
    static final String contentLength = "GET / HTTP/1.0\r\nContent-Length: 5\r\n\r\nhellohello_again";

    static void test() {
        HTTPParser hTTPParser = new HTTPParser(ParserType.HTTP_REQUEST);
        ByteBuffer byteBuffer = Util.buffer(contentLength);
        Settings settings = new Settings();
        int n = hTTPParser.execute(settings, byteBuffer);
        Util.check(settings.msg_cmplt_called);
        Util.check("invalid method".equals(settings.err));
    }

    public static void main(String[] stringArray) {
        WrongContentLength.test();
    }

    static class Settings
    extends ParserSettings {
        public int bodyCount;
        public boolean msg_cmplt_called;
        public String err;

        Settings() {
            this.on_message_complete = new HTTPCallback(){

                public int cb(HTTPParser hTTPParser) {
                    Util.check(5 == Settings.this.bodyCount);
                    Settings.this.msg_cmplt_called = true;
                    return 0;
                }
            };
            this.on_body = new HTTPDataCallback(){

                public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                    Settings.this.bodyCount += n2;
                    Util.p(Util.str(byteBuffer, n, n2));
                    return 0;
                }
            };
            this.on_error = new HTTPErrorCallback(){

                public void cb(HTTPParser hTTPParser, String string2, ByteBuffer byteBuffer, int n) {
                    Settings.this.err = string2;
                }
            };
        }
    }
}

