/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPException;
import http_parser.Util;
import http_parser.lolevel.HTTPErrorCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;

public class UnitTest {
    static void p(Object object) {
        System.out.println(object);
    }

    public static void testErrorFormat() {
        String string2 = "This has an error in position 10 (the n in 'an')";
        ByteBuffer byteBuffer = ByteBuffer.wrap(string2.getBytes());
        byteBuffer.position(10);
        String string3 = "This has an error in position 10 (the n in 'an')\n..........^";
        UnitTest.check_equals(string3, Util.error("test error", byteBuffer, 0));
        string2 = "123456789A123456789B123456789C123456789D123456789E123456789F123456789G123456789H123456789I123456789J";
        byteBuffer = ByteBuffer.wrap(string2.getBytes());
        byteBuffer.position(50);
        string3 = "56789B123456789C123456789D123456789E123456789F123456789G123456789H123456\n....................................^";
        UnitTest.check_equals(string3, Util.error("test trim right and left", byteBuffer, 0));
        byteBuffer.position(5);
        string3 = "123456789A123456789B123456789C123456789D123456789E123456789F123456789G12\n.....^";
        UnitTest.check_equals(string3, Util.error("test trim right", byteBuffer, 0));
        int n = byteBuffer.limit();
        byteBuffer.limit(10);
        string3 = "123456789A\n.....^";
        UnitTest.check_equals(string3, Util.error("all before, not enough after", byteBuffer, 0));
        byteBuffer.limit(n);
        byteBuffer.position(90);
        string3 = "9C123456789D123456789E123456789F123456789G123456789H123456789I123456789J\n..............................................................^";
        UnitTest.check_equals(string3, Util.error("test trim left", byteBuffer, 10));
    }

    public static void testErrorCallback() {
        String string2 = "THis is certainly not valid HTTP";
        ByteBuffer byteBuffer = ByteBuffer.wrap(string2.getBytes());
        ParserSettings parserSettings = new ParserSettings();
        parserSettings.on_error = new HTTPErrorCallback(){

            public void cb(HTTPParser hTTPParser, String string2, ByteBuffer byteBuffer, int n) {
                throw new HTTPException(string2);
            }
        };
        HTTPParser hTTPParser = new HTTPParser();
        try {
            hTTPParser.execute(parserSettings, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            UnitTest.check_equals("Invalid HTTP method", hTTPException.getMessage());
        }
        byteBuffer = ByteBuffer.wrap("GET / HTTP 1.10000".getBytes());
        hTTPParser = new HTTPParser();
        try {
            hTTPParser.execute(parserSettings, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            UnitTest.check_equals("ridiculous http minor", hTTPException.getMessage());
        }
        ParserSettings parserSettings2 = new ParserSettings();
        byteBuffer = ByteBuffer.wrap("THis is certainly not valid HTTP".getBytes());
        hTTPParser = new HTTPParser();
        try {
            hTTPParser.execute(parserSettings2, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            UnitTest.check_equals("Invalid HTTP method", hTTPException.getMessage());
        }
        byteBuffer = ByteBuffer.wrap("GET / HTTP 1.10000".getBytes());
        hTTPParser = new HTTPParser();
        try {
            hTTPParser.execute(parserSettings2, byteBuffer);
        }
        catch (HTTPException hTTPException) {
            UnitTest.check_equals("ridiculous http minor", hTTPException.getMessage());
        }
    }

    static void check_equals(Object object, Object object2) {
        if (!object.equals(object2)) {
            throw new RuntimeException(object2 + " is supposed to be " + object);
        }
    }

    public static void test() {
        UnitTest.testErrorFormat();
        UnitTest.testErrorCallback();
    }
}

