/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.ParserType;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;

public class TestNoOverflowLongBody {
    public static void test(ParserType parserType, int n) {
        HTTPParser hTTPParser = new HTTPParser(parserType);
        ByteBuffer byteBuffer = TestNoOverflowLongBody.getBytes(parserType, n);
        int n2 = byteBuffer.limit();
        hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
        Util.check(n2 == byteBuffer.position());
        byteBuffer = Util.buffer("a");
        n2 = byteBuffer.limit();
        for (int j = 0; j != n; ++j) {
            hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
            Util.check(n2 == byteBuffer.position());
            byteBuffer.rewind();
        }
        byteBuffer = TestNoOverflowLongBody.getBytes(parserType, n);
        n2 = byteBuffer.limit();
        hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
        Util.check(n2 == byteBuffer.position());
    }

    static ByteBuffer getBytes(ParserType parserType, int n) {
        if (ParserType.HTTP_BOTH == parserType) {
            throw new RuntimeException("only HTTP_REQUEST and HTTP_RESPONSE");
        }
        String string2 = "%s\r\nConnection: Keep-Alive\r\nContent-Length: %d\r\n\r\n";
        String string3 = null;
        string3 = ParserType.HTTP_REQUEST == parserType ? String.format(string2, "GET / HTTP/1.1", n) : String.format(string2, "HTTP/1.0 200 OK", n);
        return Util.buffer(string3);
    }

    public static void test() {
        TestNoOverflowLongBody.test(ParserType.HTTP_REQUEST, 1000);
        TestNoOverflowLongBody.test(ParserType.HTTP_REQUEST, 100000);
        TestNoOverflowLongBody.test(ParserType.HTTP_RESPONSE, 1000);
        TestNoOverflowLongBody.test(ParserType.HTTP_RESPONSE, 100000);
    }
}

