/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.ParserType;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.Message;
import http_parser.lolevel.TestLoaderNG;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;

public class Requests {
    static void test_simple(String string2, boolean bl) {
        HTTPParser hTTPParser = new HTTPParser(ParserType.HTTP_REQUEST);
        ByteBuffer byteBuffer = Util.buffer(string2);
        boolean bl2 = false;
        int n = 0;
        try {
            hTTPParser.execute(Util.SETTINGS_NULL, byteBuffer);
            bl2 = n == string2.length();
            n = hTTPParser.execute(Util.SETTINGS_NULL, Util.empty());
            bl2 &= 0 == n;
        }
        catch (Throwable throwable) {
            bl2 = false;
        }
        Util.check(bl2 == bl);
    }

    static void simple_tests() {
        Requests.test_simple("hello world", false);
        Requests.test_simple("GET / HTP/1.1\r\n\r\n", false);
        Requests.test_simple("ASDF / HTTP/1.1\r\n\r\n", false);
        Requests.test_simple("PROPPATCHA / HTTP/1.1\r\n\r\n", false);
        Requests.test_simple("GETA / HTTP/1.1\r\n\r\n", false);
    }

    public static void test() {
        Requests.simple_tests();
        List<Message> list2 = TestLoaderNG.load("tests.dumped");
        LinkedList<Message> linkedList = new LinkedList<Message>();
        for (Message message2 : list2) {
            if (ParserType.HTTP_REQUEST != message2.type) continue;
            linkedList.add(message2);
        }
        for (Message message2 : linkedList) {
            Util.test_message(message2);
        }
        for (int j = 0; j != linkedList.size(); ++j) {
            if (!((Message)linkedList.get((int)j)).should_keep_alive) continue;
            for (int k = 0; k != linkedList.size(); ++k) {
                if (!((Message)linkedList.get((int)k)).should_keep_alive) continue;
                for (int i2 = 0; i2 != linkedList.size(); ++i2) {
                    Util.test_multiple3((Message)linkedList.get(j), (Message)linkedList.get(k), (Message)linkedList.get(i2));
                }
            }
        }
    }
}

