/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPMethod;
import http_parser.ParserType;
import http_parser.lolevel.HTTPCallback;
import http_parser.lolevel.HTTPDataCallback;
import http_parser.lolevel.HTTPParser;
import http_parser.lolevel.ParserSettings;
import http_parser.lolevel.TestLoaderNG;
import http_parser.lolevel.Util;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Message {
    String name;
    byte[] raw;
    ParserType type;
    HTTPMethod method;
    int status_code;
    String request_path;
    String request_url;
    String fragment;
    String query_string;
    byte[] body;
    int body_size;
    int num_headers;
    TestLoaderNG.LastHeader last_header_element;
    Map<String, String> header = new HashMap<String, String>();
    List<TestLoaderNG.Header> headers = new LinkedList<TestLoaderNG.Header>();
    boolean should_keep_alive;
    boolean upgrade;
    int http_major;
    int http_minor;
    boolean message_begin_called;
    boolean headers_complete_called;
    boolean message_complete_called;
    boolean message_complete_on_eof;
    Map<String, String> parsed_header;
    String currHField;
    String currHValue;
    byte[] pbody;
    int num_called;

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type: ");
        stringBuilder.append((Object)this.type);
        stringBuilder.append("\n");
        stringBuilder.append("method: ");
        stringBuilder.append((Object)this.method);
        stringBuilder.append("\n");
        stringBuilder.append("status_code: ");
        stringBuilder.append(this.status_code);
        stringBuilder.append("\n");
        stringBuilder.append("request_path: ");
        stringBuilder.append(this.request_path);
        stringBuilder.append("\n");
        stringBuilder.append("request_url: ");
        stringBuilder.append(this.request_url);
        stringBuilder.append("\n");
        stringBuilder.append("fragment: ");
        stringBuilder.append(this.fragment);
        stringBuilder.append("\n");
        stringBuilder.append("query_string: ");
        stringBuilder.append(this.query_string);
        stringBuilder.append("\n");
        stringBuilder.append("body:\n");
        stringBuilder.append(new String(this.body));
        stringBuilder.append("\n");
        stringBuilder.append("should_keep_alive: ");
        stringBuilder.append(this.should_keep_alive);
        stringBuilder.append("\n");
        stringBuilder.append("upgrade: ");
        stringBuilder.append(this.upgrade);
        stringBuilder.append("\n");
        stringBuilder.append("http_major: ");
        stringBuilder.append(this.http_major);
        stringBuilder.append("\n");
        stringBuilder.append("http_minor: ");
        stringBuilder.append(this.http_minor);
        stringBuilder.append("\n");
        stringBuilder.append("message_complete_called: ");
        stringBuilder.append(this.message_complete_called);
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    Message() {
        this.reset();
    }

    void reset() {
        this.parsed_header = new HashMap<String, String>();
        this.pbody = null;
        this.num_called = 0;
    }

    void check(boolean bl, String string2) {
        if (!bl) {
            throw new RuntimeException(this.name + " : " + string2);
        }
    }

    HTTPDataCallback getCB(String string2, final String string3, final TestLoaderNG.TestSettings testSettings) {
        return new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                String string2 = Util.str(byteBuffer, n, n2);
                String string32 = testSettings.map.get(string3);
                testSettings.map.put(string3, string32 + string2);
                if (-1 == n) {
                    throw new RuntimeException("he?");
                }
                return 0;
            }
        };
    }

    void execute() {
        Message.p(this.name);
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.raw);
        HTTPParser hTTPParser = new HTTPParser();
        TestLoaderNG.TestSettings testSettings = this.settings();
        hTTPParser.execute(testSettings, byteBuffer);
        if (!testSettings.success) {
            throw new RuntimeException("Test: " + this.name + "failed");
        }
    }

    void execute_permutations() {
        Message.p(this.name);
        for (int j = 2; j != this.raw.length; ++j) {
            HTTPParser hTTPParser = new HTTPParser();
            TestLoaderNG.TestSettings testSettings = this.settings();
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.raw);
            int n = byteBuffer.limit();
            byteBuffer.limit(j);
            this.parse(hTTPParser, testSettings, byteBuffer);
            byteBuffer.position(j);
            byteBuffer.limit(n);
            this.parse(hTTPParser, testSettings, byteBuffer);
            this.parse(hTTPParser, testSettings, byteBuffer);
            if (!testSettings.success) {
                Message.p(this);
                throw new RuntimeException("Test: " + this.name + " failed");
            }
            this.reset();
        }
    }

    void parse(HTTPParser hTTPParser, ParserSettings parserSettings, ByteBuffer byteBuffer) {
        hTTPParser.execute(parserSettings, byteBuffer);
    }

    TestLoaderNG.TestSettings settings() {
        final TestLoaderNG.TestSettings testSettings = new TestLoaderNG.TestSettings();
        testSettings.on_path = this.getCB(this.request_path, "path", testSettings);
        testSettings.on_query_string = this.getCB(this.query_string, "query_string", testSettings);
        testSettings.on_url = this.getCB(this.request_url, "url", testSettings);
        testSettings.on_fragment = this.getCB(this.fragment, "fragment", testSettings);
        testSettings.on_message_begin = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.message_begin_called = true;
                return -1;
            }
        };
        testSettings.on_header_field = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                if (null != Message.this.currHValue && null == Message.this.currHField) {
                    throw new RuntimeException(Message.this.name + ": shouldn't happen");
                }
                if (null != Message.this.currHField) {
                    if (null == Message.this.currHValue) {
                        Message.this.currHField = Message.this.currHField + Util.str(byteBuffer, n, n2);
                        return 0;
                    }
                    Message.this.parsed_header.put(Message.this.currHField, Message.this.currHValue);
                    Message.this.currHField = null;
                    Message.this.currHValue = null;
                }
                Message.this.currHField = Util.str(byteBuffer, n, n2);
                return 0;
            }
        };
        testSettings.on_header_value = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                if (null == Message.this.currHField) {
                    throw new RuntimeException(Message.this.name + " :shouldn't happen field");
                }
                Message.this.currHValue = null == Message.this.currHValue ? Util.str(byteBuffer, n, n2) : Message.this.currHValue + Util.str(byteBuffer, n, n2);
                return 0;
            }
        };
        testSettings.on_headers_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.headers_complete_called = true;
                String string2 = testSettings.map.get("path");
                String string3 = testSettings.map.get("query_string");
                String string4 = testSettings.map.get("url");
                String string5 = testSettings.map.get("fragment");
                if (!Message.this.request_path.equals(string2)) {
                    throw new RuntimeException(Message.this.name + ": invalid path: " + string2 + " should be: " + Message.this.request_path);
                }
                if (!Message.this.query_string.equals(string3)) {
                    throw new RuntimeException(Message.this.name + ": invalid query: " + string3 + " should be: " + Message.this.query_string);
                }
                if (!Message.this.request_url.equals(string4)) {
                    throw new RuntimeException(">" + Message.this.name + "<: invalid url: >" + string4 + "< should be: >" + Message.this.request_url + "<");
                }
                if (!Message.this.fragment.equals(string5)) {
                    throw new RuntimeException(Message.this.name + ": invalid fragement: " + string5 + " should be: " + Message.this.fragment);
                }
                if (!(null == Message.this.currHValue && null == Message.this.currHField || null != Message.this.currHField && null != Message.this.currHValue)) {
                    throw new RuntimeException("shouldn't happen");
                }
                if (null != Message.this.currHField) {
                    Message.this.parsed_header.put(Message.this.currHField, Message.this.currHValue);
                    Message.this.currHField = null;
                    Message.this.currHValue = null;
                }
                return 0;
            }
        };
        testSettings.on_body = new HTTPDataCallback(){

            public int cb(HTTPParser hTTPParser, ByteBuffer byteBuffer, int n, int n2) {
                int n3 = Message.this.pbody == null ? n2 : n2 + Message.this.pbody.length;
                int n4 = Message.this.pbody == null ? 0 : Message.this.pbody.length;
                byte[] byArray = new byte[n3];
                if (null != Message.this.pbody) {
                    System.arraycopy(Message.this.pbody, 0, byArray, 0, Message.this.pbody.length);
                }
                int n5 = byteBuffer.position();
                byteBuffer.position(n);
                byteBuffer.get(byArray, n4, n2);
                byteBuffer.position(n5);
                Message.this.pbody = byArray;
                return 0;
            }
        };
        testSettings.on_message_complete = new HTTPCallback(){

            public int cb(HTTPParser hTTPParser) {
                Message.this.message_complete_called = true;
                ++Message.this.num_called;
                if (hTTPParser.http_minor != Message.this.http_minor || hTTPParser.http_major != Message.this.http_major || hTTPParser.status_code != Message.this.status_code) {
                    throw new RuntimeException("major/minor/status_code mismatch");
                }
                if (Message.this.header.keySet().size() != Message.this.parsed_header.keySet().size()) {
                    Message.p(Message.this.parsed_header);
                    throw new RuntimeException(Message.this.name + ": different amount of headers");
                }
                for (String string2 : Message.this.header.keySet()) {
                    String string3 = Message.this.parsed_header.get(string2);
                    if (Message.this.header.get(string2).equals(string3)) continue;
                    throw new RuntimeException(Message.this.name + " : different values for :" + string2 + " is >" + string3 + "< should: >" + Message.this.header.get(string2) + "<");
                }
                if (null == Message.this.pbody && (null == Message.this.body || Message.this.body.length == 0 || Message.this.body.length == 1)) {
                    testSettings.success = true;
                    return 0;
                }
                if (null == Message.this.pbody) {
                    throw new RuntimeException(Message.this.name + ": no body, should be: " + new String(Message.this.body));
                }
                if (Message.this.pbody.length != Message.this.body.length) {
                    Message.p(Message.this.pbody.length);
                    Message.p(Message.this.body.length);
                    Message.p(new String(Message.this.pbody));
                    Message.p(new String(Message.this.body));
                    throw new RuntimeException(Message.this.name + ": incorrect body length");
                }
                for (int j = 0; j != Message.this.body.length; ++j) {
                    if (Message.this.pbody[j] == Message.this.body[j]) continue;
                    throw new RuntimeException("different body");
                }
                testSettings.success = true;
                return 0;
            }
        };
        return testSettings;
    }

    static void p(Object object) {
        System.out.println(object);
    }
}

