/*
 * Decompiled with CFR 0.152.
 */
package http_parser.lolevel;

import http_parser.HTTPException;
import http_parser.HTTPMethod;
import http_parser.ParserType;
import http_parser.lolevel.ParserSettings;
import java.nio.ByteBuffer;

public class HTTPParser {
    ParserType type;
    State state;
    HState header_state;
    boolean strict;
    int index;
    int flags;
    int nread;
    int content_length;
    int start_position;
    ByteBuffer data;
    public int http_major;
    public int http_minor;
    public int status_code;
    public HTTPMethod method;
    public boolean upgrade;
    int header_field_mark = -1;
    int header_value_mark = -1;
    int fragment_mark = -1;
    int query_string_mark = -1;
    int path_mark = -1;
    int url_mark = -1;
    public boolean HTTP_PARSER_STRICT;

    public HTTPParser() {
        this(ParserType.HTTP_BOTH);
    }

    public HTTPParser(ParserType parserType) {
        this.type = parserType;
        switch (parserType) {
            case HTTP_REQUEST: {
                this.state = State.start_req;
                break;
            }
            case HTTP_RESPONSE: {
                this.state = State.start_res;
                break;
            }
            case HTTP_BOTH: {
                this.state = State.start_res_or_res;
                break;
            }
            default: {
                throw new HTTPException("can't happen, invalid ParserType enum");
            }
        }
    }

    static void p(Object object) {
        System.out.println(object);
    }

    public int execute(ParserSettings parserSettings, ByteBuffer byteBuffer) {
        int n;
        int n2 = n = byteBuffer.position();
        this.start_position = n;
        this.data = byteBuffer;
        int n3 = byteBuffer.limit() - byteBuffer.position();
        if (0 == n3) {
            switch (this.state) {
                case body_identity_eof: {
                    parserSettings.call_on_message_complete(this);
                    return byteBuffer.position() - this.start_position;
                }
                case dead: 
                case start_res_or_res: 
                case start_res: 
                case start_req: {
                    return byteBuffer.position() - this.start_position;
                }
            }
            throw new HTTPException("empty bytes! " + (Object)((Object)this.state));
        }
        switch (this.state) {
            case header_field: {
                this.header_field_mark = n;
                break;
            }
            case header_value: {
                this.header_value_mark = n;
                break;
            }
            case req_fragment: {
                this.fragment_mark = n;
                this.url_mark = n;
                break;
            }
            case req_query_string: {
                this.query_string_mark = n;
                this.url_mark = n;
                break;
            }
            case req_path: {
                this.path_mark = n;
            }
            case req_host: 
            case req_schema: 
            case req_schema_slash: 
            case req_schema_slash_slash: 
            case req_port: 
            case req_query_string_start: 
            case req_fragment_start: {
                this.url_mark = n;
            }
        }
        block163: while (byteBuffer.position() != byteBuffer.limit()) {
            n = byteBuffer.position();
            int n4 = byteBuffer.limit();
            byte by = byteBuffer.get();
            int n5 = by & 0xFF;
            int n6 = -1;
            int n7 = 0;
            if (this.parsing_header(this.state)) {
                ++this.nread;
                if (this.nread > 81920) {
                    parserSettings.call_on_error(this, "possible buffer overflow", byteBuffer, n2);
                    return this.error();
                }
            }
            block12 : switch (this.state) {
                case dead: {
                    parserSettings.call_on_error(this, "Connection already closed", byteBuffer, n2);
                    return this.error();
                }
                case start_res_or_res: {
                    if (13 == by) continue block163;
                    if (10 == by) break;
                    this.flags = 0;
                    this.content_length = -1;
                    parserSettings.call_on_message_begin(this);
                    if (72 == by) {
                        this.state = State.res_or_resp_H;
                        break;
                    }
                    this.type = ParserType.HTTP_REQUEST;
                    this.method = this.start_req_method_assign(by);
                    if (null == this.method) {
                        parserSettings.call_on_error(this, "invalid method", byteBuffer, n2);
                        return this.error();
                    }
                    this.index = 1;
                    this.state = State.req_method;
                    break;
                }
                case res_or_resp_H: {
                    if (84 == by) {
                        this.type = ParserType.HTTP_RESPONSE;
                        this.state = State.res_HT;
                        break;
                    }
                    if (69 != by) {
                        parserSettings.call_on_error(this, "not E", byteBuffer, n2);
                        return this.error();
                    }
                    this.type = ParserType.HTTP_REQUEST;
                    this.method = HTTPMethod.HTTP_HEAD;
                    this.index = 2;
                    this.state = State.req_method;
                    break;
                }
                case start_res: {
                    this.flags = 0;
                    this.content_length = -1;
                    parserSettings.call_on_message_begin(this);
                    switch (by) {
                        case 72: {
                            this.state = State.res_H;
                            break block12;
                        }
                        case 10: 
                        case 13: {
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "Not H or CR/LF", byteBuffer, n2);
                    return this.error();
                }
                case res_H: {
                    if (this.strict && 84 != by) {
                        parserSettings.call_on_error(this, "Not T", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.res_HT;
                    break;
                }
                case res_HT: {
                    if (this.strict && 84 != by) {
                        parserSettings.call_on_error(this, "Not T2", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.res_HTT;
                    break;
                }
                case res_HTT: {
                    if (this.strict && 80 != by) {
                        parserSettings.call_on_error(this, "Not P", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.res_HTTP;
                    break;
                }
                case res_HTTP: {
                    if (this.strict && 47 != by) {
                        parserSettings.call_on_error(this, "Not '/'", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.res_first_http_major;
                    break;
                }
                case res_first_http_major: {
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "Not a digit", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_major = by - 48;
                    this.state = State.res_http_major;
                    break;
                }
                case res_http_major: {
                    if (46 == by) {
                        this.state = State.res_first_http_minor;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "Not a digit", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_major *= 10;
                    this.http_major += by - 48;
                    if (this.http_major <= 999) continue block163;
                    parserSettings.call_on_error(this, "invalid http major version: " + this.http_major, byteBuffer, n2);
                    return this.error();
                }
                case res_first_http_minor: {
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "Not a digit", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_minor = by - 48;
                    this.state = State.res_http_minor;
                    break;
                }
                case res_http_minor: {
                    if (32 == by) {
                        this.state = State.res_first_status_code;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "Not a digit", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_minor *= 10;
                    this.http_minor += by - 48;
                    if (this.http_minor <= 999) continue block163;
                    parserSettings.call_on_error(this, "invalid http minor version: " + this.http_minor, byteBuffer, n2);
                    return this.error();
                }
                case res_first_status_code: {
                    if (!this.isDigit(by)) {
                        if (32 == by) break;
                        parserSettings.call_on_error(this, "Not a digit (status code)", byteBuffer, n2);
                        return this.error();
                    }
                    this.status_code = by - 48;
                    this.state = State.res_status_code;
                    break;
                }
                case res_status_code: {
                    if (!this.isDigit(by)) {
                        switch (by) {
                            case 32: {
                                this.state = State.res_status;
                                break block12;
                            }
                            case 13: {
                                this.state = State.res_line_almost_done;
                                break block12;
                            }
                            case 10: {
                                this.state = State.header_field_start;
                                break block12;
                            }
                        }
                        parserSettings.call_on_error(this, "not a valid status code", byteBuffer, n2);
                        return this.error();
                    }
                    this.status_code *= 10;
                    this.status_code += by - 48;
                    if (this.status_code <= 999) continue block163;
                    parserSettings.call_on_error(this, "ridiculous status code:" + this.status_code, byteBuffer, n2);
                    return this.error();
                }
                case res_status: {
                    if (13 == by) {
                        this.state = State.res_line_almost_done;
                        break;
                    }
                    if (10 != by) continue block163;
                    this.state = State.header_field_start;
                    break;
                }
                case res_line_almost_done: {
                    if (this.strict && 10 != by) {
                        parserSettings.call_on_error(this, "not LF", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.header_field_start;
                    break;
                }
                case start_req: {
                    if (13 == by) continue block163;
                    if (10 == by) break;
                    this.flags = 0;
                    this.content_length = -1;
                    parserSettings.call_on_message_begin(this);
                    this.method = this.start_req_method_assign(by);
                    if (null == this.method) {
                        parserSettings.call_on_error(this, "invalid method", byteBuffer, n2);
                        return this.error();
                    }
                    this.index = 1;
                    this.state = State.req_method;
                    break;
                }
                case req_method: {
                    if (0 == by) {
                        parserSettings.call_on_error(this, "NULL in method", byteBuffer, n2);
                        return this.error();
                    }
                    byte[] byArray = this.method.bytes;
                    if (32 == by && this.index == byArray.length) {
                        this.state = State.req_spaces_before_url;
                    } else if (byArray[this.index] != by) {
                        if (HTTPMethod.HTTP_CONNECT == this.method) {
                            if (1 == this.index && 72 == by) {
                                this.method = HTTPMethod.HTTP_CHECKOUT;
                            } else if (2 == this.index && 80 == by) {
                                this.method = HTTPMethod.HTTP_COPY;
                            }
                        } else if (HTTPMethod.HTTP_MKCOL == this.method) {
                            if (1 == this.index && 79 == by) {
                                this.method = HTTPMethod.HTTP_MOVE;
                            } else if (1 == this.index && 69 == by) {
                                this.method = HTTPMethod.HTTP_MERGE;
                            } else if (1 == this.index && 45 == by) {
                                this.method = HTTPMethod.HTTP_MSEARCH;
                            } else if (2 == this.index && 65 == by) {
                                this.method = HTTPMethod.HTTP_MKACTIVITY;
                            }
                        } else if (1 == this.index && HTTPMethod.HTTP_POST == this.method && 82 == by) {
                            this.method = HTTPMethod.HTTP_PROPFIND;
                        } else if (1 == this.index && HTTPMethod.HTTP_POST == this.method && 85 == by) {
                            this.method = HTTPMethod.HTTP_PUT;
                        } else if (2 == this.index && HTTPMethod.HTTP_UNLOCK == this.method && 83 == by) {
                            this.method = HTTPMethod.HTTP_UNSUBSCRIBE;
                        } else if (4 == this.index && HTTPMethod.HTTP_PROPFIND == this.method && 80 == by) {
                            this.method = HTTPMethod.HTTP_PROPPATCH;
                        } else {
                            parserSettings.call_on_error(this, "Invalid HTTP method", byteBuffer, n2);
                            return this.error();
                        }
                    }
                    ++this.index;
                    break;
                }
                case req_spaces_before_url: {
                    if (32 == by) break;
                    if (47 == by || 42 == by) {
                        this.url_mark = n;
                        this.path_mark = n;
                        this.state = State.req_path;
                        break;
                    }
                    if (this.isAtoZ(by)) {
                        this.url_mark = n;
                        this.state = State.req_schema;
                        break;
                    }
                    parserSettings.call_on_error(this, "Invalid something", byteBuffer, n2);
                    return this.error();
                }
                case req_schema: {
                    if (this.isAtoZ(by)) break;
                    if (58 == by) {
                        this.state = State.req_schema_slash;
                        break;
                    }
                    if (46 == by || this.isDigit(by)) {
                        this.state = State.req_host;
                        break;
                    }
                    parserSettings.call_on_error(this, "invalid char in schema: " + by, byteBuffer, n2);
                    return this.error();
                }
                case req_schema_slash: {
                    if (this.strict && 47 != by) {
                        parserSettings.call_on_error(this, "invalid char in schema, not /", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_schema_slash_slash;
                    break;
                }
                case req_schema_slash_slash: {
                    if (this.strict && 47 != by) {
                        parserSettings.call_on_error(this, "invalid char in schema, not /", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_host;
                    break;
                }
                case req_host: {
                    if (this.isAtoZ(by)) break;
                    if (this.isDigit(by) || 46 == by) continue block163;
                    if (45 == by) break;
                    switch (by) {
                        case 58: {
                            this.state = State.req_port;
                            break block12;
                        }
                        case 47: {
                            this.path_mark = n;
                            break block12;
                        }
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 63: {
                            this.state = State.req_query_string_start;
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "host error in method line", byteBuffer, n2);
                    return this.error();
                }
                case req_port: {
                    if (this.isDigit(by)) break;
                    switch (by) {
                        case 47: {
                            this.path_mark = n;
                            this.state = State.req_path;
                            break block12;
                        }
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 63: {
                            this.state = State.req_query_string_start;
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "invalid port", byteBuffer, n2);
                    return this.error();
                }
                case req_path: {
                    if (C.normal_url_char[n5]) break;
                    switch (by) {
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
                            this.path_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 13: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
                            this.path_mark = -1;
                            this.http_minor = 9;
                            this.state = State.res_line_almost_done;
                            break block12;
                        }
                        case 10: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
                            this.path_mark = -1;
                            this.http_minor = 9;
                            this.state = State.header_field_start;
                            break block12;
                        }
                        case 63: {
                            parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
                            this.path_mark = -1;
                            this.state = State.req_query_string_start;
                            break block12;
                        }
                        case 35: {
                            parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
                            this.path_mark = -1;
                            this.state = State.req_fragment_start;
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "unexpected char in path", byteBuffer, n2);
                    return this.error();
                }
                case req_query_string_start: {
                    if (C.normal_url_char[n5]) {
                        this.query_string_mark = n;
                        this.state = State.req_query_string;
                        break;
                    }
                    switch (by) {
                        case 63: {
                            break block12;
                        }
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 13: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.http_minor = 9;
                            this.state = State.res_line_almost_done;
                            break block12;
                        }
                        case 10: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.http_minor = 9;
                            this.state = State.header_field_start;
                            break block12;
                        }
                        case 35: {
                            this.state = State.req_fragment_start;
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "unexpected char in path", byteBuffer, n2);
                    return this.error();
                }
                case req_query_string: {
                    if (C.normal_url_char[n5]) break;
                    switch (by) {
                        case 63: {
                            break block12;
                        }
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_query_string(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.query_string_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 13: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_query_string(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.query_string_mark = -1;
                            this.http_minor = 9;
                            this.state = State.res_line_almost_done;
                            break block12;
                        }
                        case 10: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_query_string(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.query_string_mark = -1;
                            this.http_minor = 9;
                            this.state = State.header_field_start;
                            break block12;
                        }
                        case 35: {
                            parserSettings.call_on_query_string(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.query_string_mark = -1;
                            this.state = State.req_fragment_start;
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "unexpected char in path", byteBuffer, n2);
                    return this.error();
                }
                case req_fragment_start: {
                    if (C.normal_url_char[n5]) {
                        this.fragment_mark = n;
                        this.state = State.req_fragment;
                        break;
                    }
                    switch (by) {
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 13: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.http_minor = 9;
                            this.state = State.res_line_almost_done;
                            break block12;
                        }
                        case 10: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            this.http_minor = 9;
                            this.state = State.header_field_start;
                            break block12;
                        }
                        case 63: {
                            this.fragment_mark = n;
                            this.state = State.req_fragment;
                            break block12;
                        }
                        case 35: {
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "unexpected char in path", byteBuffer, n2);
                    return this.error();
                }
                case req_fragment: {
                    if (C.normal_url_char[n5]) break;
                    switch (by) {
                        case 32: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_fragment(this, byteBuffer, this.fragment_mark, n - this.fragment_mark);
                            this.fragment_mark = -1;
                            this.state = State.req_http_start;
                            break block12;
                        }
                        case 13: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_fragment(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.fragment_mark = -1;
                            this.http_minor = 9;
                            this.state = State.res_line_almost_done;
                            break block12;
                        }
                        case 10: {
                            parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
                            this.url_mark = -1;
                            parserSettings.call_on_fragment(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
                            this.fragment_mark = -1;
                            this.http_minor = 9;
                            this.state = State.header_field_start;
                            break block12;
                        }
                        case 35: 
                        case 63: {
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "unexpected char in path", byteBuffer, n2);
                    return this.error();
                }
                case req_http_start: {
                    switch (by) {
                        case 72: {
                            this.state = State.req_http_H;
                            break block12;
                        }
                        case 32: {
                            break block12;
                        }
                    }
                    parserSettings.call_on_error(this, "error in req_http_H", byteBuffer, n2);
                    return this.error();
                }
                case req_http_H: {
                    if (this.strict && 84 != by) {
                        parserSettings.call_on_error(this, "unexpected char", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_http_HT;
                    break;
                }
                case req_http_HT: {
                    if (this.strict && 84 != by) {
                        parserSettings.call_on_error(this, "unexpected char", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_http_HTT;
                    break;
                }
                case req_http_HTT: {
                    if (this.strict && 80 != by) {
                        parserSettings.call_on_error(this, "unexpected char", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_http_HTTP;
                    break;
                }
                case req_http_HTTP: {
                    if (this.strict && 47 != by) {
                        parserSettings.call_on_error(this, "unexpected char", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.req_first_http_major;
                    break;
                }
                case req_first_http_major: {
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "non digit in http major", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_major = by - 48;
                    this.state = State.req_http_major;
                    break;
                }
                case req_http_major: {
                    if (46 == by) {
                        this.state = State.req_first_http_minor;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "non digit in http major", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_major *= 10;
                    this.http_major += by - 48;
                    if (this.http_major <= 999) continue block163;
                    parserSettings.call_on_error(this, "ridiculous http major", byteBuffer, n2);
                    return this.error();
                }
                case req_first_http_minor: {
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "non digit in http minor", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_minor = by - 48;
                    this.state = State.req_http_minor;
                    break;
                }
                case req_http_minor: {
                    if (by == 13) {
                        this.state = State.req_line_almost_done;
                        break;
                    }
                    if (by == 10) {
                        this.state = State.header_field_start;
                        break;
                    }
                    if (!this.isDigit(by)) {
                        parserSettings.call_on_error(this, "non digit in http minor", byteBuffer, n2);
                        return this.error();
                    }
                    this.http_minor *= 10;
                    this.http_minor += by - 48;
                    if (this.http_minor <= 999) continue block163;
                    parserSettings.call_on_error(this, "ridiculous http minor", byteBuffer, n2);
                    return this.error();
                }
                case req_line_almost_done: {
                    if (by != 10) {
                        parserSettings.call_on_error(this, "missing LF after request line", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.header_field_start;
                    break;
                }
                case header_field_start: {
                    if (by == 13) {
                        this.state = State.headers_almost_done;
                        break;
                    }
                    if (by == 10) {
                        this.state = State.headers_almost_done;
                        if (!this.headers_almost_done(by, parserSettings)) {
                            parserSettings.call_on_error(this, "header not properly completed", byteBuffer, n2);
                            return this.error();
                        }
                        if (!this.upgrade) continue block163;
                        return byteBuffer.position() - this.start_position;
                    }
                    n6 = this.token(by);
                    if (0 == n6) {
                        parserSettings.call_on_error(this, "invalid char in header:" + n6, byteBuffer, n2);
                        return this.error();
                    }
                    this.header_field_mark = n;
                    this.index = 0;
                    this.state = State.header_field;
                    switch (n6) {
                        case 67: {
                            this.header_state = HState.C;
                            break block12;
                        }
                        case 80: {
                            this.header_state = HState.matching_proxy_connection;
                            break block12;
                        }
                        case 84: {
                            this.header_state = HState.matching_transfer_encoding;
                            break block12;
                        }
                        case 85: {
                            this.header_state = HState.matching_upgrade;
                            break block12;
                        }
                    }
                    this.header_state = HState.general;
                    break;
                }
                case header_field: {
                    n6 = this.token(by);
                    if (0 != n6) {
                        switch (this.header_state) {
                            case general: {
                                break block12;
                            }
                            case C: {
                                ++this.index;
                                this.header_state = 79 == n6 ? HState.CO : HState.general;
                                break block12;
                            }
                            case CO: {
                                ++this.index;
                                this.header_state = 78 == n6 ? HState.CON : HState.general;
                                break block12;
                            }
                            case CON: {
                                ++this.index;
                                switch (n6) {
                                    case 78: {
                                        this.header_state = HState.matching_connection;
                                        break block12;
                                    }
                                    case 84: {
                                        this.header_state = HState.matching_content_length;
                                        break block12;
                                    }
                                }
                                this.header_state = HState.general;
                                break block12;
                            }
                            case matching_connection: {
                                ++this.index;
                                if (this.index > C.CONNECTION.length || n6 != C.CONNECTION[this.index]) {
                                    this.header_state = HState.general;
                                    break block12;
                                }
                                if (this.index != C.CONNECTION.length - 1) continue block163;
                                this.header_state = HState.connection;
                                break block12;
                            }
                            case matching_proxy_connection: {
                                ++this.index;
                                if (this.index > C.PROXY_CONNECTION.length || n6 != C.PROXY_CONNECTION[this.index]) {
                                    this.header_state = HState.general;
                                    break block12;
                                }
                                if (this.index != C.PROXY_CONNECTION.length - 1) continue block163;
                                this.header_state = HState.connection;
                                break block12;
                            }
                            case matching_content_length: {
                                ++this.index;
                                if (this.index > C.CONTENT_LENGTH.length || n6 != C.CONTENT_LENGTH[this.index]) {
                                    this.header_state = HState.general;
                                    break block12;
                                }
                                if (this.index != C.CONTENT_LENGTH.length - 1) continue block163;
                                this.header_state = HState.content_length;
                                break block12;
                            }
                            case matching_transfer_encoding: {
                                ++this.index;
                                if (this.index > C.TRANSFER_ENCODING.length || n6 != C.TRANSFER_ENCODING[this.index]) {
                                    this.header_state = HState.general;
                                    break block12;
                                }
                                if (this.index != C.TRANSFER_ENCODING.length - 1) continue block163;
                                this.header_state = HState.transfer_encoding;
                                break block12;
                            }
                            case matching_upgrade: {
                                ++this.index;
                                if (this.index > C.UPGRADE.length || n6 != C.UPGRADE[this.index]) {
                                    this.header_state = HState.general;
                                    break block12;
                                }
                                if (this.index != C.UPGRADE.length - 1) continue block163;
                                this.header_state = HState.upgrade;
                                break block12;
                            }
                            case connection: 
                            case content_length: 
                            case transfer_encoding: 
                            case upgrade: {
                                if (32 == by) continue block163;
                                this.header_state = HState.general;
                                break block12;
                            }
                        }
                        parserSettings.call_on_error(this, "Unknown Header State", byteBuffer, n2);
                        return this.error();
                    }
                    if (58 == by) {
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        this.state = State.header_value_start;
                        break;
                    }
                    if (13 == by) {
                        this.state = State.header_almost_done;
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        break;
                    }
                    if (by == 10) {
                        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
                        this.header_field_mark = -1;
                        this.state = State.header_field_start;
                        break;
                    }
                    parserSettings.call_on_error(this, "invalid header field", byteBuffer, n2);
                    return this.error();
                }
                case header_value_start: {
                    if (32 == by) break;
                    this.header_value_mark = n;
                    this.state = State.header_value;
                    this.index = 0;
                    if (13 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.header_state = HState.general;
                        this.state = State.header_almost_done;
                        break;
                    }
                    if (10 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.state = State.header_field_start;
                        break;
                    }
                    n6 = this.upper(by);
                    switch (this.header_state) {
                        case upgrade: {
                            this.flags |= 0x10;
                            this.header_state = HState.general;
                            break block12;
                        }
                        case transfer_encoding: {
                            if (67 == n6) {
                                this.header_state = HState.matching_transfer_encoding_chunked;
                                break block12;
                            }
                            this.header_state = HState.general;
                            break block12;
                        }
                        case content_length: {
                            if (!this.isDigit(by)) {
                                parserSettings.call_on_error(this, "Content-Length not numeric", byteBuffer, n2);
                                return this.error();
                            }
                            this.content_length = by - 48;
                            break block12;
                        }
                        case connection: {
                            if (75 == n6) {
                                this.header_state = HState.matching_connection_keep_alive;
                                break block12;
                            }
                            if (67 == n6) {
                                this.header_state = HState.matching_connection_close;
                                break block12;
                            }
                            this.header_state = HState.general;
                            break block12;
                        }
                    }
                    this.header_state = HState.general;
                    break;
                }
                case header_value: {
                    if (13 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        this.state = State.header_almost_done;
                        break;
                    }
                    if (10 == by) {
                        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
                        this.header_value_mark = -1;
                        if (this.header_almost_done(by)) continue block163;
                        parserSettings.call_on_error(this, "incorrect header ending, expection LF", byteBuffer, n2);
                        return this.error();
                    }
                    n6 = this.upper(by);
                    switch (this.header_state) {
                        case general: {
                            break;
                        }
                        case connection: 
                        case transfer_encoding: {
                            parserSettings.call_on_error(this, "Shouldn't be here", byteBuffer, n2);
                            return this.error();
                        }
                        case content_length: {
                            if (32 == by) break;
                            if (!this.isDigit(by)) {
                                parserSettings.call_on_error(this, "Content-Length not numeric", byteBuffer, n2);
                                return this.error();
                            }
                            this.content_length *= 10;
                            this.content_length += by - 48;
                            break;
                        }
                        case matching_transfer_encoding_chunked: {
                            ++this.index;
                            if (this.index > C.CHUNKED.length || n6 != C.CHUNKED[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.CHUNKED.length - 1) continue block163;
                            this.header_state = HState.transfer_encoding_chunked;
                            break;
                        }
                        case matching_connection_keep_alive: {
                            ++this.index;
                            if (this.index > C.KEEP_ALIVE.length || n6 != C.KEEP_ALIVE[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.KEEP_ALIVE.length - 1) continue block163;
                            this.header_state = HState.connection_keep_alive;
                            break;
                        }
                        case matching_connection_close: {
                            ++this.index;
                            if (this.index > C.CLOSE.length || n6 != C.CLOSE[this.index]) {
                                this.header_state = HState.general;
                                break;
                            }
                            if (this.index != C.CLOSE.length - 1) continue block163;
                            this.header_state = HState.connection_close;
                            break;
                        }
                        case transfer_encoding_chunked: 
                        case connection_keep_alive: 
                        case connection_close: {
                            if (32 == by) continue block163;
                            this.header_state = HState.general;
                            break;
                        }
                        default: {
                            this.state = State.header_value;
                            this.header_state = HState.general;
                            break;
                        }
                    }
                    continue block163;
                }
                case header_almost_done: {
                    if (this.header_almost_done(by)) continue block163;
                    parserSettings.call_on_error(this, "incorrect header ending, expection LF", byteBuffer, n2);
                    return this.error();
                }
                case headers_almost_done: {
                    if (!this.headers_almost_done(by, parserSettings)) {
                        parserSettings.call_on_error(this, "header not properly completed", byteBuffer, n2);
                        return this.error();
                    }
                    if (!this.upgrade) continue block163;
                    return byteBuffer.position() - this.start_position;
                }
                case body_identity: {
                    n7 = this.min(n4 - n, this.content_length);
                    if (n7 <= 0) continue block163;
                    parserSettings.call_on_body(this, byteBuffer, n, n7);
                    byteBuffer.position(n + n7);
                    this.content_length -= n7;
                    if (this.content_length != 0) continue block163;
                    parserSettings.call_on_message_complete(this);
                    this.state = this.new_message();
                    break;
                }
                case body_identity_eof: {
                    n7 = n4 - n;
                    if (n7 <= 0) continue block163;
                    parserSettings.call_on_body(this, byteBuffer, n, n7);
                    byteBuffer.position(n + n7);
                    break;
                }
                case chunk_size_start: {
                    if (1 != this.nread) {
                        parserSettings.call_on_error(this, "nread != 1 (chunking)", byteBuffer, n2);
                        return this.error();
                    }
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    n6 = C.UNHEX[n5];
                    if (n6 == -1) {
                        parserSettings.call_on_error(this, "invalid hex char in chunk content length", byteBuffer, n2);
                        return this.error();
                    }
                    this.content_length = n6;
                    this.state = State.chunk_size;
                    break;
                }
                case chunk_size: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    if (13 == by) {
                        this.state = State.chunk_size_almost_done;
                        break;
                    }
                    n6 = C.UNHEX[n5];
                    if (n6 == -1) {
                        if (59 == by || 32 == by) {
                            this.state = State.chunk_parameters;
                            break;
                        }
                        parserSettings.call_on_error(this, "invalid hex char in chunk content length", byteBuffer, n2);
                        return this.error();
                    }
                    this.content_length *= 16;
                    this.content_length += n6;
                    break;
                }
                case chunk_parameters: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    if (13 != by) continue block163;
                    this.state = State.chunk_size_almost_done;
                    break;
                }
                case chunk_size_almost_done: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    if (this.strict && 10 != by) {
                        parserSettings.call_on_error(this, "expected LF at end of chunk size", byteBuffer, n2);
                        return this.error();
                    }
                    this.nread = 0;
                    if (0 == this.content_length) {
                        this.flags |= 8;
                        this.state = State.header_field_start;
                        break;
                    }
                    this.state = State.chunk_data;
                    break;
                }
                case chunk_data: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    n7 = this.min(n4 - n, this.content_length);
                    if (n7 > 0) {
                        parserSettings.call_on_body(this, byteBuffer, n, n7);
                        byteBuffer.position(n + n7);
                    }
                    if (n7 == this.content_length) {
                        this.state = State.chunk_data_almost_done;
                    }
                    this.content_length -= n7;
                    break;
                }
                case chunk_data_almost_done: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    if (this.strict && 13 != by) {
                        parserSettings.call_on_error(this, "chunk data terminated incorrectly, expected CR", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.chunk_data_done;
                    break;
                }
                case chunk_data_done: {
                    if (0 == (this.flags & 1)) {
                        parserSettings.call_on_error(this, "not chunked", byteBuffer, n2);
                        return this.error();
                    }
                    if (this.strict && 10 != by) {
                        parserSettings.call_on_error(this, "chunk data terminated incorrectly, expected LF", byteBuffer, n2);
                        return this.error();
                    }
                    this.state = State.chunk_size_start;
                    break;
                }
                default: {
                    parserSettings.call_on_error(this, "unhandled state", byteBuffer, n2);
                    return this.error();
                }
            }
        }
        n = byteBuffer.position();
        parserSettings.call_on_header_field(this, byteBuffer, this.header_field_mark, n - this.header_field_mark);
        parserSettings.call_on_header_value(this, byteBuffer, this.header_value_mark, n - this.header_value_mark);
        parserSettings.call_on_fragment(this, byteBuffer, this.fragment_mark, n - this.fragment_mark);
        parserSettings.call_on_query_string(this, byteBuffer, this.query_string_mark, n - this.query_string_mark);
        parserSettings.call_on_path(this, byteBuffer, this.path_mark, n - this.path_mark);
        parserSettings.call_on_url(this, byteBuffer, this.url_mark, n - this.url_mark);
        return byteBuffer.position() - this.start_position;
    }

    int error() {
        this.state = State.dead;
        return this.data.position() - this.start_position;
    }

    public boolean http_should_keep_alive() {
        if (this.http_major > 0 && this.http_minor > 0) {
            return 0 == (this.flags & 4);
        }
        return 0 != (this.flags & 2);
    }

    boolean isDigit(byte by) {
        return by >= 48 && by <= 57;
    }

    boolean isAtoZ(byte by) {
        byte by2 = this.lower(by);
        return by2 >= 97 && by2 <= 122;
    }

    byte lower(byte by) {
        return (byte)(by | 0x20);
    }

    byte upper(byte by) {
        char c = (char)by;
        return (byte)Character.toUpperCase(c);
    }

    byte token(byte by) {
        return (byte)C.tokens[by];
    }

    HTTPMethod start_req_method_assign(byte by) {
        switch (by) {
            case 67: {
                return HTTPMethod.HTTP_CONNECT;
            }
            case 68: {
                return HTTPMethod.HTTP_DELETE;
            }
            case 71: {
                return HTTPMethod.HTTP_GET;
            }
            case 72: {
                return HTTPMethod.HTTP_HEAD;
            }
            case 76: {
                return HTTPMethod.HTTP_LOCK;
            }
            case 77: {
                return HTTPMethod.HTTP_MKCOL;
            }
            case 78: {
                return HTTPMethod.HTTP_NOTIFY;
            }
            case 79: {
                return HTTPMethod.HTTP_OPTIONS;
            }
            case 80: {
                return HTTPMethod.HTTP_POST;
            }
            case 82: {
                return HTTPMethod.HTTP_REPORT;
            }
            case 83: {
                return HTTPMethod.HTTP_SUBSCRIBE;
            }
            case 84: {
                return HTTPMethod.HTTP_TRACE;
            }
            case 85: {
                return HTTPMethod.HTTP_UNLOCK;
            }
        }
        return null;
    }

    boolean header_almost_done(byte by) {
        if (this.strict && 10 != by) {
            return false;
        }
        this.state = State.header_field_start;
        switch (this.header_state) {
            case connection_keep_alive: {
                this.flags |= 2;
                break;
            }
            case connection_close: {
                this.flags |= 4;
                break;
            }
            case transfer_encoding_chunked: {
                this.flags |= 1;
                break;
            }
        }
        return true;
    }

    boolean headers_almost_done(byte by, ParserSettings parserSettings) {
        if (10 != by) {
            return false;
        }
        if (0 != (this.flags & 8)) {
            parserSettings.call_on_headers_complete(this);
            parserSettings.call_on_message_complete(this);
            this.state = this.new_message();
            return true;
        }
        this.nread = 0;
        if (0 != (this.flags & 0x10) || HTTPMethod.HTTP_CONNECT == this.method) {
            this.upgrade = true;
        }
        if (null != parserSettings.on_headers_complete) {
            parserSettings.call_on_headers_complete(this);
        }
        if (this.upgrade) {
            parserSettings.call_on_message_complete(this);
            this.state = State.body_identity_eof;
            return true;
        }
        if (0 != (this.flags & 0x20)) {
            parserSettings.call_on_message_complete(this);
            this.state = this.new_message();
        } else if (0 != (this.flags & 1)) {
            this.state = State.chunk_size_start;
        } else if (this.content_length == 0) {
            parserSettings.call_on_message_complete(this);
            this.state = this.new_message();
        } else if (this.content_length > 0) {
            this.state = State.body_identity;
        } else if (this.type == ParserType.HTTP_REQUEST || this.http_should_keep_alive()) {
            parserSettings.call_on_message_complete(this);
            this.state = this.new_message();
        } else {
            this.state = State.body_identity_eof;
        }
        return true;
    }

    final int min(int n, int n2) {
        return n < n2 ? n : n2;
    }

    State new_message() {
        if (this.HTTP_PARSER_STRICT) {
            return this.http_should_keep_alive() ? this.start_state() : State.dead;
        }
        return this.start_state();
    }

    State start_state() {
        return this.type == ParserType.HTTP_REQUEST ? State.start_req : State.start_res;
    }

    boolean parsing_header(State state2) {
        switch (state2) {
            case body_identity_eof: 
            case body_identity: 
            case chunk_data: 
            case chunk_data_almost_done: 
            case chunk_data_done: {
                return false;
            }
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum HState {
        general,
        C,
        CO,
        CON,
        matching_connection,
        matching_proxy_connection,
        matching_content_length,
        matching_transfer_encoding,
        matching_upgrade,
        connection,
        content_length,
        transfer_encoding,
        upgrade,
        matching_transfer_encoding_chunked,
        matching_connection_keep_alive,
        matching_connection_close,
        transfer_encoding_chunked,
        connection_keep_alive,
        connection_close;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        dead,
        start_res_or_res,
        res_or_resp_H,
        start_res,
        res_H,
        res_HT,
        res_HTT,
        res_HTTP,
        res_first_http_major,
        res_http_major,
        res_first_http_minor,
        res_http_minor,
        res_first_status_code,
        res_status_code,
        res_status,
        res_line_almost_done,
        start_req,
        req_method,
        req_spaces_before_url,
        req_schema,
        req_schema_slash,
        req_schema_slash_slash,
        req_host,
        req_port,
        req_path,
        req_query_string_start,
        req_query_string,
        req_fragment_start,
        req_fragment,
        req_http_start,
        req_http_H,
        req_http_HT,
        req_http_HTT,
        req_http_HTTP,
        req_first_http_major,
        req_http_major,
        req_first_http_minor,
        req_http_minor,
        req_line_almost_done,
        header_field_start,
        header_field,
        header_value_start,
        header_value,
        header_almost_done,
        chunk_size_start,
        chunk_size,
        chunk_parameters,
        chunk_size_almost_done,
        headers_almost_done,
        chunk_data,
        chunk_data_almost_done,
        chunk_data_done,
        body_identity,
        body_identity_eof;

    }

    static class C {
        static final int HTTP_MAX_HEADER_SIZE = 81920;
        static final int F_CHUNKED = 1;
        static final int F_CONNECTION_KEEP_ALIVE = 2;
        static final int F_CONNECTION_CLOSE = 4;
        static final int F_TRAILING = 8;
        static final int F_UPGRADE = 16;
        static final int F_SKIPBODY = 32;
        static final byte[] UPCASE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 95, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        static final byte[] CONNECTION = new byte[]{67, 79, 78, 78, 69, 67, 84, 73, 79, 78};
        static final byte[] PROXY_CONNECTION = new byte[]{80, 82, 79, 88, 89, 45, 67, 79, 78, 78, 69, 67, 84, 73, 79, 78};
        static final byte[] CONTENT_LENGTH = new byte[]{67, 79, 78, 84, 69, 78, 84, 45, 76, 69, 78, 71, 84, 72};
        static final byte[] TRANSFER_ENCODING = new byte[]{84, 82, 65, 78, 83, 70, 69, 82, 45, 69, 78, 67, 79, 68, 73, 78, 71};
        static final byte[] UPGRADE = new byte[]{85, 80, 71, 82, 65, 68, 69};
        static final byte[] CHUNKED = new byte[]{67, 72, 85, 78, 75, 69, 68};
        static final byte[] KEEP_ALIVE = new byte[]{75, 69, 69, 80, 45, 65, 76, 73, 86, 69};
        static final byte[] CLOSE = new byte[]{67, 76, 79, 83, 69};
        static final char[] tokens = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '\u0000', '\u0000', '*', '+', '\u0000', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '\u0000', '\u0000', '\u0000', '_', '\u0000', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u0000', '|', '}', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'};
        static final byte[] UNHEX = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        static final boolean[] normal_url_char = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
        public static final byte A = 65;
        public static final byte B = 66;
        public static final byte C = 67;
        public static final byte D = 68;
        public static final byte E = 69;
        public static final byte F = 70;
        public static final byte G = 71;
        public static final byte H = 72;
        public static final byte I = 73;
        public static final byte J = 74;
        public static final byte K = 75;
        public static final byte L = 76;
        public static final byte M = 77;
        public static final byte N = 78;
        public static final byte O = 79;
        public static final byte P = 80;
        public static final byte Q = 81;
        public static final byte R = 82;
        public static final byte S = 83;
        public static final byte T = 84;
        public static final byte U = 85;
        public static final byte V = 86;
        public static final byte W = 87;
        public static final byte X = 88;
        public static final byte Y = 89;
        public static final byte Z = 90;
        public static final byte CR = 13;
        public static final byte LF = 10;
        public static final byte DOT = 46;
        public static final byte SPACE = 32;
        public static final byte SEMI = 59;
        public static final byte COLON = 58;
        public static final byte HASH = 35;
        public static final byte QMARK = 63;
        public static final byte SLASH = 47;
        public static final byte DASH = 45;
        public static final byte STAR = 42;
        public static final byte NULL = 0;

        C() {
        }
    }
}

