/*
 * Decompiled with CFR 0.152.
 */
package hitimes;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"Hitimes::Stats"})
public class HitimesStats
extends RubyObject {
    private double min = 0.0;
    private double max = 0.0;
    private double sum = 0.0;
    private double sumsq = 0.0;
    private long count = 0L;
    public static final ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby2, RubyClass rubyClass) {
            return new HitimesStats(ruby2, rubyClass);
        }
    };

    public HitimesStats(Ruby ruby2, RubyClass rubyClass) {
        super(ruby2, rubyClass);
    }

    @JRubyMethod(name={"update"}, required=1, argTypes={RubyNumeric.class})
    public IRubyObject update(IRubyObject iRubyObject) {
        double d = RubyNumeric.num2dbl(iRubyObject);
        if (0L == this.count) {
            this.min = this.max = d;
        } else {
            this.min = d < this.min ? d : this.min;
            this.max = d > this.max ? d : this.max;
        }
        ++this.count;
        this.sum += d;
        this.sumsq += d * d;
        return iRubyObject;
    }

    @JRubyMethod(name={"mean"})
    public IRubyObject mean() {
        double d = 0.0;
        if (this.count > 0L) {
            d = this.sum / (double)this.count;
        }
        return this.getRuntime().newFloat(d);
    }

    @JRubyMethod(name={"rate"})
    public IRubyObject rate() {
        double d = 0.0;
        if (this.sum > 0.0) {
            d = (double)this.count / this.sum;
        }
        return this.getRuntime().newFloat(d);
    }

    @JRubyMethod(name={"stddev"})
    public IRubyObject stddev() {
        double d = 0.0;
        if (this.count > 1L) {
            double d2 = this.sum * this.sum;
            d = Math.sqrt((this.sumsq - d2 / (double)this.count) / (double)(this.count - 1L));
        }
        return this.getRuntime().newFloat(d);
    }

    @JRubyMethod(name={"min"})
    public IRubyObject min() {
        return this.getRuntime().newFloat(this.min);
    }

    @JRubyMethod(name={"max"})
    public IRubyObject max() {
        return this.getRuntime().newFloat(this.max);
    }

    @JRubyMethod(name={"sum"})
    public IRubyObject sum() {
        return this.getRuntime().newFloat(this.sum);
    }

    @JRubyMethod(name={"sumsq"})
    public IRubyObject sumsq() {
        return this.getRuntime().newFloat(this.sumsq);
    }

    @JRubyMethod(name={"count"})
    public IRubyObject count() {
        return this.getRuntime().newFixnum(this.count);
    }
}

