/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.technique;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;

public class LineStringSelfIntersections {
    public static void main(String[] args2) throws Exception {
        WKTReader rdr = new WKTReader();
        LineString line1 = (LineString)rdr.read("LINESTRING (0 0, 10 10, 20 20)");
        LineStringSelfIntersections.showSelfIntersections(line1);
        LineString line2 = (LineString)rdr.read("LINESTRING (0 40, 60 40, 60 0, 20 0, 20 60)");
        LineStringSelfIntersections.showSelfIntersections(line2);
    }

    public static void showSelfIntersections(LineString line) {
        System.out.println("Line: " + line);
        System.out.println("Self Intersections: " + LineStringSelfIntersections.lineStringSelfIntersections(line));
    }

    public static Geometry lineStringSelfIntersections(LineString line) {
        Geometry lineEndPts = LineStringSelfIntersections.getEndPoints(line);
        Geometry nodedLine = line.union(lineEndPts);
        Geometry nodedEndPts = LineStringSelfIntersections.getEndPoints(nodedLine);
        Geometry selfIntersections = nodedEndPts.difference(lineEndPts);
        return selfIntersections;
    }

    public static Geometry getEndPoints(Geometry g) {
        ArrayList<Coordinate> endPtList = new ArrayList<Coordinate>();
        if (g instanceof LineString) {
            LineString line = (LineString)g;
            endPtList.add(line.getCoordinateN(0));
            endPtList.add(line.getCoordinateN(line.getNumPoints() - 1));
        } else if (g instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)g;
            for (int i2 = 0; i2 < mls.getNumGeometries(); ++i2) {
                LineString line = (LineString)mls.getGeometryN(i2);
                endPtList.add(line.getCoordinateN(0));
                endPtList.add(line.getCoordinateN(line.getNumPoints() - 1));
            }
        }
        Coordinate[] endPts = CoordinateArrays.toCoordinateArray(endPtList);
        return new GeometryFactory().createMultiPoint(endPts);
    }
}

