/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom.prep;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;

public class PreparedGeometryExample {
    static GeometryFactory geomFact = new GeometryFactory();
    static final int MAX_ITER = 100000;

    public static void main(String[] args2) throws Exception {
        Geometry circle = PreparedGeometryExample.createCircle();
        PreparedGeometry prepCircle = PreparedGeometryFactory.prepare(circle);
        int count2 = 0;
        int inCount = 0;
        for (int i2 = 0; i2 < 100000; ++i2) {
            ++count2;
            Point randPt = PreparedGeometryExample.createRandomPoint();
            if (!prepCircle.intersects(randPt)) continue;
            ++inCount;
        }
        double approxPi = 4.0 * (double)inCount / (double)count2;
        double approxDiffPct = 1.0 - approxPi / Math.PI;
        System.out.println("Approximation to PI: " + approxPi + "  ( % difference from actual = " + 100.0 * approxDiffPct + " )");
    }

    static Geometry createCircle() {
        Point centrePt = geomFact.createPoint(new Coordinate(0.5, 0.5));
        return centrePt.buffer(0.5, 20);
    }

    static Point createRandomPoint() {
        return geomFact.createPoint(new Coordinate(Math.random(), Math.random()));
    }
}

