/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jtsexample.geom.ExtendedCoordinate;

public class ExtendedCoordinateSequence
implements CoordinateSequence {
    private ExtendedCoordinate[] coordinates;

    public static ExtendedCoordinate[] copy(Coordinate[] coordinates) {
        ExtendedCoordinate[] copy = new ExtendedCoordinate[coordinates.length];
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            copy[i2] = new ExtendedCoordinate(coordinates[i2]);
        }
        return copy;
    }

    public static ExtendedCoordinate[] copy(CoordinateSequence coordSeq) {
        ExtendedCoordinate[] copy = new ExtendedCoordinate[coordSeq.size()];
        for (int i2 = 0; i2 < coordSeq.size(); ++i2) {
            copy[i2] = new ExtendedCoordinate(coordSeq.getCoordinate(i2));
        }
        return copy;
    }

    public ExtendedCoordinateSequence(ExtendedCoordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    public ExtendedCoordinateSequence(Coordinate[] copyCoords) {
        this.coordinates = ExtendedCoordinateSequence.copy(copyCoords);
    }

    public ExtendedCoordinateSequence(CoordinateSequence coordSeq) {
        this.coordinates = ExtendedCoordinateSequence.copy(coordSeq);
    }

    public ExtendedCoordinateSequence(int size2) {
        this.coordinates = new ExtendedCoordinate[size2];
        for (int i2 = 0; i2 < size2; ++i2) {
            this.coordinates[i2] = new ExtendedCoordinate();
        }
    }

    public int getDimension() {
        return 4;
    }

    public Coordinate getCoordinate(int i2) {
        return this.coordinates[i2];
    }

    public Coordinate getCoordinateCopy(int index2) {
        return new Coordinate(this.coordinates[index2]);
    }

    public void getCoordinate(int index2, Coordinate coord) {
        coord.x = this.coordinates[index2].x;
        coord.y = this.coordinates[index2].y;
    }

    public double getX(int index2) {
        return this.coordinates[index2].x;
    }

    public double getY(int index2) {
        return this.coordinates[index2].y;
    }

    public double getOrdinate(int index2, int ordinateIndex) {
        switch (ordinateIndex) {
            case 0: {
                return this.coordinates[index2].x;
            }
            case 1: {
                return this.coordinates[index2].y;
            }
            case 2: {
                return this.coordinates[index2].z;
            }
            case 3: {
                return this.coordinates[index2].getM();
            }
        }
        return Double.NaN;
    }

    public void setOrdinate(int index2, int ordinateIndex, double value2) {
        switch (ordinateIndex) {
            case 0: {
                this.coordinates[index2].x = value2;
                break;
            }
            case 1: {
                this.coordinates[index2].y = value2;
                break;
            }
            case 2: {
                this.coordinates[index2].z = value2;
                break;
            }
            case 3: {
                this.coordinates[index2].setM(value2);
            }
        }
    }

    public Object clone() {
        ExtendedCoordinate[] cloneCoordinates = new ExtendedCoordinate[this.size()];
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            cloneCoordinates[i2] = (ExtendedCoordinate)this.coordinates[i2].clone();
        }
        return new ExtendedCoordinateSequence(cloneCoordinates);
    }

    public int size() {
        return this.coordinates.length;
    }

    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    public Envelope expandEnvelope(Envelope env) {
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            env.expandToInclude(this.coordinates[i2]);
        }
        return env;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("ExtendedCoordinateSequence [");
        for (int i2 = 0; i2 < this.coordinates.length; ++i2) {
            if (i2 > 0) {
                strBuf.append(", ");
            }
            strBuf.append(this.coordinates[i2]);
        }
        strBuf.append("]");
        return strBuf.toString();
    }
}

