/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.triangulate;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VertexTaggedGeometryDataMapper {
    private Map coordDataMap = new TreeMap();

    public void loadSourceGeometries(Collection geoms) {
        for (Geometry geom : geoms) {
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
        }
    }

    public void loadSourceGeometries(Geometry geomColl) {
        for (int i2 = 0; i2 < geomColl.getNumGeometries(); ++i2) {
            Geometry geom = geomColl.getGeometryN(i2);
            this.loadVertices(geom.getCoordinates(), geom.getUserData());
        }
    }

    private void loadVertices(Coordinate[] pts, Object data2) {
        for (int i2 = 0; i2 < pts.length; ++i2) {
            this.coordDataMap.put(pts[i2], data2);
        }
    }

    public List getCoordinates() {
        return new ArrayList(this.coordDataMap.keySet());
    }

    public void transferData(Geometry targetGeom) {
        for (int i2 = 0; i2 < targetGeom.getNumGeometries(); ++i2) {
            Geometry geom = targetGeom.getGeometryN(i2);
            Coordinate vertexKey = (Coordinate)geom.getUserData();
            if (vertexKey == null) continue;
            geom.setUserData(this.coordDataMap.get(vertexKey));
        }
    }
}

