/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.GeometryEditor;

public class PrecisionReducerCoordinateOperation
extends GeometryEditor.CoordinateOperation {
    private PrecisionModel targetPM;
    private boolean removeCollapsed = true;

    public PrecisionReducerCoordinateOperation(PrecisionModel targetPM, boolean removeCollapsed) {
        this.targetPM = targetPM;
        this.removeCollapsed = removeCollapsed;
    }

    public Coordinate[] edit(Coordinate[] coordinates, Geometry geom) {
        if (coordinates.length == 0) {
            return null;
        }
        Coordinate[] reducedCoords = new Coordinate[coordinates.length];
        for (int i2 = 0; i2 < coordinates.length; ++i2) {
            Coordinate coord = new Coordinate(coordinates[i2]);
            this.targetPM.makePrecise(coord);
            reducedCoords[i2] = coord;
        }
        CoordinateList noRepeatedCoordList = new CoordinateList(reducedCoords, false);
        Coordinate[] noRepeatedCoords = noRepeatedCoordList.toCoordinateArray();
        int minLength = 0;
        if (geom instanceof LineString) {
            minLength = 2;
        }
        if (geom instanceof LinearRing) {
            minLength = 4;
        }
        Coordinate[] collapsedCoords = reducedCoords;
        if (this.removeCollapsed) {
            collapsedCoords = null;
        }
        if (noRepeatedCoords.length < minLength) {
            return collapsedCoords;
        }
        return noRepeatedCoords;
    }
}

