/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.valid;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.MCPointInRing;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.EdgeIntersectionList;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.operation.valid.ConnectedInteriorTester;
import com.vividsolutions.jts.operation.valid.ConsistentAreaTester;
import com.vividsolutions.jts.operation.valid.IndexedNestedRingTester;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.util.Assert;
import java.util.Iterator;
import java.util.TreeSet;

public class IsValidOp {
    private Geometry parentGeometry;
    private boolean isSelfTouchingRingFormingHoleValid = false;
    private TopologyValidationError validErr;

    public static boolean isValid(Geometry geom) {
        IsValidOp isValidOp = new IsValidOp(geom);
        return isValidOp.isValid();
    }

    public static boolean isValid(Coordinate coord) {
        if (Double.isNaN(coord.x)) {
            return false;
        }
        if (Double.isInfinite(coord.x)) {
            return false;
        }
        if (Double.isNaN(coord.y)) {
            return false;
        }
        return !Double.isInfinite(coord.y);
    }

    public static Coordinate findPtNotNode(Coordinate[] testCoords, LinearRing searchRing, GeometryGraph graph) {
        Edge searchEdge = graph.findEdge(searchRing);
        EdgeIntersectionList eiList = searchEdge.getEdgeIntersectionList();
        for (int i2 = 0; i2 < testCoords.length; ++i2) {
            Coordinate pt = testCoords[i2];
            if (eiList.isIntersection(pt)) continue;
            return pt;
        }
        return null;
    }

    public IsValidOp(Geometry parentGeometry) {
        this.parentGeometry = parentGeometry;
    }

    public void setSelfTouchingRingFormingHoleValid(boolean isValid) {
        this.isSelfTouchingRingFormingHoleValid = isValid;
    }

    public boolean isValid() {
        this.checkValid(this.parentGeometry);
        return this.validErr == null;
    }

    public TopologyValidationError getValidationError() {
        this.checkValid(this.parentGeometry);
        return this.validErr;
    }

    private void checkValid(Geometry g) {
        this.validErr = null;
        if (g.isEmpty()) {
            return;
        }
        if (g instanceof Point) {
            this.checkValid((Point)g);
        } else if (g instanceof MultiPoint) {
            this.checkValid((MultiPoint)g);
        } else if (g instanceof LinearRing) {
            this.checkValid((LinearRing)g);
        } else if (g instanceof LineString) {
            this.checkValid((LineString)g);
        } else if (g instanceof Polygon) {
            this.checkValid((Polygon)g);
        } else if (g instanceof MultiPolygon) {
            this.checkValid((MultiPolygon)g);
        } else if (g instanceof GeometryCollection) {
            this.checkValid((GeometryCollection)g);
        } else {
            throw new UnsupportedOperationException(g.getClass().getName());
        }
    }

    private void checkValid(Point g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(MultiPoint g) {
        this.checkInvalidCoordinates(g.getCoordinates());
    }

    private void checkValid(LineString g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
    }

    private void checkValid(LinearRing g) {
        this.checkInvalidCoordinates(g.getCoordinates());
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRing(g);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        RobustLineIntersector li = new RobustLineIntersector();
        graph.computeSelfNodes(li, true);
        this.checkNoSelfIntersectingRings(graph);
    }

    private void checkValid(Polygon g) {
        this.checkInvalidCoordinates(g);
        if (this.validErr != null) {
            return;
        }
        this.checkClosedRings(g);
        if (this.validErr != null) {
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        this.checkHolesInShell(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkHolesNotNested(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(MultiPolygon g) {
        Polygon p2;
        int i2;
        for (int i3 = 0; i3 < g.getNumGeometries(); ++i3) {
            Polygon p3 = (Polygon)g.getGeometryN(i3);
            this.checkInvalidCoordinates(p3);
            if (this.validErr != null) {
                return;
            }
            this.checkClosedRings(p3);
            if (this.validErr == null) continue;
            return;
        }
        GeometryGraph graph = new GeometryGraph(0, g);
        this.checkTooFewPoints(graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConsistentArea(graph);
        if (this.validErr != null) {
            return;
        }
        if (!this.isSelfTouchingRingFormingHoleValid) {
            this.checkNoSelfIntersectingRings(graph);
            if (this.validErr != null) {
                return;
            }
        }
        for (i2 = 0; i2 < g.getNumGeometries(); ++i2) {
            p2 = (Polygon)g.getGeometryN(i2);
            this.checkHolesInShell(p2, graph);
            if (this.validErr == null) continue;
            return;
        }
        for (i2 = 0; i2 < g.getNumGeometries(); ++i2) {
            p2 = (Polygon)g.getGeometryN(i2);
            this.checkHolesNotNested(p2, graph);
            if (this.validErr == null) continue;
            return;
        }
        this.checkShellsNotNested(g, graph);
        if (this.validErr != null) {
            return;
        }
        this.checkConnectedInteriors(graph);
    }

    private void checkValid(GeometryCollection gc2) {
        for (int i2 = 0; i2 < gc2.getNumGeometries(); ++i2) {
            Geometry g = gc2.getGeometryN(i2);
            this.checkValid(g);
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkInvalidCoordinates(Coordinate[] coords) {
        for (int i2 = 0; i2 < coords.length; ++i2) {
            if (IsValidOp.isValid(coords[i2])) continue;
            this.validErr = new TopologyValidationError(10, coords[i2]);
            return;
        }
    }

    private void checkInvalidCoordinates(Polygon poly) {
        this.checkInvalidCoordinates(poly.getExteriorRing().getCoordinates());
        if (this.validErr != null) {
            return;
        }
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            this.checkInvalidCoordinates(poly.getInteriorRingN(i2).getCoordinates());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRings(Polygon poly) {
        this.checkClosedRing((LinearRing)poly.getExteriorRing());
        if (this.validErr != null) {
            return;
        }
        for (int i2 = 0; i2 < poly.getNumInteriorRing(); ++i2) {
            this.checkClosedRing((LinearRing)poly.getInteriorRingN(i2));
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkClosedRing(LinearRing ring) {
        if (!ring.isClosed()) {
            Coordinate pt = null;
            if (ring.getNumPoints() >= 1) {
                pt = ring.getCoordinateN(0);
            }
            this.validErr = new TopologyValidationError(11, pt);
        }
    }

    private void checkTooFewPoints(GeometryGraph graph) {
        if (graph.hasTooFewPoints()) {
            this.validErr = new TopologyValidationError(9, graph.getInvalidPoint());
            return;
        }
    }

    private void checkConsistentArea(GeometryGraph graph) {
        ConsistentAreaTester cat = new ConsistentAreaTester(graph);
        boolean isValidArea = cat.isNodeConsistentArea();
        if (!isValidArea) {
            this.validErr = new TopologyValidationError(5, cat.getInvalidPoint());
            return;
        }
        if (cat.hasDuplicateRings()) {
            this.validErr = new TopologyValidationError(8, cat.getInvalidPoint());
        }
    }

    private void checkNoSelfIntersectingRings(GeometryGraph graph) {
        Iterator i2 = graph.getEdgeIterator();
        while (i2.hasNext()) {
            Edge e = (Edge)i2.next();
            this.checkNoSelfIntersectingRing(e.getEdgeIntersectionList());
            if (this.validErr == null) continue;
            return;
        }
    }

    private void checkNoSelfIntersectingRing(EdgeIntersectionList eiList) {
        TreeSet<Coordinate> nodeSet = new TreeSet<Coordinate>();
        boolean isFirst = true;
        Iterator i2 = eiList.iterator();
        while (i2.hasNext()) {
            EdgeIntersection ei = (EdgeIntersection)i2.next();
            if (isFirst) {
                isFirst = false;
                continue;
            }
            if (nodeSet.contains(ei.coord)) {
                this.validErr = new TopologyValidationError(6, ei.coord);
                return;
            }
            nodeSet.add(ei.coord);
        }
    }

    private void checkHolesInShell(Polygon p2, GeometryGraph graph) {
        LinearRing shell = (LinearRing)p2.getExteriorRing();
        MCPointInRing pir = new MCPointInRing(shell);
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            boolean outside;
            LinearRing hole = (LinearRing)p2.getInteriorRingN(i2);
            Coordinate holePt = IsValidOp.findPtNotNode(hole.getCoordinates(), shell, graph);
            if (holePt == null) {
                return;
            }
            boolean bl = outside = !pir.isInside(holePt);
            if (!outside) continue;
            this.validErr = new TopologyValidationError(2, holePt);
            return;
        }
    }

    private void checkHolesNotNested(Polygon p2, GeometryGraph graph) {
        IndexedNestedRingTester nestedTester = new IndexedNestedRingTester(graph);
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            LinearRing innerHole = (LinearRing)p2.getInteriorRingN(i2);
            nestedTester.add(innerHole);
        }
        boolean isNonNested = nestedTester.isNonNested();
        if (!isNonNested) {
            this.validErr = new TopologyValidationError(3, nestedTester.getNestedPoint());
        }
    }

    private void checkShellsNotNested(MultiPolygon mp, GeometryGraph graph) {
        for (int i2 = 0; i2 < mp.getNumGeometries(); ++i2) {
            Polygon p2 = (Polygon)mp.getGeometryN(i2);
            LinearRing shell = (LinearRing)p2.getExteriorRing();
            for (int j = 0; j < mp.getNumGeometries(); ++j) {
                if (i2 == j) continue;
                Polygon p22 = (Polygon)mp.getGeometryN(j);
                this.checkShellNotNested(shell, p22, graph);
                if (this.validErr == null) continue;
                return;
            }
        }
    }

    private void checkShellNotNested(LinearRing shell, Polygon p2, GeometryGraph graph) {
        Coordinate[] shellPts = shell.getCoordinates();
        LinearRing polyShell = (LinearRing)p2.getExteriorRing();
        Coordinate[] polyPts = polyShell.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, polyShell, graph);
        if (shellPt == null) {
            return;
        }
        boolean insidePolyShell = CGAlgorithms.isPointInRing(shellPt, polyPts);
        if (!insidePolyShell) {
            return;
        }
        if (p2.getNumInteriorRing() <= 0) {
            this.validErr = new TopologyValidationError(7, shellPt);
            return;
        }
        Coordinate badNestedPt = null;
        for (int i2 = 0; i2 < p2.getNumInteriorRing(); ++i2) {
            LinearRing hole = (LinearRing)p2.getInteriorRingN(i2);
            badNestedPt = this.checkShellInsideHole(shell, hole, graph);
            if (badNestedPt != null) continue;
            return;
        }
        this.validErr = new TopologyValidationError(7, badNestedPt);
    }

    private Coordinate checkShellInsideHole(LinearRing shell, LinearRing hole, GeometryGraph graph) {
        boolean insideHole;
        Coordinate[] shellPts = shell.getCoordinates();
        Coordinate[] holePts = hole.getCoordinates();
        Coordinate shellPt = IsValidOp.findPtNotNode(shellPts, hole, graph);
        if (shellPt != null && !(insideHole = CGAlgorithms.isPointInRing(shellPt, holePts))) {
            return shellPt;
        }
        Coordinate holePt = IsValidOp.findPtNotNode(holePts, shell, graph);
        if (holePt != null) {
            boolean insideShell = CGAlgorithms.isPointInRing(holePt, shellPts);
            if (insideShell) {
                return holePt;
            }
            return null;
        }
        Assert.shouldNeverReachHere("points in shell and hole appear to be equal");
        return null;
    }

    private void checkConnectedInteriors(GeometryGraph graph) {
        ConnectedInteriorTester cit = new ConnectedInteriorTester(graph);
        if (!cit.isInteriorsConnected()) {
            this.validErr = new TopologyValidationError(4, cit.getCoordinate());
        }
    }
}

