/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;
import com.vividsolutions.jts.operation.predicate.SegmentIntersectionTester;
import java.util.List;

class LineIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    private LineString rectLine;
    private Envelope rectEnv;
    private boolean intersects = false;

    public LineIntersectsVisitor(Polygon rectangle) {
        this.rectLine = rectangle.getExteriorRing();
        this.rectEnv = rectangle.getEnvelopeInternal();
    }

    public boolean intersects() {
        return this.intersects;
    }

    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        this.computeSegmentIntersection(geom);
    }

    private void computeSegmentIntersection(Geometry geom) {
        SegmentIntersectionTester si = new SegmentIntersectionTester();
        List lines2 = LinearComponentExtracter.getLines(geom);
        boolean hasIntersection = si.hasIntersectionWithLineStrings(this.rectLine, lines2);
        if (hasIntersection) {
            this.intersects = true;
            return;
        }
    }

    protected boolean isDone() {
        return this.intersects;
    }
}

