/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay;

import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.DirectedEdge;
import com.vividsolutions.jts.geomgraph.DirectedEdgeStar;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.geomgraph.Node;
import com.vividsolutions.jts.geomgraph.PlanarGraph;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ConsistentPolygonRingChecker {
    private PlanarGraph graph;
    private final int SCANNING_FOR_INCOMING = 1;
    private final int LINKING_TO_OUTGOING = 2;

    public ConsistentPolygonRingChecker(PlanarGraph graph) {
        this.graph = graph;
    }

    public void checkAll() {
        this.check(1);
        this.check(3);
        this.check(2);
        this.check(4);
    }

    public void check(int opCode) {
        Iterator nodeit = this.graph.getNodeIterator();
        while (nodeit.hasNext()) {
            Node node = (Node)nodeit.next();
            this.testLinkResultDirectedEdges((DirectedEdgeStar)node.getEdges(), opCode);
        }
    }

    private List getPotentialResultAreaEdges(DirectedEdgeStar deStar, int opCode) {
        ArrayList<DirectedEdge> resultAreaEdgeList = new ArrayList<DirectedEdge>();
        Iterator it = deStar.iterator();
        while (it.hasNext()) {
            DirectedEdge de = (DirectedEdge)it.next();
            if (!this.isPotentialResultAreaEdge(de, opCode) && !this.isPotentialResultAreaEdge(de.getSym(), opCode)) continue;
            resultAreaEdgeList.add(de);
        }
        return resultAreaEdgeList;
    }

    private boolean isPotentialResultAreaEdge(DirectedEdge de, int opCode) {
        Label label = de.getLabel();
        return label.isArea() && !de.isInteriorAreaEdge() && OverlayOp.isResultOfOp(label.getLocation(0, 2), label.getLocation(1, 2), opCode);
    }

    private void testLinkResultDirectedEdges(DirectedEdgeStar deStar, int opCode) {
        List ringEdges = this.getPotentialResultAreaEdges(deStar, opCode);
        DirectedEdge firstOut = null;
        DirectedEdge incoming = null;
        int state2 = 1;
        block4: for (int i2 = 0; i2 < ringEdges.size(); ++i2) {
            DirectedEdge nextOut = (DirectedEdge)ringEdges.get(i2);
            DirectedEdge nextIn = nextOut.getSym();
            if (!nextOut.getLabel().isArea()) continue;
            if (firstOut == null && this.isPotentialResultAreaEdge(nextOut, opCode)) {
                firstOut = nextOut;
            }
            switch (state2) {
                case 1: {
                    if (!this.isPotentialResultAreaEdge(nextIn, opCode)) continue block4;
                    incoming = nextIn;
                    state2 = 2;
                    continue block4;
                }
                case 2: {
                    if (!this.isPotentialResultAreaEdge(nextOut, opCode)) continue block4;
                    state2 = 1;
                }
            }
        }
        if (state2 == 2 && firstOut == null) {
            throw new TopologyException("no outgoing dirEdge found", deStar.getCoordinate());
        }
    }
}

