/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.noding.snapround;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.noding.NodedSegmentString;
import com.vividsolutions.jts.noding.NodingValidator;
import com.vividsolutions.jts.noding.SegmentString;
import com.vividsolutions.jts.noding.snapround.MCIndexSnapRounder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class GeometryNoder {
    private GeometryFactory geomFact;
    private PrecisionModel pm;
    private boolean isValidityChecked = false;

    public GeometryNoder(PrecisionModel pm) {
        this.pm = pm;
    }

    public void setValidate(boolean isValidityChecked) {
        this.isValidityChecked = isValidityChecked;
    }

    public List node(Collection geoms) {
        Geometry geom0 = (Geometry)geoms.iterator().next();
        this.geomFact = geom0.getFactory();
        List segStrings = this.toSegmentStrings(this.extractLines(geoms));
        MCIndexSnapRounder sr = new MCIndexSnapRounder(this.pm);
        sr.computeNodes(segStrings);
        Collection nodedLines = sr.getNodedSubstrings();
        if (this.isValidityChecked) {
            NodingValidator nv = new NodingValidator(nodedLines);
            nv.checkValid();
        }
        return this.toLineStrings(nodedLines);
    }

    private List toLineStrings(Collection segStrings) {
        ArrayList<LineString> lines2 = new ArrayList<LineString>();
        for (SegmentString ss : segStrings) {
            if (ss.size() < 2) continue;
            lines2.add(this.geomFact.createLineString(ss.getCoordinates()));
        }
        return lines2;
    }

    private List extractLines(Collection geoms) {
        ArrayList lines2 = new ArrayList();
        LinearComponentExtracter lce = new LinearComponentExtracter(lines2);
        for (Geometry geom : geoms) {
            geom.apply(lce);
        }
        return lines2;
    }

    private List toSegmentStrings(Collection lines2) {
        ArrayList<NodedSegmentString> segStrings = new ArrayList<NodedSegmentString>();
        for (LineString line : lines2) {
            segStrings.add(new NodedSegmentString(line.getCoordinates(), null));
        }
        return segStrings;
    }
}

