/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.linearref;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.linearref.LinearIterator;
import com.vividsolutions.jts.linearref.LinearLocation;

public class LengthLocationMap {
    private Geometry linearGeom;

    public static LinearLocation getLocation(Geometry linearGeom, double length2) {
        LengthLocationMap locater = new LengthLocationMap(linearGeom);
        return locater.getLocation(length2);
    }

    public static double getLength(Geometry linearGeom, LinearLocation loc) {
        LengthLocationMap locater = new LengthLocationMap(linearGeom);
        return locater.getLength(loc);
    }

    public LengthLocationMap(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public LinearLocation getLocation(double length2) {
        double forwardLength = length2;
        if (length2 < 0.0) {
            double lineLen = this.linearGeom.getLength();
            forwardLength = lineLen + length2;
        }
        return this.getLocationForward(forwardLength);
    }

    private LinearLocation getLocationForward(double length2) {
        if (length2 <= 0.0) {
            return new LinearLocation();
        }
        double totalLength = 0.0;
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (!it.isEndOfLine()) {
                Coordinate p0 = it.getSegmentStart();
                Coordinate p1 = it.getSegmentEnd();
                double segLen = p1.distance(p0);
                if (totalLength + segLen > length2) {
                    double frac2 = (length2 - totalLength) / segLen;
                    int compIndex = it.getComponentIndex();
                    int segIndex = it.getVertexIndex();
                    return new LinearLocation(compIndex, segIndex, frac2);
                }
                totalLength += segLen;
            }
            it.next();
        }
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    public double getLength(LinearLocation loc) {
        double totalLength = 0.0;
        LinearIterator it = new LinearIterator(this.linearGeom);
        while (it.hasNext()) {
            if (!it.isEndOfLine()) {
                Coordinate p0 = it.getSegmentStart();
                Coordinate p1 = it.getSegmentEnd();
                double segLen = p1.distance(p0);
                if (loc.getComponentIndex() == it.getComponentIndex() && loc.getSegmentIndex() == it.getVertexIndex()) {
                    return totalLength + segLen * loc.getSegmentFraction();
                }
                totalLength += segLen;
            }
            it.next();
        }
        return totalLength;
    }
}

